/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins;

import com.vmware.vim25.mo.VirtualMachine;
import com.vmware.vim25.mo.VirtualMachineSnapshot;
import hudson.AbortException;
import hudson.Extension;
import hudson.Functions;
import hudson.Util;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.Slave;
import hudson.model.TaskListener;
import hudson.model.queue.CauseOfBlockage;
import hudson.slaves.Cloud;
import hudson.slaves.CloudSlaveRetentionStrategy;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.ComputerListener;
import hudson.slaves.NodeProperty;
import hudson.slaves.OfflineCause;
import hudson.slaves.RetentionStrategy;
import hudson.slaves.SlaveComputer;
import hudson.util.FormValidation;
import hudson.util.TimeUnit2;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jenkinsci.plugins.vSphereCloud;
import org.jenkinsci.plugins.vSphereCloudLauncher;
import org.jenkinsci.plugins.vSphereCloudSlaveComputer;
import org.jenkinsci.plugins.vSphereCloudSlaveTemplateComputer;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class vSphereCloudSlave
extends Slave {
    private final String vsDescription;
    private final String vmName;
    private final String snapName;
    private final Boolean waitForVMTools;
    private final String launchDelay;
    private final String idleOption;
    private Integer LimitedTestRunCount = 0;
    private transient Integer NumberOfLimitedTestRuns = 0;
    public transient Boolean doingLastInLimitedTestRun = Boolean.FALSE;
    private static ConcurrentHashMap<vSphereCloudSlave, ProbableLaunchData> ProbableLaunch;
    private static final Boolean ProbableLaunchLock;
    public transient Boolean slaveIsStarting = Boolean.FALSE;
    public transient Boolean slaveIsDisconnecting = Boolean.FALSE;
    private static Map<Queue.Task, Slave> acceptedItemsMap;
    private static final Object acceptedItemsLock;
    private static ConcurrentHashMap<Run, Computer> RunToSlaveMapper;

    @DataBoundConstructor
    public vSphereCloudSlave(String name, String nodeDescription, String remoteFS, String numExecutors, Node.Mode mode, String labelString, ComputerLauncher delegateLauncher, RetentionStrategy retentionStrategy, List<? extends NodeProperty<?>> nodeProperties, String vsDescription, String vmName, boolean launchSupportForced, boolean waitForVMTools, String snapName, String launchDelay, String idleOption, String LimitedTestRunCount) throws Descriptor.FormException, IOException {
        this(name, nodeDescription, remoteFS, numExecutors, mode, labelString, delegateLauncher, retentionStrategy, nodeProperties, vsDescription, vmName, launchSupportForced, waitForVMTools, snapName, launchDelay, idleOption, LimitedTestRunCount, false);
    }

    public vSphereCloudSlave(String name, String nodeDescription, String remoteFS, String numExecutors, Node.Mode mode, String labelString, ComputerLauncher delegateLauncher, RetentionStrategy retentionStrategy, List<? extends NodeProperty<?>> nodeProperties, String vsDescription, String vmName, boolean launchSupportForced, boolean waitForVMTools, String snapName, String launchDelay, String idleOption, String LimitedTestRunCount, boolean isTemplate) throws Descriptor.FormException, IOException {
        super(name, nodeDescription, remoteFS, numExecutors, mode, labelString, (ComputerLauncher)new vSphereCloudLauncher(delegateLauncher, vsDescription, name, launchSupportForced, waitForVMTools, snapName, launchDelay, idleOption, LimitedTestRunCount, isTemplate), retentionStrategy, nodeProperties);
        this.vsDescription = vsDescription;
        this.vmName = name;
        this.snapName = snapName;
        this.waitForVMTools = waitForVMTools;
        this.launchDelay = launchDelay;
        this.idleOption = idleOption;
        this.LimitedTestRunCount = Util.tryParseNumber((String)LimitedTestRunCount, (Number)0).intValue();
        this.NumberOfLimitedTestRuns = 0;
        this.readResolve();
    }

    protected Object readResolve() {
        super.readResolve();
        ((vSphereCloudLauncher)super.getLauncher()).readResolve();
        RetentionStrategy strategy = this.getRetentionStrategy();
        if (strategy instanceof CloudSlaveRetentionStrategy) {
            CloudSlaveRetentionStrategy cfr_ignored_0 = (CloudSlaveRetentionStrategy)strategy;
            CloudSlaveRetentionStrategy.TIMEOUT = TimeUnit2.MINUTES.toMillis(1L);
        }
        if (this.NumberOfLimitedTestRuns == null) {
            this.NumberOfLimitedTestRuns = 0;
        }
        if (this.LimitedTestRunCount == null) {
            this.LimitedTestRunCount = 0;
        }
        return this;
    }

    public String getVmName() {
        return this.vmName;
    }

    public String getVsDescription() {
        return this.vsDescription;
    }

    public String getSnapName() {
        return this.snapName;
    }

    public Boolean getWaitForVMTools() {
        return this.waitForVMTools;
    }

    public String getLaunchDelay() {
        return this.launchDelay;
    }

    public String getIdleOption() {
        return this.idleOption;
    }

    public Integer getLimitedTestRunCount() {
        return this.LimitedTestRunCount;
    }

    public boolean isLaunchSupportForced() {
        return ((vSphereCloudLauncher)this.getLauncher()).getOverrideLaunchSupported() == Boolean.TRUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void InitProbableLaunch() {
        Boolean bl = ProbableLaunchLock;
        synchronized (bl) {
            if (ProbableLaunch == null) {
                ProbableLaunch = new ConcurrentHashMap();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void AddProbableLaunch(vSphereCloudSlave slave, Date target) {
        Boolean bl = ProbableLaunchLock;
        synchronized (bl) {
            vSphereCloudSlave.InitProbableLaunch();
            ProbableLaunch.put(slave, new ProbableLaunchData(slave, target));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void RemoveProbableLaunch(vSphereCloudSlave slave) {
        Boolean bl = ProbableLaunchLock;
        synchronized (bl) {
            if (ProbableLaunch != null) {
                ProbableLaunch.remove((Object)slave);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ProbableLaunchCleanup() {
        Boolean bl = ProbableLaunchLock;
        synchronized (bl) {
            vSphereCloudSlave.InitProbableLaunch();
            Date now = new Date();
            Iterator<Map.Entry<vSphereCloudSlave, ProbableLaunchData>> it = ProbableLaunch.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<vSphereCloudSlave, ProbableLaunchData> entry = it.next();
                if (!entry.getValue().expiration.before(now)) continue;
                it.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int ProbableLaunchCount() {
        Boolean bl = ProbableLaunchLock;
        synchronized (bl) {
            if (ProbableLaunch != null) {
                return ProbableLaunch.size();
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static vSphereCloudSlave ProbablyLaunchCanHandle(Queue.BuildableItem item) {
        Boolean bl = ProbableLaunchLock;
        synchronized (bl) {
            vSphereCloudSlave.InitProbableLaunch();
            Iterator<Map.Entry<vSphereCloudSlave, ProbableLaunchData>> it = ProbableLaunch.entrySet().iterator();
            while (it.hasNext()) {
                ProbableLaunchData data = it.next().getValue();
                if (data.slave.canTake(item) != null) continue;
                return data.slave;
            }
        }
        return null;
    }

    public Computer createComputer() {
        return ((vSphereCloudLauncher)this.getLauncher()).getIsTemplate() ? new vSphereCloudSlaveTemplateComputer(this) : new vSphereCloudSlaveComputer(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CauseOfBlockage canTake(Queue.BuildableItem buildItem) {
        vSphereCloudLauncher launcher = (vSphereCloudLauncher)this.getLauncher();
        SlaveComputer computer = this.getComputer();
        int busy = computer.countBusy();
        int executors = computer.getNumExecutors();
        if (buildItem.task instanceof Queue.FlyweightTask) {
            return new CauseOfBlockage(){

                public String getShortDescription() {
                    return "Don't run FlyweightTask on vSphere node.";
                }
            };
        }
        if (this.slaveIsStarting == Boolean.TRUE || this.doingLastInLimitedTestRun == Boolean.TRUE) {
            return new CauseOfBlockage.BecauseNodeIsBusy((Node)this);
        }
        if (this.slaveIsDisconnecting == Boolean.TRUE) {
            return new CauseOfBlockage.BecauseNodeIsOffline((Node)this);
        }
        if (launcher != null && launcher.getIsTemplate()) {
            Object object = acceptedItemsLock;
            synchronized (object) {
                if (acceptedItemsMap.containsKey(buildItem.task)) {
                    Slave acceptedSlave = acceptedItemsMap.get(buildItem.task);
                    if (!this.equals(acceptedSlave)) {
                        return new CauseOfBlockage(){

                            public String getShortDescription() {
                                return "This buildItem has already been requested to run on a different slave.";
                            }
                        };
                    }
                } else {
                    Collection<Slave> slaves = acceptedItemsMap.values();
                    int thisSlaveCount = 0;
                    for (Slave s : slaves) {
                        if (!this.equals(s)) continue;
                        ++thisSlaveCount;
                    }
                    if (thisSlaveCount + busy < executors) {
                        acceptedItemsMap.put(buildItem.task, this);
                    } else {
                        return new CauseOfBlockage.BecauseNodeIsBusy((Node)this);
                    }
                }
            }
        }
        return super.canTake(buildItem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void removeAcceptedItem(Queue.Task task) {
        Object object = acceptedItemsLock;
        synchronized (object) {
            Slave slave = acceptedItemsMap.remove(task);
        }
    }

    public boolean StartLimitedTestRun(Run r, TaskListener listener) {
        boolean ret = false;
        boolean DoUpdates = false;
        if (this.LimitedTestRunCount > 0) {
            DoUpdates = true;
            if (this.NumberOfLimitedTestRuns < this.LimitedTestRunCount) {
                ret = true;
            }
        } else {
            ret = true;
        }
        if (DoUpdates) {
            if (ret) {
                Integer n = this.NumberOfLimitedTestRuns;
                Integer n2 = this.NumberOfLimitedTestRuns = Integer.valueOf(this.NumberOfLimitedTestRuns + 1);
                vSphereCloud.Log(listener, "Starting limited count build: %d", this.NumberOfLimitedTestRuns);
                Computer slave = r.getExecutor().getOwner();
                RunToSlaveMapper.put(r, slave);
                if (this.NumberOfLimitedTestRuns >= this.LimitedTestRunCount) {
                    this.doingLastInLimitedTestRun = Boolean.FALSE;
                }
            } else {
                vSphereCloud.Log(listener, "Terminating build due to limited build count: %d", this.LimitedTestRunCount);
                r.getExecutor().interrupt(Result.ABORTED);
            }
        }
        return ret;
    }

    public boolean EndLimitedTestRun(Run r) {
        boolean ret;
        block9: {
            Computer slave;
            vSphereCloudLauncher launcher;
            ret = true;
            if (!r.isBuilding() && r.getResult() != null && r.getResult().isWorseThan(Result.SUCCESS) && (launcher = (vSphereCloudLauncher)this.getLauncher()) != null && launcher.getIsTemplate()) {
                this.LimitedTestRunCount = this.LimitedTestRunCount <= 0 ? 1 : this.LimitedTestRunCount;
                this.NumberOfLimitedTestRuns = this.NumberOfLimitedTestRuns < this.LimitedTestRunCount ? this.LimitedTestRunCount + 1 : this.NumberOfLimitedTestRuns;
            }
            if ((slave = RunToSlaveMapper.get(r)) != null) {
                RunToSlaveMapper.remove(r);
            }
            if (this.LimitedTestRunCount > 0) {
                if (this.NumberOfLimitedTestRuns >= this.LimitedTestRunCount) {
                    ret = false;
                    this.NumberOfLimitedTestRuns = 0;
                    try {
                        if (slave != null) {
                            vSphereCloud.Log("Disconnecting the slave agent on %s due to limited build threshold", slave.getName());
                            slave.setTemporarilyOffline(true, (OfflineCause)new OfflineCause.ByCLI("vSphere Plugin marking the slave as offline due to reaching limited build threshold"));
                            slave.waitUntilOffline();
                            slave.disconnect((OfflineCause)new OfflineCause.ByCLI("vSphere Plugin disconnecting the slave as offline due to reaching limited build threshold"));
                            slave.setTemporarilyOffline(false, (OfflineCause)new OfflineCause.ByCLI("vSphere Plugin marking the slave as online after completing post-disconnect actions."));
                            break block9;
                        }
                        vSphereCloud.Log("Attempting to shutdown slave due to limited build threshold, but cannot determine slave");
                    }
                    catch (NullPointerException ex) {
                        vSphereCloud.Log("NullPointerException thrown while retrieving the slave agent: %s", ex.getMessage());
                    }
                    catch (InterruptedException ex) {
                        vSphereCloud.Log("InterruptedException thrown while marking the slave as online or offline: %s", ex.getMessage());
                    }
                }
            } else {
                ret = true;
            }
        }
        return ret;
    }

    public ComputerLauncher getDelegateLauncher() {
        return ((vSphereCloudLauncher)this.getLauncher()).getDelegate();
    }

    static {
        ProbableLaunchLock = true;
        acceptedItemsMap = new HashMap<Queue.Task, Slave>();
        acceptedItemsLock = new Object();
        RunToSlaveMapper = new ConcurrentHashMap();
    }

    @Extension
    public static final class DescriptorImpl
    extends Slave.SlaveDescriptor {
        public DescriptorImpl() {
            this.load();
        }

        public String getDisplayName() {
            return "Slave virtual computer running under vSphere Cloud";
        }

        public boolean isInstantiable() {
            return true;
        }

        public List<vSphereCloud> getvSphereClouds() {
            ArrayList<vSphereCloud> result = new ArrayList<vSphereCloud>();
            for (Cloud cloud : Hudson.getInstance().clouds) {
                if (!(cloud instanceof vSphereCloud)) continue;
                result.add((vSphereCloud)cloud);
            }
            return result;
        }

        public vSphereCloud getSpecificvSphereCloud(String vsDescription) throws Exception {
            for (vSphereCloud vs : this.getvSphereClouds()) {
                if (!vs.getVsDescription().equals(vsDescription)) continue;
                return vs;
            }
            throw new Exception("The vSphere Cloud doesn't exist");
        }

        public List<Descriptor<ComputerLauncher>> getComputerLauncherDescriptors() {
            ArrayList<Descriptor<ComputerLauncher>> result = new ArrayList<Descriptor<ComputerLauncher>>();
            for (Descriptor launcher : Functions.getComputerLauncherDescriptors()) {
                if (vSphereCloudLauncher.class.isAssignableFrom(launcher.clazz)) continue;
                result.add((Descriptor<ComputerLauncher>)launcher);
            }
            return result;
        }

        public List<String> getIdleOptions() {
            ArrayList<String> options = new ArrayList<String>();
            options.add("Shutdown");
            options.add("Shutdown and Revert");
            options.add("Revert and Restart");
            options.add("Revert and Reset");
            options.add("Suspend");
            options.add("Reset");
            options.add("Nothing");
            return options;
        }

        public FormValidation doCheckLaunchDelay(@QueryParameter String value) {
            return FormValidation.validatePositiveInteger((String)value);
        }

        public FormValidation doTestConnection(@QueryParameter String vsDescription, @QueryParameter String vmName, @QueryParameter String snapName) {
            try {
                VirtualMachineSnapshot snap;
                vSphereCloud vsC = this.getSpecificvSphereCloud(vsDescription);
                VirtualMachine vm = vsC.vSphereInstance().getVmByName(vmName);
                if (vm == null) {
                    return FormValidation.error((String)"Virtual Machine was not found");
                }
                if (!snapName.isEmpty() && (snap = vsC.vSphereInstance().getSnapshotInTree(vm, snapName)) == null) {
                    return FormValidation.error((String)"Virtual Machine snapshot was not found");
                }
                return FormValidation.ok((String)"Virtual Machine found successfully");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Extension
    public static class vSphereCloudComputerListener
    extends ComputerListener {
        public void preLaunch(Computer c, TaskListener taskListener) throws IOException, InterruptedException {
            if (!(c.getNode() instanceof vSphereCloudSlave)) {
                return;
            }
            vSphereCloudLauncher vsL = (vSphereCloudLauncher)((SlaveComputer)c).getLauncher();
            vSphereCloud vsC = vsL.findOurVsInstance();
            if (!vsC.markVMOnline(c.getDisplayName(), vsL.getVmName()).booleanValue()) {
                throw new AbortException("The vSphere cloud will not allow this slave to start at this time.");
            }
        }
    }

    private static class ProbableLaunchData {
        public vSphereCloudSlave slave;
        public Date expiration;

        public ProbableLaunchData(vSphereCloudSlave slave, Date expiration) {
            this.slave = slave;
            this.expiration = expiration;
        }
    }
}

