// CHECKSTYLE:OFF

package org.jenkinsci.plugins.vsphere.builders;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code vm.title.RevertToSnapshot}: {@code Revert to Snapshot}.
     * 
     * @return
     *     {@code Revert to Snapshot}
     */
    public static String vm_title_RevertToSnapshot() {
        return holder.format("vm.title.RevertToSnapshot");
    }

    /**
     * Key {@code vm.title.RevertToSnapshot}: {@code Revert to Snapshot}.
     * 
     * @return
     *     {@code Revert to Snapshot}
     */
    public static Localizable _vm_title_RevertToSnapshot() {
        return new Localizable(holder, "vm.title.RevertToSnapshot");
    }

    /**
     * Key {@code vm.title.ConvertToVM}: {@code Convert template to a VM}.
     * 
     * @return
     *     {@code Convert template to a VM}
     */
    public static String vm_title_ConvertToVM() {
        return holder.format("vm.title.ConvertToVM");
    }

    /**
     * Key {@code vm.title.ConvertToVM}: {@code Convert template to a VM}.
     * 
     * @return
     *     {@code Convert template to a VM}
     */
    public static Localizable _vm_title_ConvertToVM() {
        return new Localizable(holder, "vm.title.ConvertToVM");
    }

    /**
     * Key {@code vm.reconfigure.Remove}: {@code Remove}.
     * 
     * @return
     *     {@code Remove}
     */
    public static String vm_reconfigure_Remove() {
        return holder.format("vm.reconfigure.Remove");
    }

    /**
     * Key {@code vm.reconfigure.Remove}: {@code Remove}.
     * 
     * @return
     *     {@code Remove}
     */
    public static Localizable _vm_reconfigure_Remove() {
        return new Localizable(holder, "vm.reconfigure.Remove");
    }

    /**
     * Key {@code validation.alreadySet}: {@code Specified {0} is already a
     * {1}!}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Specified {0} is already a {1}!}
     */
    public static String validation_alreadySet(Object arg0, Object arg1) {
        return holder.format("validation.alreadySet", arg0, arg1);
    }

    /**
     * Key {@code validation.alreadySet}: {@code Specified {0} is already a
     * {1}!}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Specified {0} is already a {1}!}
     */
    public static Localizable _validation_alreadySet(Object arg0, Object arg1) {
        return new Localizable(holder, "validation.alreadySet", arg0, arg1);
    }

    /**
     * Key {@code console.usingServerConfig}: {@code Attempting to use server
     * configuration: "{0}"}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Attempting to use server configuration: "{0}"}
     */
    public static String console_usingServerConfig(Object arg0) {
        return holder.format("console.usingServerConfig", arg0);
    }

    /**
     * Key {@code console.usingServerConfig}: {@code Attempting to use server
     * configuration: "{0}"}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Attempting to use server configuration: "{0}"}
     */
    public static Localizable _console_usingServerConfig(Object arg0) {
        return new Localizable(holder, "console.usingServerConfig", arg0);
    }

    /**
     * Key {@code vm.title.ReconfigureDisk}: {@code Add a disk}.
     * 
     * @return
     *     {@code Add a disk}
     */
    public static String vm_title_ReconfigureDisk() {
        return holder.format("vm.title.ReconfigureDisk");
    }

    /**
     * Key {@code vm.title.ReconfigureDisk}: {@code Add a disk}.
     * 
     * @return
     *     {@code Add a disk}
     */
    public static Localizable _vm_title_ReconfigureDisk() {
        return new Localizable(holder, "vm.title.ReconfigureDisk");
    }

    /**
     * Key {@code plugin.title.BuildStep}: {@code vSphere Build Step}.
     * 
     * @return
     *     {@code vSphere Build Step}
     */
    public static String plugin_title_BuildStep() {
        return holder.format("plugin.title.BuildStep");
    }

    /**
     * Key {@code plugin.title.BuildStep}: {@code vSphere Build Step}.
     * 
     * @return
     *     {@code vSphere Build Step}
     */
    public static Localizable _plugin_title_BuildStep() {
        return new Localizable(holder, "plugin.title.BuildStep");
    }

    /**
     * Key {@code vm.reconfigure.Edit}: {@code Edit}.
     * 
     * @return
     *     {@code Edit}
     */
    public static String vm_reconfigure_Edit() {
        return holder.format("vm.reconfigure.Edit");
    }

    /**
     * Key {@code vm.reconfigure.Edit}: {@code Edit}.
     * 
     * @return
     *     {@code Edit}
     */
    public static Localizable _vm_reconfigure_Edit() {
        return new Localizable(holder, "vm.reconfigure.Edit");
    }

    /**
     * Key {@code vm.title.TakeSnapshot}: {@code Take Snapshot}.
     * 
     * @return
     *     {@code Take Snapshot}
     */
    public static String vm_title_TakeSnapshot() {
        return holder.format("vm.title.TakeSnapshot");
    }

    /**
     * Key {@code vm.title.TakeSnapshot}: {@code Take Snapshot}.
     * 
     * @return
     *     {@code Take Snapshot}
     */
    public static Localizable _vm_title_TakeSnapshot() {
        return new Localizable(holder, "vm.title.TakeSnapshot");
    }

    /**
     * Key {@code vm.title.ReconfigureNetworkAdapter}: {@code Edit Network
     * Adapter}.
     * 
     * @return
     *     {@code Edit Network Adapter}
     */
    public static String vm_title_ReconfigureNetworkAdapter() {
        return holder.format("vm.title.ReconfigureNetworkAdapter");
    }

    /**
     * Key {@code vm.title.ReconfigureNetworkAdapter}: {@code Edit Network
     * Adapter}.
     * 
     * @return
     *     {@code Edit Network Adapter}
     */
    public static Localizable _vm_title_ReconfigureNetworkAdapter() {
        return new Localizable(holder, "vm.title.ReconfigureNetworkAdapter");
    }

    /**
     * Key {@code vm.title.SuspendVM}: {@code Suspend VM}.
     * 
     * @return
     *     {@code Suspend VM}
     */
    public static String vm_title_SuspendVM() {
        return holder.format("vm.title.SuspendVM");
    }

    /**
     * Key {@code vm.title.SuspendVM}: {@code Suspend VM}.
     * 
     * @return
     *     {@code Suspend VM}
     */
    public static Localizable _vm_title_SuspendVM() {
        return new Localizable(holder, "vm.title.SuspendVM");
    }

    /**
     * Key {@code validation.instanceNotFound}: {@code Could not find vSphere
     * Cloud instance "{0}"!}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Could not find vSphere Cloud instance "{0}"!}
     */
    public static String validation_instanceNotFound(Object arg0) {
        return holder.format("validation.instanceNotFound", arg0);
    }

    /**
     * Key {@code validation.instanceNotFound}: {@code Could not find vSphere
     * Cloud instance "{0}"!}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Could not find vSphere Cloud instance "{0}"!}
     */
    public static Localizable _validation_instanceNotFound(Object arg0) {
        return new Localizable(holder, "validation.instanceNotFound", arg0);
    }

    /**
     * Key {@code validation.wrongSwitchSelection}: {@code Cannot configure
     * both Standard Switch and Distributed Switch for the same network
     * device}.
     * 
     * @return
     *     {@code Cannot configure both Standard Switch and Distributed Switch
     *     for the same network device}
     */
    public static String validation_wrongSwitchSelection() {
        return holder.format("validation.wrongSwitchSelection");
    }

    /**
     * Key {@code validation.wrongSwitchSelection}: {@code Cannot configure
     * both Standard Switch and Distributed Switch for the same network
     * device}.
     * 
     * @return
     *     {@code Cannot configure both Standard Switch and Distributed Switch
     *     for the same network device}
     */
    public static Localizable _validation_wrongSwitchSelection() {
        return new Localizable(holder, "validation.wrongSwitchSelection");
    }

    /**
     * Key {@code console.buildStepStart}: {@code Performing vSphere build
     * step: "{0}"}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Performing vSphere build step: "{0}"}
     */
    public static String console_buildStepStart(Object arg0) {
        return holder.format("console.buildStepStart", arg0);
    }

    /**
     * Key {@code console.buildStepStart}: {@code Performing vSphere build
     * step: "{0}"}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Performing vSphere build step: "{0}"}
     */
    public static Localizable _console_buildStepStart(Object arg0) {
        return new Localizable(holder, "console.buildStepStart", arg0);
    }

    /**
     * Key {@code vm.title.Rename}: {@code Rename VM}.
     * 
     * @return
     *     {@code Rename VM}
     */
    public static String vm_title_Rename() {
        return holder.format("vm.title.Rename");
    }

    /**
     * Key {@code vm.title.Rename}: {@code Rename VM}.
     * 
     * @return
     *     {@code Rename VM}
     */
    public static Localizable _vm_title_Rename() {
        return new Localizable(holder, "vm.title.Rename");
    }

    /**
     * Key {@code vm.title.ReconfigureMemory}: {@code Edit Memory}.
     * 
     * @return
     *     {@code Edit Memory}
     */
    public static String vm_title_ReconfigureMemory() {
        return holder.format("vm.title.ReconfigureMemory");
    }

    /**
     * Key {@code vm.title.ReconfigureMemory}: {@code Edit Memory}.
     * 
     * @return
     *     {@code Edit Memory}
     */
    public static Localizable _vm_title_ReconfigureMemory() {
        return new Localizable(holder, "vm.title.ReconfigureMemory");
    }

    /**
     * Key {@code vm.title.ConvertToTemplate}: {@code Convert VM to a
     * template}.
     * 
     * @return
     *     {@code Convert VM to a template}
     */
    public static String vm_title_ConvertToTemplate() {
        return holder.format("vm.title.ConvertToTemplate");
    }

    /**
     * Key {@code vm.title.ConvertToTemplate}: {@code Convert VM to a
     * template}.
     * 
     * @return
     *     {@code Convert VM to a template}
     */
    public static Localizable _vm_title_ConvertToTemplate() {
        return new Localizable(holder, "vm.title.ConvertToTemplate");
    }

    /**
     * Key {@code validation.positiveInteger}: {@code {0} must be a positive
     * integer!}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} must be a positive integer!}
     */
    public static String validation_positiveInteger(Object arg0) {
        return holder.format("validation.positiveInteger", arg0);
    }

    /**
     * Key {@code validation.positiveInteger}: {@code {0} must be a positive
     * integer!}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} must be a positive integer!}
     */
    public static Localizable _validation_positiveInteger(Object arg0) {
        return new Localizable(holder, "validation.positiveInteger", arg0);
    }

    /**
     * Key {@code vm.title.ReconfigureCpu}: {@code Edit CPU}.
     * 
     * @return
     *     {@code Edit CPU}
     */
    public static String vm_title_ReconfigureCpu() {
        return holder.format("vm.title.ReconfigureCpu");
    }

    /**
     * Key {@code vm.title.ReconfigureCpu}: {@code Edit CPU}.
     * 
     * @return
     *     {@code Edit CPU}
     */
    public static Localizable _vm_title_ReconfigureCpu() {
        return new Localizable(holder, "vm.title.ReconfigureCpu");
    }

    /**
     * Key {@code vm.title.PowerOn}: {@code Power-On/Resume VM}.
     * 
     * @return
     *     {@code Power-On/Resume VM}
     */
    public static String vm_title_PowerOn() {
        return holder.format("vm.title.PowerOn");
    }

    /**
     * Key {@code vm.title.PowerOn}: {@code Power-On/Resume VM}.
     * 
     * @return
     *     {@code Power-On/Resume VM}
     */
    public static Localizable _vm_title_PowerOn() {
        return new Localizable(holder, "vm.title.PowerOn");
    }

    /**
     * Key {@code vm.title.ReconfigureAnnotation}: {@code Edit Notes}.
     * 
     * @return
     *     {@code Edit Notes}
     */
    public static String vm_title_ReconfigureAnnotation() {
        return holder.format("vm.title.ReconfigureAnnotation");
    }

    /**
     * Key {@code vm.title.ReconfigureAnnotation}: {@code Edit Notes}.
     * 
     * @return
     *     {@code Edit Notes}
     */
    public static Localizable _vm_title_ReconfigureAnnotation() {
        return new Localizable(holder, "vm.title.ReconfigureAnnotation");
    }

    /**
     * Key {@code validation.requiredValues}: {@code Please enter required
     * values!}.
     * 
     * @return
     *     {@code Please enter required values!}
     */
    public static String validation_requiredValues() {
        return holder.format("validation.requiredValues");
    }

    /**
     * Key {@code validation.requiredValues}: {@code Please enter required
     * values!}.
     * 
     * @return
     *     {@code Please enter required values!}
     */
    public static Localizable _validation_requiredValues() {
        return new Localizable(holder, "validation.requiredValues");
    }

    /**
     * Key {@code vm.title.Delete}: {@code Delete VM (DESTRUCTIVE)}.
     * 
     * @return
     *     {@code Delete VM (DESTRUCTIVE)}
     */
    public static String vm_title_Delete() {
        return holder.format("vm.title.Delete");
    }

    /**
     * Key {@code vm.title.Delete}: {@code Delete VM (DESTRUCTIVE)}.
     * 
     * @return
     *     {@code Delete VM (DESTRUCTIVE)}
     */
    public static Localizable _vm_title_Delete() {
        return new Localizable(holder, "vm.title.Delete");
    }

    /**
     * Key {@code validation.maxValue}: {@code Please enter a value less than
     * {0}!}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Please enter a value less than {0}!}
     */
    public static String validation_maxValue(Object arg0) {
        return holder.format("validation.maxValue", arg0);
    }

    /**
     * Key {@code validation.maxValue}: {@code Please enter a value less than
     * {0}!}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Please enter a value less than {0}!}
     */
    public static Localizable _validation_maxValue(Object arg0) {
        return new Localizable(holder, "validation.maxValue", arg0);
    }

    /**
     * Key {@code vm.reconfigure.Add}: {@code Add}.
     * 
     * @return
     *     {@code Add}
     */
    public static String vm_reconfigure_Add() {
        return holder.format("vm.reconfigure.Add");
    }

    /**
     * Key {@code vm.reconfigure.Add}: {@code Add}.
     * 
     * @return
     *     {@code Add}
     */
    public static Localizable _vm_reconfigure_Add() {
        return new Localizable(holder, "vm.reconfigure.Add");
    }

    /**
     * Key {@code validation.buildParameter}: {@code {0} references a build
     * parameter, so it cannot be validated.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} references a build parameter, so it cannot be validated.}
     */
    public static String validation_buildParameter(Object arg0) {
        return holder.format("validation.buildParameter", arg0);
    }

    /**
     * Key {@code validation.buildParameter}: {@code {0} references a build
     * parameter, so it cannot be validated.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} references a build parameter, so it cannot be validated.}
     */
    public static Localizable _validation_buildParameter(Object arg0) {
        return new Localizable(holder, "validation.buildParameter", arg0);
    }

    /**
     * Key {@code validation.required}: {@code Please enter {0}!}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Please enter {0}!}
     */
    public static String validation_required(Object arg0) {
        return holder.format("validation.required", arg0);
    }

    /**
     * Key {@code validation.required}: {@code Please enter {0}!}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Please enter {0}!}
     */
    public static Localizable _validation_required(Object arg0) {
        return new Localizable(holder, "validation.required", arg0);
    }

    /**
     * Key {@code validation.exists}: {@code Specified {0} already exists!}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Specified {0} already exists!}
     */
    public static String validation_exists(Object arg0) {
        return holder.format("validation.exists", arg0);
    }

    /**
     * Key {@code validation.exists}: {@code Specified {0} already exists!}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Specified {0} already exists!}
     */
    public static Localizable _validation_exists(Object arg0) {
        return new Localizable(holder, "validation.exists", arg0);
    }

    /**
     * Key {@code validation.success}: {@code Success}.
     * 
     * @return
     *     {@code Success}
     */
    public static String validation_success() {
        return holder.format("validation.success");
    }

    /**
     * Key {@code validation.success}: {@code Success}.
     * 
     * @return
     *     {@code Success}
     */
    public static Localizable _validation_success() {
        return new Localizable(holder, "validation.success");
    }

    /**
     * Key {@code vm.title.Clone}: {@code Clone VM from VM or template}.
     * 
     * @return
     *     {@code Clone VM from VM or template}
     */
    public static String vm_title_Clone() {
        return holder.format("vm.title.Clone");
    }

    /**
     * Key {@code vm.title.Clone}: {@code Clone VM from VM or template}.
     * 
     * @return
     *     {@code Clone VM from VM or template}
     */
    public static Localizable _vm_title_Clone() {
        return new Localizable(holder, "vm.title.Clone");
    }

    /**
     * Key {@code vm.title.ExposeGuestInfo}: {@code Expose Guest Info}.
     * 
     * @return
     *     {@code Expose Guest Info}
     */
    public static String vm_title_ExposeGuestInfo() {
        return holder.format("vm.title.ExposeGuestInfo");
    }

    /**
     * Key {@code vm.title.ExposeGuestInfo}: {@code Expose Guest Info}.
     * 
     * @return
     *     {@code Expose Guest Info}
     */
    public static Localizable _vm_title_ExposeGuestInfo() {
        return new Localizable(holder, "vm.title.ExposeGuestInfo");
    }

    /**
     * Key {@code validation.serverExistence}: {@code Server does not exist
     * in global config! Please re-save your job configuration.}.
     * 
     * @return
     *     {@code Server does not exist in global config! Please re-save your job
     *     configuration.}
     */
    public static String validation_serverExistence() {
        return holder.format("validation.serverExistence");
    }

    /**
     * Key {@code validation.serverExistence}: {@code Server does not exist
     * in global config! Please re-save your job configuration.}.
     * 
     * @return
     *     {@code Server does not exist in global config! Please re-save your job
     *     configuration.}
     */
    public static Localizable _validation_serverExistence() {
        return new Localizable(holder, "validation.serverExistence");
    }

    /**
     * Key {@code validation.noSnapshots}: {@code No snapshots found for
     * specified template!}.
     * 
     * @return
     *     {@code No snapshots found for specified template!}
     */
    public static String validation_noSnapshots() {
        return holder.format("validation.noSnapshots");
    }

    /**
     * Key {@code validation.noSnapshots}: {@code No snapshots found for
     * specified template!}.
     * 
     * @return
     *     {@code No snapshots found for specified template!}
     */
    public static Localizable _validation_noSnapshots() {
        return new Localizable(holder, "validation.noSnapshots");
    }

    /**
     * Key {@code vm.title.Deploy}: {@code Deploy VM from template}.
     * 
     * @return
     *     {@code Deploy VM from template}
     */
    public static String vm_title_Deploy() {
        return holder.format("vm.title.Deploy");
    }

    /**
     * Key {@code vm.title.Deploy}: {@code Deploy VM from template}.
     * 
     * @return
     *     {@code Deploy VM from template}
     */
    public static Localizable _vm_title_Deploy() {
        return new Localizable(holder, "vm.title.Deploy");
    }

    /**
     * Key {@code vm.title.DeleteSnapshot}: {@code Delete a Snapshot}.
     * 
     * @return
     *     {@code Delete a Snapshot}
     */
    public static String vm_title_DeleteSnapshot() {
        return holder.format("vm.title.DeleteSnapshot");
    }

    /**
     * Key {@code vm.title.DeleteSnapshot}: {@code Delete a Snapshot}.
     * 
     * @return
     *     {@code Delete a Snapshot}
     */
    public static Localizable _vm_title_DeleteSnapshot() {
        return new Localizable(holder, "vm.title.DeleteSnapshot");
    }

    /**
     * Key {@code vm.title.Reconfigure}: {@code Reconfigure VM}.
     * 
     * @return
     *     {@code Reconfigure VM}
     */
    public static String vm_title_Reconfigure() {
        return holder.format("vm.title.Reconfigure");
    }

    /**
     * Key {@code vm.title.Reconfigure}: {@code Reconfigure VM}.
     * 
     * @return
     *     {@code Reconfigure VM}
     */
    public static Localizable _vm_title_Reconfigure() {
        return new Localizable(holder, "vm.title.Reconfigure");
    }

    /**
     * Key {@code validation.notActually}: {@code Specified {0} is not
     * actually a {0}!}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Specified {0} is not actually a {0}!}
     */
    public static String validation_notActually(Object arg0) {
        return holder.format("validation.notActually", arg0);
    }

    /**
     * Key {@code validation.notActually}: {@code Specified {0} is not
     * actually a {0}!}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Specified {0} is not actually a {0}!}
     */
    public static Localizable _validation_notActually(Object arg0) {
        return new Localizable(holder, "validation.notActually", arg0);
    }

    /**
     * Key {@code vm.title.RenameSnapshot}: {@code Rename Snapshot}.
     * 
     * @return
     *     {@code Rename Snapshot}
     */
    public static String vm_title_RenameSnapshot() {
        return holder.format("vm.title.RenameSnapshot");
    }

    /**
     * Key {@code vm.title.RenameSnapshot}: {@code Rename Snapshot}.
     * 
     * @return
     *     {@code Rename Snapshot}
     */
    public static Localizable _vm_title_RenameSnapshot() {
        return new Localizable(holder, "vm.title.RenameSnapshot");
    }

    /**
     * Key {@code vm.title.PowerOff}: {@code Power-Off VM}.
     * 
     * @return
     *     {@code Power-Off VM}
     */
    public static String vm_title_PowerOff() {
        return holder.format("vm.title.PowerOff");
    }

    /**
     * Key {@code vm.title.PowerOff}: {@code Power-Off VM}.
     * 
     * @return
     *     {@code Power-Off VM}
     */
    public static Localizable _vm_title_PowerOff() {
        return new Localizable(holder, "vm.title.PowerOff");
    }

    /**
     * Key {@code validation.notFound}: {@code Specified {0} not found!}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Specified {0} not found!}
     */
    public static String validation_notFound(Object arg0) {
        return holder.format("validation.notFound", arg0);
    }

    /**
     * Key {@code validation.notFound}: {@code Specified {0} not found!}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Specified {0} not found!}
     */
    public static Localizable _validation_notFound(Object arg0) {
        return new Localizable(holder, "validation.notFound", arg0);
    }

}
