/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vsphere.builders;

import com.vmware.vim25.mo.VirtualMachine;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepMonitor;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import javax.annotation.Nonnull;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.plugins.vsphere.VSphereBuildStep;
import org.jenkinsci.plugins.vsphere.builders.Messages;
import org.jenkinsci.plugins.vsphere.tools.PermissionUtils;
import org.jenkinsci.plugins.vsphere.tools.VSphere;
import org.jenkinsci.plugins.vsphere.tools.VSphereException;
import org.jenkinsci.plugins.vsphere.tools.VSphereLogger;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class RenameSnapshot
extends VSphereBuildStep
implements SimpleBuildStep {
    private final String vm;
    private final String oldName;
    private final String newName;
    private final String newDescription;

    @DataBoundConstructor
    public RenameSnapshot(String vm, String oldName, String newName, String newDescription) throws VSphereException {
        this.vm = vm;
        this.oldName = oldName;
        this.newName = newName;
        this.newDescription = newDescription;
    }

    public String getVm() {
        return this.vm;
    }

    public String getOldName() {
        return this.oldName;
    }

    public String getNewName() {
        return this.newName;
    }

    public String getNewDescription() {
        return this.newDescription;
    }

    @Override
    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath filePath, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        try {
            this.renameSnapshot(run, launcher, listener);
        }
        catch (Exception e) {
            throw new AbortException(e.getMessage());
        }
    }

    public boolean prebuild(AbstractBuild<?, ?> abstractBuild, BuildListener buildListener) {
        return false;
    }

    @Override
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        boolean retVal = false;
        try {
            retVal = this.renameSnapshot((Run<?, ?>)build, launcher, (TaskListener)listener);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retVal;
    }

    public Action getProjectAction(AbstractProject<?, ?> abstractProject) {
        return null;
    }

    public Collection<? extends Action> getProjectActions(AbstractProject<?, ?> abstractProject) {
        return null;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return null;
    }

    public boolean renameSnapshot(Run<?, ?> run, Launcher launcher, TaskListener listener) throws VSphereException {
        EnvVars env;
        PrintStream jLogger = listener.getLogger();
        String expandedVm = this.vm;
        String expandedOldName = this.oldName;
        String expandedNewName = this.newName;
        String expandedNewDescription = this.newDescription;
        try {
            env = run.getEnvironment(listener);
        }
        catch (Exception e) {
            throw new VSphereException(e);
        }
        if (run instanceof AbstractBuild) {
            env.overrideAll(((AbstractBuild)run).getBuildVariables());
            expandedVm = env.expand(this.vm);
            expandedOldName = env.expand(this.oldName);
            expandedNewName = env.expand(this.newName);
            expandedNewDescription = env.expand(this.newDescription);
        }
        VSphereLogger.vsLogger(jLogger, "Renaming snapshot of VM \"" + expandedVm + "\" from \"" + expandedOldName + "\" to \"" + expandedNewName + "\" with description \"" + expandedNewDescription + "\". Please wait ...");
        try {
            this.vsphere.renameVmSnapshot(expandedVm, expandedOldName, expandedNewName, expandedNewDescription);
        }
        catch (Exception e) {
            throw new VSphereException(e);
        }
        VSphereLogger.vsLogger(jLogger, "Renamed!");
        return true;
    }

    @Extension
    public static final class RenameSnapshotDescriptor
    extends VSphereBuildStep.VSphereBuildStepDescriptor {
        public RenameSnapshotDescriptor() {
            this.load();
        }

        public FormValidation doCheckVm(@QueryParameter String value) {
            if (value.length() == 0) {
                return FormValidation.error((String)Messages.validation_required("the VM name"));
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckOldName(@QueryParameter String value) {
            if (value.length() == 0) {
                return FormValidation.error((String)Messages.validation_required("the VM snapshot name"));
            }
            return FormValidation.ok();
        }

        public String getDisplayName() {
            return Messages.vm_title_RenameSnapshot();
        }

        @RequirePOST
        public FormValidation doTestData(@AncestorInPath Item context, @QueryParameter String serverName, @QueryParameter String vm, @QueryParameter String oldName, @QueryParameter String newName) {
            PermissionUtils.throwUnlessUserHasPermissionToConfigureJob(context);
            try {
                if (serverName.length() == 0 || oldName.length() == 0 || newName.length() == 0) {
                    return FormValidation.error((String)Messages.validation_requiredValues());
                }
                VSphere vsphere = RenameSnapshotDescriptor.getVSphereCloudByName(serverName, null).vSphereInstance();
                VirtualMachine vmObj = vsphere.getVmByName(vm);
                if (vmObj == null) {
                    return FormValidation.error((String)Messages.validation_notFound("VM"));
                }
                return FormValidation.ok((String)Messages.validation_success());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

