/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vsphere.builders;

import com.vmware.vim25.VirtualMachineConfigSpec;
import com.vmware.vim25.mo.VirtualMachine;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepMonitor;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.plugins.vsphere.VSphereBuildStep;
import org.jenkinsci.plugins.vsphere.builders.Messages;
import org.jenkinsci.plugins.vsphere.builders.ReconfigureStep;
import org.jenkinsci.plugins.vsphere.tools.PermissionUtils;
import org.jenkinsci.plugins.vsphere.tools.VSphere;
import org.jenkinsci.plugins.vsphere.tools.VSphereException;
import org.jenkinsci.plugins.vsphere.tools.VSphereLogger;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class Reconfigure
extends VSphereBuildStep
implements SimpleBuildStep {
    private final List<ReconfigureStep> reconfigureSteps;
    private final String vm;

    @DataBoundConstructor
    public Reconfigure(String vm, List<ReconfigureStep> reconfigureSteps) throws VSphereException {
        this.vm = vm;
        this.reconfigureSteps = reconfigureSteps;
    }

    public String getVm() {
        return this.vm;
    }

    public List<ReconfigureStep> getReconfigureSteps() {
        return this.reconfigureSteps;
    }

    @Override
    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath filePath, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        try {
            this.reconfigureVm(run, launcher, listener);
        }
        catch (Exception e) {
            throw new AbortException(e.getMessage());
        }
    }

    public boolean prebuild(AbstractBuild<?, ?> abstractBuild, BuildListener buildListener) {
        return false;
    }

    @Override
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        boolean retVal = false;
        try {
            retVal = this.reconfigureVm((Run<?, ?>)build, launcher, (TaskListener)listener);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retVal;
    }

    public Action getProjectAction(AbstractProject<?, ?> abstractProject) {
        return null;
    }

    public Collection<? extends Action> getProjectActions(AbstractProject<?, ?> abstractProject) {
        return null;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return null;
    }

    private boolean reconfigureVm(Run<?, ?> run, Launcher launcher, TaskListener listener) throws VSphereException, IOException, InterruptedException {
        EnvVars env;
        PrintStream jLogger = listener.getLogger();
        String expandedVm = this.vm;
        try {
            env = run.getEnvironment(listener);
        }
        catch (Exception e) {
            throw new VSphereException(e);
        }
        if (run instanceof AbstractBuild) {
            env.overrideAll(((AbstractBuild)run).getBuildVariables());
            expandedVm = env.expand(this.vm);
        }
        VirtualMachine realVM = this.vsphere.getVmByName(expandedVm);
        VSphereLogger.vsLogger(jLogger, "Reconfiguring VM \"" + expandedVm + "\". Please wait ...");
        VirtualMachineConfigSpec spec = new VirtualMachineConfigSpec();
        for (ReconfigureStep actionStep : this.reconfigureSteps) {
            actionStep.setVsphere(this.getVsphere());
            actionStep.setVM(realVM);
            actionStep.setVirtualMachineConfigSpec(spec);
            actionStep.perform(run, null, launcher, listener);
        }
        this.vsphere.reconfigureVm(expandedVm, spec);
        VSphereLogger.vsLogger(jLogger, "Finished!");
        return true;
    }

    @Override
    public ReconfigureDescriptor getDescriptor() {
        return (ReconfigureDescriptor)Jenkins.getInstance().getDescriptor(this.getClass());
    }

    @Extension
    public static final class ReconfigureDescriptor
    extends VSphereBuildStep.VSphereBuildStepDescriptor {
        public ReconfigureDescriptor() {
            this.load();
        }

        public List<ReconfigureStep.ReconfigureStepDescriptor> getReconfigureStepsDescriptors() {
            return ReconfigureStep.all();
        }

        public FormValidation doCheckVm(@QueryParameter String value) {
            if (value.length() == 0) {
                return FormValidation.error((String)Messages.validation_required("the VM name"));
            }
            return FormValidation.ok();
        }

        public String getDisplayName() {
            return Messages.vm_title_Reconfigure();
        }

        @RequirePOST
        public FormValidation doTestData(@AncestorInPath Item context, @QueryParameter String serverName, @QueryParameter String vm) {
            PermissionUtils.throwUnlessUserHasPermissionToConfigureJob(context);
            try {
                if (serverName.length() == 0 || vm.length() == 0) {
                    return FormValidation.error((String)Messages.validation_requiredValues());
                }
                VSphere vsphere = ReconfigureDescriptor.getVSphereCloudByName(serverName).vSphereInstance();
                if (vm.indexOf(36) >= 0) {
                    return FormValidation.warning((String)Messages.validation_buildParameter("VM"));
                }
                VirtualMachine vmObj = vsphere.getVmByName(vm);
                if (vmObj == null) {
                    return FormValidation.error((String)Messages.validation_notFound("VM"));
                }
                return FormValidation.ok((String)Messages.validation_success());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

