/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins;

import com.vmware.vim25.VirtualMachinePowerState;
import com.vmware.vim25.VirtualMachineToolsStatus;
import com.vmware.vim25.mo.Task;
import com.vmware.vim25.mo.VirtualMachine;
import com.vmware.vim25.mo.VirtualMachineSnapshot;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.DelegatingComputerLauncher;
import hudson.slaves.SlaveComputer;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.rmi.RemoteException;
import java.util.Calendar;
import org.jenkinsci.plugins.vSphereCloud;
import org.jenkinsci.plugins.vSphereCloudSlave;
import org.jenkinsci.plugins.vsphere.tools.VSphere;
import org.jenkinsci.plugins.vsphere.tools.VSphereException;
import org.kohsuke.stapler.DataBoundConstructor;

public class vSphereCloudLauncher
extends DelegatingComputerLauncher {
    @Deprecated
    private transient ComputerLauncher delegate;
    private final Boolean overrideLaunchSupported;
    private final String vsDescription;
    private final String vmName;
    private final Boolean waitForVMTools;
    private final String snapName;
    private final int launchDelay;
    private final MACHINE_ACTION idleAction;
    private final int LimitedTestRunCount;

    @DataBoundConstructor
    public vSphereCloudLauncher(ComputerLauncher launcher, String vsDescription, String vmName, Boolean overrideLaunchSupported, Boolean waitForVMTools, String snapName, String launchDelay, String idleOption, String LimitedTestRunCount) {
        super(launcher);
        this.overrideLaunchSupported = overrideLaunchSupported;
        this.vsDescription = vsDescription;
        this.vmName = vmName;
        this.waitForVMTools = waitForVMTools;
        this.snapName = snapName;
        this.launchDelay = Util.tryParseNumber((String)launchDelay, (Number)60).intValue();
        this.idleAction = "Shutdown".equals(idleOption) ? MACHINE_ACTION.SHUTDOWN : ("Shutdown and Revert".equals(idleOption) ? MACHINE_ACTION.REVERT : ("Revert and Restart".equals(idleOption) ? MACHINE_ACTION.REVERT_AND_RESTART : ("Revert and Reset".equals(idleOption) ? MACHINE_ACTION.REVERT_AND_RESET : ("Reset".equals(idleOption) ? MACHINE_ACTION.RESET : ("Suspend".equals(idleOption) ? MACHINE_ACTION.SUSPEND : MACHINE_ACTION.NOTHING)))));
        this.LimitedTestRunCount = Util.tryParseNumber((String)LimitedTestRunCount, (Number)0).intValue();
    }

    private vSphereCloudLauncher(ComputerLauncher launcher, Boolean overrideLaunchSupported, String vsDescription, String vmName, Boolean waitForVMTools, String snapName, int launchDelay, MACHINE_ACTION idleAction, int limitedTestRunCount) {
        super(launcher);
        this.overrideLaunchSupported = overrideLaunchSupported;
        this.vsDescription = vsDescription;
        this.vmName = vmName;
        this.waitForVMTools = waitForVMTools;
        this.snapName = snapName;
        this.launchDelay = launchDelay;
        this.idleAction = idleAction;
        this.LimitedTestRunCount = limitedTestRunCount;
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.delegate != null) {
            return new vSphereCloudLauncher(this.delegate, this.overrideLaunchSupported, this.vsDescription, this.vmName, this.waitForVMTools, this.snapName, this.launchDelay, this.idleAction, this.LimitedTestRunCount);
        }
        return this;
    }

    public vSphereCloud findOurVsInstance() throws RuntimeException {
        if (this.vsDescription != null && this.vmName != null) {
            for (vSphereCloud cloud : vSphereCloud.findAllVsphereClouds()) {
                if (!cloud.getVsDescription().equals(this.vsDescription)) continue;
                return cloud;
            }
        }
        vSphereCloud.Log("Could not find our vSphere Cloud instance!", new Object[0]);
        throw new RuntimeException("Could not find our vSphere Cloud instance!");
    }

    public void launch(SlaveComputer slaveComputer, TaskListener taskListener) throws IOException, InterruptedException {
        vSphereCloudSlave vsSlave = (vSphereCloudSlave)slaveComputer.getNode();
        try {
            if (slaveComputer.isTemporarilyOffline()) {
                vSphereCloud.Log(slaveComputer, taskListener, "Not launching VM because it's not accepting tasks; temporarily offline", new Object[0]);
                return;
            }
            if (vsSlave.slaveIsStarting == Boolean.TRUE) {
                vSphereCloud.Log(slaveComputer, taskListener, "Ignoring additional attempt to start the slave; it's already being started", new Object[0]);
                return;
            }
            if (vsSlave.slaveIsDisconnecting == Boolean.TRUE) {
                vSphereCloud.Log(slaveComputer, taskListener, "Ignoring connect attempt to start the slave; it's being shutdown", new Object[0]);
                return;
            }
            vSphereCloudSlave.ProbableLaunchCleanup();
            vSphereCloud vsC = this.findOurVsInstance();
            vsSlave.slaveIsStarting = Boolean.TRUE;
            VSphere v = null;
            try {
                vSphereCloud.Log(slaveComputer, taskListener, "Starting Virtual Machine...", new Object[0]);
                Calendar cal = Calendar.getInstance();
                cal.add(12, 5);
                vSphereCloudSlave.AddProbableLaunch(vsSlave, cal.getTime());
                v = vsC.vSphereInstance();
                VirtualMachine vm = v.getVmByName(this.vmName);
                if (vm == null) {
                    throw new IOException("Virtual Machine '" + this.vmName + "' could not be found");
                }
                if (!this.snapName.isEmpty()) {
                    VirtualMachineSnapshot snap = v.getSnapshotInTree(vm, this.snapName);
                    if (snap == null) {
                        throw new IOException("Virtual Machine '" + this.vmName + "' snapshot '" + this.snapName + "' cannot be found");
                    }
                    vSphereCloud.Log(slaveComputer, taskListener, "Reverting to snapshot:" + this.snapName, new Object[0]);
                    Task task = snap.revertToSnapshot_Task(null);
                    if (!task.waitForTask().equals("success")) {
                        throw new IOException("Error while reverting to virtual machine snapshot");
                    }
                }
                switch (vm.getRuntime().powerState) {
                    case poweredOn: {
                        vSphereCloud.Log(slaveComputer, taskListener, "VM already powered on", new Object[0]);
                        break;
                    }
                    case poweredOff: 
                    case suspended: {
                        vSphereCloud.Log(slaveComputer, taskListener, "Powering on VM", new Object[0]);
                        v.startVm(this.vmName, 60);
                    }
                }
                if (this.waitForVMTools.booleanValue()) {
                    vSphereCloud.Log(slaveComputer, taskListener, "Waiting for VMTools", new Object[0]);
                    Calendar target = Calendar.getInstance();
                    target.add(13, 120);
                    while (Calendar.getInstance().before(target)) {
                        VirtualMachineToolsStatus status = vm.getGuest().toolsStatus;
                        if (status == VirtualMachineToolsStatus.toolsOk || status == VirtualMachineToolsStatus.toolsOld) {
                            vSphereCloud.Log(slaveComputer, taskListener, "VM Tools are running", new Object[0]);
                            break;
                        }
                        Thread.sleep(5000L);
                    }
                    vSphereCloud.Log(slaveComputer, taskListener, "Finished wait for VMTools", new Object[0]);
                }
                if (this.launcher.isLaunchSupported()) {
                    if (this.launchDelay > 0) {
                        vSphereCloud.Log(slaveComputer, taskListener, "Waiting for " + this.launchDelay + " seconds before asking " + this.launcher + " to launch slave.", new Object[0]);
                        Thread.sleep(this.launchDelay * 1000);
                    }
                    vSphereCloud.Log(slaveComputer, taskListener, "Asking " + this.launcher.getClass().getSimpleName() + " to launch slave.", new Object[0]);
                    super.launch(slaveComputer, taskListener);
                } else {
                    vSphereCloud.Log(slaveComputer, taskListener, "Waiting for up to " + this.launchDelay + " seconds for slave to come online.", new Object[0]);
                    for (int i = 0; i <= this.launchDelay; ++i) {
                        Thread.sleep(1000L);
                        if (!slaveComputer.isOnline()) continue;
                        vSphereCloud.Log(slaveComputer, taskListener, "Slave has come online.", new Object[0]);
                        break;
                    }
                    if (!slaveComputer.isOnline()) {
                        vSphereCloud.Log(slaveComputer, taskListener, "Slave did not come online in allowed time", new Object[0]);
                        throw new IOException("Slave did not come online in allowed time");
                    }
                }
                vSphereCloud.Log(slaveComputer, taskListener, "Slave online", new Object[0]);
            }
            catch (Exception e) {
                vSphereCloud.Log(slaveComputer, taskListener, (Throwable)e, "EXCEPTION while starting VM", new Object[0]);
                vsC.markVMOffline(slaveComputer.getDisplayName(), this.vmName);
                throw new RuntimeException(e);
            }
            finally {
                vSphereCloudSlave.RemoveProbableLaunch(vsSlave);
                vsSlave.slaveIsStarting = Boolean.FALSE;
                if (v != null) {
                    v.disconnect();
                }
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void afterDisconnect(SlaveComputer slaveComputer, TaskListener taskListener) {
        vSphereCloudSlave vsSlave = (vSphereCloudSlave)slaveComputer.getNode();
        if (vsSlave == null) {
            vSphereCloud.Log(slaveComputer, taskListener, "Slave is null.", new Object[0]);
            return;
        }
        if (vsSlave.slaveIsStarting == Boolean.TRUE) {
            vSphereCloud.Log(slaveComputer, taskListener, "Ignoring disconnect attempt because a connect attempt is in progress.", new Object[0]);
            return;
        }
        if (vsSlave.slaveIsDisconnecting == Boolean.TRUE) {
            vSphereCloud.Log(slaveComputer, taskListener, "Already disconnecting on a separate thread", new Object[0]);
            return;
        }
        if (slaveComputer.isTemporarilyOffline() && !slaveComputer.getOfflineCauseReason().contains("vSphere Plugin")) {
            vSphereCloud.Log(slaveComputer, taskListener, "Not disconnecting VM because it's not accepting tasks", new Object[0]);
            return;
        }
        vsSlave.slaveIsDisconnecting = Boolean.TRUE;
        VSphere v = null;
        try {
            VirtualMachinePowerState power;
            vSphereCloud.Log(slaveComputer, taskListener, "Running disconnect procedure...", new Object[0]);
            super.afterDisconnect(slaveComputer, taskListener);
            vSphereCloud.Log(slaveComputer, taskListener, "Shutting down Virtual Machine...", new Object[0]);
            MACHINE_ACTION localIdle = this.idleAction;
            if (localIdle == null) {
                localIdle = MACHINE_ACTION.SHUTDOWN;
            }
            vSphereCloud vsC = this.findOurVsInstance();
            vsC.markVMOffline(slaveComputer.getDisplayName(), this.vmName);
            v = vsC.vSphereInstance();
            VirtualMachine vm = v.getVmByName(this.vmName);
            if (vm != null && !MACHINE_ACTION.NOTHING.equals((Object)localIdle) && (power = vm.getSummary().getRuntime().powerState) == VirtualMachinePowerState.poweredOn) {
                switch (localIdle) {
                    case SHUTDOWN: 
                    case REVERT: 
                    case REVERT_AND_RESET: 
                    case REVERT_AND_RESTART: {
                        this.shutdownVM(vm, slaveComputer, taskListener);
                        break;
                    }
                    case SUSPEND: {
                        this.suspendVM(vm, slaveComputer, taskListener);
                        break;
                    }
                    case RESET: {
                        this.resetVM(vm, slaveComputer, taskListener);
                        break;
                    }
                }
                if (localIdle == MACHINE_ACTION.REVERT) {
                    this.revertVM(vm, vsC, slaveComputer, taskListener);
                } else if (localIdle == MACHINE_ACTION.REVERT_AND_RESTART) {
                    this.revertVM(vm, vsC, slaveComputer, taskListener);
                    if (power == VirtualMachinePowerState.poweredOn) {
                        Thread.sleep(60000L);
                        this.shutdownVM(vm, slaveComputer, taskListener);
                    }
                    this.powerOnVM(vm, slaveComputer, taskListener);
                } else if (localIdle == MACHINE_ACTION.REVERT_AND_RESET) {
                    this.revertVM(vm, vsC, slaveComputer, taskListener);
                    this.resetVM(vm, slaveComputer, taskListener);
                }
            }
            if (v != null) {
                v.disconnect();
            }
        }
        catch (Throwable t) {
            vSphereCloud.Log(slaveComputer, taskListener, t, "Got an exception", new Object[0]);
            taskListener.fatalError(t.getMessage(), new Object[]{t});
        }
        finally {
            vsSlave.slaveIsDisconnecting = Boolean.FALSE;
            vsSlave.slaveIsStarting = Boolean.FALSE;
        }
    }

    @Deprecated
    public ComputerLauncher getDelegate() {
        return this.launcher;
    }

    public String getVmName() {
        return this.vmName;
    }

    public String getVsDescription() {
        return this.vsDescription;
    }

    public MACHINE_ACTION getIdleAction() {
        return this.idleAction;
    }

    public Boolean getOverrideLaunchSupported() {
        return this.overrideLaunchSupported;
    }

    public Boolean getWaitForVMTools() {
        return this.waitForVMTools;
    }

    public Integer getLimitedTestRunCount() {
        return this.LimitedTestRunCount;
    }

    public boolean isLaunchSupported() {
        if (this.overrideLaunchSupported == null) {
            return this.launcher.isLaunchSupported();
        }
        return this.overrideLaunchSupported;
    }

    public Descriptor<ComputerLauncher> getDescriptor() {
        throw new UnsupportedOperationException();
    }

    private void powerOnVM(VirtualMachine vm, SlaveComputer slaveComputer, TaskListener taskListener) throws RemoteException, InterruptedException {
        vSphereCloud.Log(slaveComputer, taskListener, "Powering on the VM", new Object[0]);
        Task taskPowerOn = vm.powerOnVM_Task(null);
        if (!taskPowerOn.waitForTask().equals("success")) {
            vSphereCloud.Log(slaveComputer, taskListener, "Unable to power on the VM", new Object[0]);
        }
    }

    private void shutdownVM(VirtualMachine vm, SlaveComputer slaveComputer, TaskListener taskListener) throws RemoteException, InterruptedException {
        VirtualMachineToolsStatus status = vm.getGuest().toolsStatus;
        if (status == VirtualMachineToolsStatus.toolsOk || status == VirtualMachineToolsStatus.toolsOld) {
            try {
                vSphereCloud.Log(slaveComputer, taskListener, "Attempting a graceful shutdown", new Object[0]);
                vm.shutdownGuest();
                Calendar target = Calendar.getInstance();
                target.add(12, 3);
                while (Calendar.getInstance().before(target)) {
                    if (vm.getRuntime().powerState == VirtualMachinePowerState.poweredOff) {
                        vSphereCloud.Log(slaveComputer, taskListener, "Guest shutdown succeeded", new Object[0]);
                        break;
                    }
                    Thread.sleep(5000L);
                }
            }
            catch (Throwable t) {
                vSphereCloud.Log(slaveComputer, taskListener, t, "Got an exception while attempting a graceful shutdown", new Object[0]);
                vSphereCloud.Log(slaveComputer, taskListener, "Will now attempt a hard power down", new Object[0]);
            }
        }
        if (vm.getRuntime().powerState == VirtualMachinePowerState.poweredOn) {
            vSphereCloud.Log(slaveComputer, taskListener, "Powering down hard", new Object[0]);
            Task task = vm.powerOffVM_Task();
            if (!task.waitForTask().equals("success")) {
                vSphereCloud.Log(slaveComputer, taskListener, "Unable to power down the VM", new Object[0]);
            }
        }
    }

    private void revertVM(VirtualMachine vm, vSphereCloud vsC, SlaveComputer slaveComputer, TaskListener taskListener) throws IOException, InterruptedException, VSphereException {
        if (!this.snapName.isEmpty()) {
            VirtualMachineSnapshot snap = vsC.vSphereInstance().getSnapshotInTree(vm, this.snapName);
            if (snap == null) {
                throw new IOException("Virtual Machine snapshot cannot be found");
            }
            vSphereCloud.Log(slaveComputer, taskListener, "Reverting to snapshot:" + this.snapName, new Object[0]);
            Task task = snap.revertToSnapshot_Task(null);
            if (!task.waitForTask().equals("success")) {
                throw new IOException("Error while reverting to virtual machine snapshot");
            }
        } else {
            vSphereCloud.Log(slaveComputer, taskListener, "Reverting to current snapshot", new Object[0]);
            Task task = vm.revertToCurrentSnapshot_Task(null);
            if (!task.waitForTask().equals("success")) {
                throw new IOException("Error while reverting to virtual machine snapshot");
            }
        }
    }

    private void resetVM(VirtualMachine vm, SlaveComputer slaveComputer, TaskListener taskListener) throws RemoteException, InterruptedException {
        vSphereCloud.Log(slaveComputer, taskListener, "Resetting the VM", new Object[0]);
        Task taskReset = vm.resetVM_Task();
        if (!taskReset.waitForTask().equals("success")) {
            vSphereCloud.Log(slaveComputer, taskListener, "Unable to reset the VM", new Object[0]);
        }
    }

    private void suspendVM(VirtualMachine vm, SlaveComputer slaveComputer, TaskListener taskListener) throws RemoteException, InterruptedException {
        vSphereCloud.Log(slaveComputer, taskListener, "Suspending the VM", new Object[0]);
        Task task = vm.suspendVM_Task();
        if (!task.waitForTask().equals("success")) {
            vSphereCloud.Log(slaveComputer, taskListener, "Unable to suspend the VM", new Object[0]);
        }
    }

    public static enum MACHINE_ACTION {
        SHUTDOWN,
        REVERT,
        REVERT_AND_RESET,
        REVERT_AND_RESTART,
        SUSPEND,
        RESET,
        NOTHING;

    }
}

