/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vsphere.builders;

import com.vmware.vim25.mo.VirtualMachine;
import com.vmware.vim25.mo.VirtualMachineSnapshot;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.EnvironmentContributingAction;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepMonitor;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.plugins.vsphere.VSphereBuildStep;
import org.jenkinsci.plugins.vsphere.builders.Messages;
import org.jenkinsci.plugins.vsphere.tools.VSphere;
import org.jenkinsci.plugins.vsphere.tools.VSphereException;
import org.jenkinsci.plugins.vsphere.tools.VSphereLogger;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class Deploy
extends VSphereBuildStep
implements SimpleBuildStep {
    private final String template;
    private final String clone;
    private final boolean linkedClone;
    private final String resourcePool;
    private final String cluster;
    private final String datastore;
    private final boolean powerOn;
    private String IP;

    @DataBoundConstructor
    public Deploy(String template, String clone, boolean linkedClone, String resourcePool, String cluster, String datastore, boolean powerOn) throws VSphereException {
        this.template = template;
        this.clone = clone;
        this.linkedClone = linkedClone;
        this.resourcePool = resourcePool != null ? resourcePool : "";
        this.cluster = cluster;
        this.datastore = datastore;
        this.powerOn = powerOn;
    }

    public String getTemplate() {
        return this.template;
    }

    public String getClone() {
        return this.clone;
    }

    public boolean isLinkedClone() {
        return this.linkedClone;
    }

    public String getCluster() {
        return this.cluster;
    }

    public String getResourcePool() {
        return this.resourcePool;
    }

    public String getDatastore() {
        return this.datastore;
    }

    public boolean isPowerOn() {
        return this.powerOn;
    }

    @Override
    public String getIP() {
        return this.IP;
    }

    @Override
    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath filePath, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        try {
            this.deployFromTemplate(run, launcher, listener);
        }
        catch (Exception e) {
            throw new AbortException(e.getMessage());
        }
    }

    public boolean prebuild(AbstractBuild<?, ?> abstractBuild, BuildListener buildListener) {
        return false;
    }

    @Override
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        boolean retVal = false;
        try {
            retVal = this.deployFromTemplate((Run<?, ?>)build, launcher, (TaskListener)listener);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retVal;
    }

    public Action getProjectAction(AbstractProject<?, ?> abstractProject) {
        return null;
    }

    public Collection<? extends Action> getProjectActions(AbstractProject<?, ?> abstractProject) {
        return null;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return null;
    }

    private boolean deployFromTemplate(Run<?, ?> run, Launcher launcher, TaskListener listener) throws VSphereException {
        EnvVars env;
        PrintStream jLogger = listener.getLogger();
        String expandedClone = this.clone;
        String expandedTemplate = this.template;
        String expandedCluster = this.cluster;
        String expandedDatastore = this.datastore;
        try {
            env = run.getEnvironment(listener);
        }
        catch (Exception e) {
            throw new VSphereException(e);
        }
        if (run instanceof AbstractBuild) {
            env.overrideAll(((AbstractBuild)run).getBuildVariables());
            expandedClone = env.expand(this.clone);
            expandedTemplate = env.expand(this.template);
            expandedCluster = env.expand(this.cluster);
            expandedDatastore = env.expand(this.datastore);
        }
        String resourcePoolName = "".equals(this.resourcePool) || this.resourcePool.length() == 0 ? "Resources" : env.expand(this.resourcePool);
        this.vsphere.deployVm(expandedClone, expandedTemplate, this.linkedClone, resourcePoolName, expandedCluster, expandedDatastore, this.powerOn, jLogger);
        VSphereLogger.vsLogger(jLogger, "\"" + expandedClone + "\" successfully deployed!");
        this.IP = this.vsphere.getIp(this.vsphere.getVmByName(expandedClone), 60);
        if (this.IP != null) {
            VSphereLogger.vsLogger(jLogger, "Successfully retrieved IP for \"" + expandedClone + "\" : " + this.IP);
            VSphereLogger.vsLogger(jLogger, "Exposing " + this.IP + " as environment variable VSPHERE_IP");
            if (run instanceof AbstractBuild) {
                VSphereEnvAction envAction = new VSphereEnvAction();
                envAction.add("VSPHERE_IP", this.IP);
                run.addAction((Action)envAction);
            }
            return true;
        }
        VSphereLogger.vsLogger(jLogger, "Error: Timed out after waiting 60 seconds to get IP for \"" + expandedClone + "\" ");
        return false;
    }

    private static class VSphereEnvAction
    implements EnvironmentContributingAction {
        private transient Map<String, String> data = new HashMap<String, String>();

        private VSphereEnvAction() {
        }

        private void add(String key, String val) {
            if (this.data == null) {
                return;
            }
            this.data.put(key, val);
        }

        public void buildEnvVars(AbstractBuild<?, ?> build, EnvVars env) {
            if (this.data != null) {
                env.putAll(this.data);
            }
        }

        public String getIconFileName() {
            return null;
        }

        public String getDisplayName() {
            return null;
        }

        public String getUrlName() {
            return null;
        }
    }

    @Extension
    public static final class DeployDescriptor
    extends VSphereBuildStep.VSphereBuildStepDescriptor {
        public DeployDescriptor() {
            this.load();
        }

        public String getDisplayName() {
            return Messages.vm_title_Deploy();
        }

        public FormValidation doCheckTemplate(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please enter the template name");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckClone(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)Messages.validation_required("the clone name"));
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckResourcePool(@QueryParameter String value) throws IOException, ServletException {
            return FormValidation.ok();
        }

        public FormValidation doCheckCluster(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)Messages.validation_required("the cluster"));
            }
            return FormValidation.ok();
        }

        public FormValidation doTestData(@QueryParameter String serverName, @QueryParameter String template, @QueryParameter String clone, @QueryParameter String resourcePool, @QueryParameter String cluster) {
            try {
                if (template.length() == 0 || clone.length() == 0 || serverName.length() == 0 || cluster.length() == 0) {
                    return FormValidation.error((String)Messages.validation_requiredValues());
                }
                VSphere vsphere = DeployDescriptor.getVSphereCloudByName(serverName).vSphereInstance();
                VirtualMachine cloneVM = vsphere.getVmByName(clone);
                if (cloneVM != null) {
                    return FormValidation.error((String)Messages.validation_exists("clone"));
                }
                if (template.indexOf(36) >= 0) {
                    return FormValidation.warning((String)Messages.validation_buildParameter("template"));
                }
                VirtualMachine vm = vsphere.getVmByName(template);
                if (vm == null) {
                    return FormValidation.error((String)Messages.validation_notFound("template"));
                }
                if (!vm.getConfig().template) {
                    return FormValidation.error((String)Messages.validation_notActually("template"));
                }
                VirtualMachineSnapshot snap = vm.getCurrentSnapShot();
                if (snap == null) {
                    return FormValidation.error((String)Messages.validation_noSnapshots());
                }
                return FormValidation.ok((String)Messages.validation_success());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

