/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vsphere.builders;

import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.ServletException;
import org.jenkinsci.plugins.vsphere.VSphereBuildStep;
import org.jenkinsci.plugins.vsphere.builders.Messages;
import org.jenkinsci.plugins.vsphere.tools.VSphere;
import org.jenkinsci.plugins.vsphere.tools.VSphereException;
import org.jenkinsci.plugins.vsphere.tools.VSphereLogger;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvertToTemplate
extends VSphereBuildStep {
    private final String vm;
    private final boolean force;

    @DataBoundConstructor
    public ConvertToTemplate(String vm, boolean force) throws VSphereException {
        this.force = force;
        this.vm = vm;
    }

    public String getVm() {
        return this.vm;
    }

    public boolean isForce() {
        return this.force;
    }

    @Override
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        PrintStream jLogger = listener.getLogger();
        boolean changed = false;
        try {
            changed = this.convert(build, launcher, listener);
        }
        catch (VSphereException e) {
            VSphereLogger.vsLogger(jLogger, e.getMessage());
        }
        return changed;
    }

    private boolean convert(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws VSphereException {
        EnvVars env;
        PrintStream jLogger = listener.getLogger();
        VSphereLogger.vsLogger(jLogger, "Converting VM to template. Please wait ...");
        try {
            env = build.getEnvironment((TaskListener)listener);
        }
        catch (Exception e) {
            throw new VSphereException(e);
        }
        Date date = new Date();
        SimpleDateFormat df = new SimpleDateFormat("MMM dd, yyyy hh:mm:ss aaa");
        env.overrideAll(build.getBuildVariables());
        String expandedVm = env.expand(this.vm);
        this.vsphere.markAsTemplate(expandedVm, df.format(date), this.force);
        VSphereLogger.vsLogger(jLogger, "\"" + expandedVm + "\" is now a template.");
        return true;
    }

    @Extension
    public static final class ConvertToTemplateDescriptor
    extends VSphereBuildStep.VSphereBuildStepDescriptor {
        public ConvertToTemplateDescriptor() {
            this.load();
        }

        public String getDisplayName() {
            return Messages.vm_title_ConvertToTemplate();
        }

        public FormValidation doCheckVm(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)Messages.validation_required("the VM name"));
            }
            return FormValidation.ok();
        }

        public FormValidation doTestData(@QueryParameter String serverName, @QueryParameter String vm) {
            try {
                if (serverName.length() == 0 || vm.length() == 0) {
                    return FormValidation.error((String)Messages.validation_requiredValues());
                }
                if (vm.indexOf(36) >= 0) {
                    return FormValidation.warning((String)Messages.validation_buildParameter("VM"));
                }
                VSphere vsphere = ConvertToTemplateDescriptor.getVSphereCloudByName(serverName).vSphereInstance();
                if (vsphere.getVmByName(vm) == null) {
                    return FormValidation.error((String)Messages.validation_notFound("VM"));
                }
                return FormValidation.ok((String)Messages.validation_success());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

