/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vsphere.builders;

import com.vmware.vim25.mo.VirtualMachine;
import com.vmware.vim25.mo.VirtualMachineSnapshot;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.EnvironmentContributingAction;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import org.jenkinsci.plugins.vsphere.VSpherePlugin;
import org.jenkinsci.plugins.vsphere.builders.Messages;
import org.jenkinsci.plugins.vsphere.tools.VSphere;
import org.jenkinsci.plugins.vsphere.tools.VSphereConstants;
import org.jenkinsci.plugins.vsphere.tools.VSphereException;
import org.jenkinsci.plugins.vsphere.tools.VSphereLogger;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Starter
extends Builder {
    private final String template;
    private final String serverName;
    private final String clone;
    private final boolean powerOn;
    private final boolean linkedClone;
    private final int serverHash;
    private VSphere vsphere = null;

    @DataBoundConstructor
    public Starter(String serverName, String template, String clone, boolean powerOn, boolean linkedClone) throws VSphereException {
        this.template = template;
        this.serverName = serverName;
        this.clone = clone;
        this.powerOn = powerOn;
        this.linkedClone = linkedClone;
        this.serverHash = VSpherePlugin.DescriptorImpl.get().getVSphereCloudByName(serverName).getHash();
    }

    public String getTemplate() {
        return this.template;
    }

    public String getClone() {
        return this.clone;
    }

    public String getServerName() {
        return this.serverName;
    }

    public boolean isPowerOn() {
        return this.powerOn;
    }

    public boolean isLinkedClone() {
        return this.linkedClone;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        PrintStream jLogger = listener.getLogger();
        VSphereLogger.vsLogger(jLogger, "Attempting to use server configuration: " + this.serverName);
        boolean success = false;
        try {
            this.vsphere = VSpherePlugin.DescriptorImpl.get().getVSphereCloudByHash(this.serverHash).vSphereInstance();
            success = this.deployFromTemplate(build, launcher, listener);
        }
        catch (VSphereException e) {
            VSphereLogger.vsLogger(jLogger, e.getMessage());
            e.printStackTrace(jLogger);
        }
        return success;
    }

    private boolean deployFromTemplate(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws VSphereException {
        EnvVars env;
        PrintStream jLogger = listener.getLogger();
        VSphereLogger.vsLogger(jLogger, "Cloning VM. Please wait ...");
        try {
            env = build.getEnvironment((TaskListener)listener);
        }
        catch (Exception e) {
            throw new VSphereException(e);
        }
        env.overrideAll(build.getBuildVariables());
        String expandedClone = env.expand(this.clone);
        String expandedTemplate = env.expand(this.template);
        VirtualMachine vm = this.vsphere.shallowCloneVm(expandedClone, expandedTemplate, this.powerOn, this.linkedClone);
        if (vm == null) {
            throw new VSphereException("VM is null");
        }
        if (!this.powerOn) {
            VSphereLogger.vsLogger(jLogger, "Clone successful!");
            return true;
        }
        VSphereLogger.vsLogger(jLogger, "Clone successful! Waiting a maximum of " + VSphereConstants.IP_MAX_SECONDS * VSphereConstants.IP_MAX_TRIES + " seconds for IP.");
        String vmIP = this.vsphere.getIp(vm);
        if (vmIP != null) {
            VSphereLogger.vsLogger(jLogger, "Got IP for \"" + expandedClone + "\" ");
            VSphereEnvAction envAction = new VSphereEnvAction();
            envAction.add("VSPHERE_IP", vmIP);
            build.addAction((Action)envAction);
            return true;
        }
        VSphereLogger.vsLogger(jLogger, "Error: Could not get IP for \"" + expandedClone + "\" ");
        return false;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class VSphereEnvAction
    implements EnvironmentContributingAction {
        private transient Map<String, String> data = new HashMap<String, String>();

        private VSphereEnvAction() {
        }

        private void add(String key, String val) {
            if (this.data == null) {
                return;
            }
            this.data.put(key, val);
        }

        public void buildEnvVars(AbstractBuild<?, ?> build, EnvVars env) {
            if (this.data != null) {
                env.putAll(this.data);
            }
        }

        public String getIconFileName() {
            return null;
        }

        public String getDisplayName() {
            return null;
        }

        public String getUrlName() {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public DescriptorImpl() {
            this.load();
        }

        public String getDisplayName() {
            return VSphere.vSphereOutput(Messages.vm_title_Starter());
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public FormValidation doCheckTemplate(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please enter the template name");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckClone(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please enter the clone name");
            }
            return FormValidation.ok();
        }

        public FormValidation doTestData(@QueryParameter String serverName, @QueryParameter String template, @QueryParameter String clone) {
            try {
                VSphere vsphere = VSpherePlugin.DescriptorImpl.get().getVSphereCloudByName(serverName).vSphereInstance();
                VirtualMachine vm = vsphere.getVmByName(template);
                if (vm == null) {
                    return FormValidation.error((String)"Specified template not found!");
                }
                if (!vm.getConfig().template) {
                    return FormValidation.error((String)"Specified template is not actually a template!");
                }
                VirtualMachineSnapshot snap = vm.getCurrentSnapShot();
                if (snap == null) {
                    return FormValidation.error((String)"No snapshots found for specified template!");
                }
                VirtualMachine cloneVM = vsphere.getVmByName(clone);
                if (cloneVM != null) {
                    return FormValidation.error((String)"Specified clone already exists!");
                }
                return FormValidation.ok((String)"Success");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public ListBoxModel doFillServerNameItems() {
            return VSpherePlugin.DescriptorImpl.get().doFillServerItems();
        }
    }
}

