/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.violations.types.jcreport;

import hudson.plugins.violations.model.FullFileModel;
import hudson.plugins.violations.model.Severity;
import hudson.plugins.violations.model.Violation;
import hudson.plugins.violations.parse.AbstractTypeParser;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.xmlpull.v1.XmlPullParserException;

public class JcReportParser
extends AbstractTypeParser {
    private static final Map<String, String> SEVERITIES = new HashMap<String, String>();

    protected void execute() throws IOException, XmlPullParserException {
        this.expectNextTag("report");
        this.getParser().next();
        while (this.skipToTag("file")) {
            this.parseFileElement();
        }
        this.endElement();
    }

    private void parseFileElement() throws IOException, XmlPullParserException {
        String name = this.getString("name");
        this.getParser().next();
        if (null != name && name.length() > 0) {
            FullFileModel fileModel = null;
            while (this.skipToTag("item")) {
                Violation violation = this.parseItemElement();
                if (null != violation) {
                    if (fileModel == null) {
                        fileModel = this.getFileModel(this.fixAbsolutePath(name));
                    }
                    fileModel.addViolation(this.parseItemElement());
                }
                this.getParser().next();
                this.endElement();
            }
        }
        this.endElement();
    }

    private Violation parseItemElement() throws IOException, XmlPullParserException {
        String severity = SEVERITIES.get(this.getString("severity"));
        Violation ret = null;
        if (severity != null) {
            ret = new Violation();
            ret.setType("jcreport");
            ret.setLine(this.getString("line"));
            ret.setMessage(this.getString("message"));
            ret.setSource(this.getString("finding-type"));
            ret.setSeverity(severity);
            ret.setSeverityLevel(Severity.getSeverityLevel(severity));
        }
        return ret;
    }

    static {
        SEVERITIES.put("error", "High");
        SEVERITIES.put("cpd", "Medium High");
        SEVERITIES.put("warning", "Medium");
        SEVERITIES.put("design", "Medium Low");
        SEVERITIES.put("code-style", "Low");
        SEVERITIES.put("info", null);
        SEVERITIES.put("coverage", null);
        SEVERITIES.put("ok", null);
        SEVERITIES.put("filtered", null);
    }
}

