/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.violations.types.findbugs;

import hudson.plugins.violations.TypeDescriptor;
import hudson.plugins.violations.parse.AbstractParser;
import hudson.plugins.violations.parse.AbstractTypeParser;
import hudson.plugins.violations.parse.ParseXML;
import hudson.plugins.violations.types.findbugs.FindBugsParser;
import hudson.plugins.violations.util.CloseUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FindBugsDescriptor
extends TypeDescriptor {
    private static final String[] MESSAGES = new String[]{"findbugs-1.3.3-rc2.messages.xml", "fb-contrib-3.4.2.messages.xml"};
    public static final FindBugsDescriptor DESCRIPTOR = new FindBugsDescriptor();
    private static Map<String, String> messageMap = new HashMap<String, String>();
    private static Map<String, String> detailMap = new HashMap<String, String>();

    private FindBugsDescriptor() {
        super("findbugs");
    }

    @Override
    public AbstractTypeParser createParser() {
        return new FindBugsParser();
    }

    @Override
    public List<String> getMavenTargets() {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add("findbugsXml.xml");
        ret.add("findbugs.xml");
        return ret;
    }

    @Override
    public String getDetailForSource(String source) {
        return detailMap.get(source);
    }

    public static Map<String, String> getMessageMap() {
        return messageMap;
    }

    private static void parseMessages() {
        for (String name : MESSAGES) {
            FindBugsDescriptor.parseMessages(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void parseMessages(String filename) {
        InputStream is = null;
        try {
            is = FindBugsParser.class.getResourceAsStream(filename);
            if (is != null) {
                ParseXML.parse(is, (AbstractParser)new ParseMessages());
            }
        }
        catch (Exception exception) {
        }
        finally {
            CloseUtil.close(is);
        }
    }

    static {
        FindBugsDescriptor.parseMessages();
    }

    private static class ParseMessages
    extends AbstractParser {
        private ParseMessages() {
        }

        public void execute() {
            try {
                this.doIt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void doIt() throws Exception {
            while (true) {
                this.toTag("BugPattern");
                String type = this.checkNotBlank("type");
                this.toTag("ShortDescription");
                String desc = this.getNextText("missin");
                messageMap.put(type, desc);
                this.toTag("Details");
                String details = this.getNextText("Details");
                detailMap.put(type, details);
            }
        }

        private void toTag(String name) throws Exception {
            while (this.getParser().getEventType() != 2 || !this.getParser().getName().equals(name)) {
                this.getParser().next();
            }
            return;
        }
    }
}

