/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.violations.hudson;

import hudson.maven.AbstractMavenProject;
import hudson.model.AbstractProject;
import hudson.plugins.violations.TypeConfig;
import hudson.plugins.violations.ViolationsConfig;
import hudson.plugins.violations.ViolationsPublisher;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import java.util.Map;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ViolationsFreestyleDescriptor
extends BuildStepDescriptor<Publisher> {
    public ViolationsFreestyleDescriptor() {
        super(ViolationsPublisher.class);
        this.load();
    }

    public String getDisplayName() {
        return "Report Violations";
    }

    public String getHelpFile() {
        return "/plugin/violations/help.html";
    }

    public Publisher newInstance(StaplerRequest req, JSONObject formData) {
        ViolationsPublisher pub = new ViolationsPublisher();
        req.bindParameters((Object)pub, "violations.");
        req.bindParameters((Object)pub.getConfig(), "config.");
        for (Map.Entry<String, TypeConfig> entry : pub.getConfig().getTypeConfigs().entrySet()) {
            String type = entry.getKey();
            TypeConfig c = entry.getValue();
            req.bindParameters((Object)c, type + ".");
            if ("".equals(req.getParameter(type + ".min"))) {
                c.setMin(10);
            }
            if (!"".equals(req.getParameter(type + ".max"))) continue;
            c.setMax(999);
        }
        pub.getConfig().fix();
        return pub;
    }

    public ViolationsConfig getConfig() {
        return new ViolationsConfig();
    }

    public boolean isFreeStyle() {
        return true;
    }

    public boolean isApplicable(Class<? extends AbstractProject> jobType) {
        return !AbstractMavenProject.class.isAssignableFrom(jobType);
    }
}

