/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.violations.generate;

import java.util.logging.Level;
import java.util.logging.Logger;

public final class XMLUtil {
    private static final Logger LOG = Logger.getLogger(XMLUtil.class.getName());

    private XMLUtil() {
        LOG.log(Level.FINE, "private constructor called");
    }

    public static String escapeHTMLContent(String tabIcon, String str) {
        StringBuilder b = new StringBuilder();
        char[] chars = str.toCharArray();
        block7: for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            switch (c) {
                case '<': {
                    b.append("&lt;");
                    continue block7;
                }
                case '>': {
                    b.append("&gt;");
                    continue block7;
                }
                case '&': {
                    b.append("&amp;");
                    continue block7;
                }
                case ' ': {
                    b.append("&nbsp;");
                    continue block7;
                }
                case '\t': {
                    b.append("<img src='" + tabIcon + "' title='tab'/>");
                    b.append("&nbsp;");
                    continue block7;
                }
                default: {
                    b.append(c);
                }
            }
        }
        return b.toString();
    }

    public static String escapeContent(String str) {
        StringBuilder b = new StringBuilder();
        char[] chars = str.toCharArray();
        block5: for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            switch (c) {
                case '<': {
                    b.append("&lt;");
                    continue block5;
                }
                case '>': {
                    b.append("&gt;");
                    continue block5;
                }
                case '&': {
                    b.append("&amp;");
                    continue block5;
                }
                default: {
                    b.append(c);
                }
            }
        }
        return b.toString();
    }

    public static String escapeAttribute(String str) {
        StringBuilder b = new StringBuilder();
        char[] chars = str.toCharArray();
        block6: for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            switch (c) {
                case '<': {
                    b.append("&lt;");
                    continue block6;
                }
                case '>': {
                    b.append("&gt;");
                    continue block6;
                }
                case '&': {
                    b.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    b.append("&quot;");
                    continue block6;
                }
                default: {
                    b.append(c);
                }
            }
        }
        return b.toString();
    }

    public static String toAttribute(String name, String value) {
        return " " + name + "=\"" + XMLUtil.escapeAttribute(value) + "\"";
    }

    public static String toAttribute(String name, int value) {
        return " " + name + "=\"" + value + "\"";
    }
}

