/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.jvctgl.config;

import com.google.common.base.Strings;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jenkinsci.plugins.jvctgl.ViolationsToGitLabGlobalConfiguration;
import org.jenkinsci.plugins.jvctgl.config.CredentialsHelper;
import org.jenkinsci.plugins.jvctgl.config.ViolationConfig;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import se.bjurr.violations.lib.model.SEVERITY;
import se.bjurr.violations.lib.util.Utils;

public class ViolationsToGitLabConfig
extends AbstractDescribableImpl<ViolationsToGitLabConfig>
implements Serializable {
    private static final long serialVersionUID = 4851568645021422528L;
    private boolean commentOnlyChangedContent;
    private boolean commentOnlyChangedFiles = true;
    private boolean createCommentWithAllSingleFileComments;
    private boolean createSingleFileComments;
    private List<ViolationConfig> violationConfigs;
    private String gitLabUrl;
    private String apiToken;
    private String projectId;
    private String mergeRequestIid;
    @Deprecated
    private transient String mergeRequestId;
    private String apiTokenCredentialsId;
    private Boolean ignoreCertificateErrors;
    private Boolean apiTokenPrivate;
    private Boolean authMethodHeader;
    private SEVERITY minSeverity;
    private Boolean keepOldComments;
    private String commentTemplate;
    private Boolean shouldSetWip;
    private String proxyUri;
    private String proxyUser;
    private String proxyPassword;
    private Boolean enableLogging;
    private Integer maxNumberOfViolations;

    @DataBoundConstructor
    public ViolationsToGitLabConfig(String gitLabUrl, String projectId, String mergeRequestIid) {
        this.gitLabUrl = gitLabUrl;
        this.projectId = projectId;
        this.mergeRequestIid = mergeRequestIid;
        this.keepOldComments = true;
        this.shouldSetWip = false;
        this.enableLogging = false;
        this.maxNumberOfViolations = null;
    }

    public ViolationsToGitLabConfig(ViolationsToGitLabConfig rhs) {
        this.violationConfigs = rhs.violationConfigs;
        this.createCommentWithAllSingleFileComments = rhs.createCommentWithAllSingleFileComments;
        this.createSingleFileComments = rhs.createSingleFileComments;
        this.commentOnlyChangedContent = rhs.commentOnlyChangedContent;
        this.commentOnlyChangedFiles = rhs.commentOnlyChangedFiles;
        this.gitLabUrl = rhs.gitLabUrl;
        this.apiToken = rhs.apiToken;
        this.projectId = rhs.projectId;
        this.mergeRequestIid = rhs.mergeRequestIid;
        this.apiTokenCredentialsId = rhs.apiTokenCredentialsId;
        this.ignoreCertificateErrors = rhs.ignoreCertificateErrors;
        this.apiTokenPrivate = rhs.apiTokenPrivate;
        this.authMethodHeader = rhs.authMethodHeader;
        this.minSeverity = rhs.minSeverity;
        this.keepOldComments = rhs.keepOldComments;
        this.commentTemplate = rhs.commentTemplate;
        this.shouldSetWip = rhs.shouldSetWip;
        this.proxyUri = rhs.proxyUri;
        this.proxyUser = rhs.proxyUser;
        this.proxyPassword = rhs.proxyPassword;
        this.enableLogging = rhs.enableLogging;
        this.maxNumberOfViolations = rhs.maxNumberOfViolations;
    }

    public String getCommentTemplate() {
        return this.commentTemplate;
    }

    @DataBoundSetter
    public void setCommentTemplate(String commentTemplate) {
        this.commentTemplate = commentTemplate;
    }

    private Object readResolve() {
        if (Strings.isNullOrEmpty((String)this.mergeRequestIid)) {
            this.mergeRequestIid = this.mergeRequestId;
        }
        return this;
    }

    public ViolationsToGitLabConfig() {
        this.violationConfigs = new ArrayList<ViolationConfig>();
    }

    public void applyDefaults(ViolationsToGitLabGlobalConfiguration defaults) {
        if (defaults == null) {
            return;
        }
        if (Strings.isNullOrEmpty((String)this.gitLabUrl)) {
            this.gitLabUrl = defaults.getGitLabUrl();
        }
        if (Strings.isNullOrEmpty((String)this.apiToken)) {
            this.apiToken = defaults.getApiToken();
        }
        if (Strings.isNullOrEmpty((String)this.apiTokenCredentialsId)) {
            this.apiTokenCredentialsId = defaults.getApiTokenCredentialsId();
        }
        if (this.ignoreCertificateErrors == null) {
            this.ignoreCertificateErrors = defaults.isIgnoreCertificateErrors();
        }
        if (this.apiTokenPrivate == null) {
            this.apiTokenPrivate = defaults.isApiTokenPrivate();
        }
        if (this.authMethodHeader == null) {
            this.authMethodHeader = defaults.isAuthMethodHeader();
        }
        if (this.minSeverity == null) {
            this.minSeverity = defaults.getMinSeverity();
        }
    }

    public String getGitLabUrl() {
        return this.gitLabUrl;
    }

    public boolean getCommentOnlyChangedContent() {
        return this.commentOnlyChangedContent;
    }

    public boolean getCreateCommentWithAllSingleFileComments() {
        return this.createCommentWithAllSingleFileComments;
    }

    public boolean getCreateSingleFileComments() {
        return this.createSingleFileComments;
    }

    public List<ViolationConfig> getViolationConfigs() {
        return this.violationConfigs;
    }

    @DataBoundSetter
    public void setIgnoreCertificateErrors(Boolean ignoreCertificateErrors) {
        this.ignoreCertificateErrors = ignoreCertificateErrors;
    }

    @DataBoundSetter
    public void setApiTokenPrivate(Boolean apiTokenPrivate) {
        this.apiTokenPrivate = apiTokenPrivate;
    }

    public void setMergeRequestIid(String mergeRequestIid) {
        this.mergeRequestIid = mergeRequestIid;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    @DataBoundSetter
    public void setApiTokenCredentialsId(String apiTokenCredentialsId) {
        this.apiTokenCredentialsId = apiTokenCredentialsId;
    }

    @DataBoundSetter
    public void setAuthMethodHeader(Boolean authMethodHeader) {
        this.authMethodHeader = authMethodHeader;
    }

    public String getApiToken() {
        return this.apiToken;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public Boolean getAuthMethodHeader() {
        return this.authMethodHeader;
    }

    public Boolean getApiTokenPrivate() {
        return this.apiTokenPrivate;
    }

    public String getMergeRequestIid() {
        return this.mergeRequestIid;
    }

    public String getApiTokenCredentialsId() {
        return this.apiTokenCredentialsId;
    }

    public Boolean getIgnoreCertificateErrors() {
        return (Boolean)Utils.firstNonNull((Object)this.ignoreCertificateErrors, (Object)false);
    }

    @DataBoundSetter
    public void setCreateCommentWithAllSingleFileComments(boolean createCommentWithAllSingleFileComments) {
        this.createCommentWithAllSingleFileComments = createCommentWithAllSingleFileComments;
    }

    @DataBoundSetter
    public void setCreateSingleFileComments(boolean createSingleFileComments) {
        this.createSingleFileComments = createSingleFileComments;
    }

    public SEVERITY getMinSeverity() {
        return this.minSeverity;
    }

    @DataBoundSetter
    public void setMinSeverity(SEVERITY minSeverity) {
        this.minSeverity = minSeverity;
    }

    @DataBoundSetter
    public void setCommentOnlyChangedContent(boolean commentOnlyChangedContent) {
        this.commentOnlyChangedContent = commentOnlyChangedContent;
    }

    @DataBoundSetter
    public void setCommentOnlyChangedFiles(boolean commentOnlyChangedFiles) {
        this.commentOnlyChangedFiles = commentOnlyChangedFiles;
    }

    public boolean getCommentOnlyChangedFiles() {
        return this.commentOnlyChangedFiles;
    }

    @DataBoundSetter
    public void setViolationConfigs(List<ViolationConfig> violationConfigs) {
        this.violationConfigs = violationConfigs;
    }

    public void setGitLabUrl(String gitLabUrl) {
        this.gitLabUrl = gitLabUrl;
    }

    @DataBoundSetter
    public void setApiToken(String apiToken) {
        this.apiToken = apiToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ViolationsToGitLabConfig that = (ViolationsToGitLabConfig)o;
        return this.commentOnlyChangedContent == that.commentOnlyChangedContent && this.commentOnlyChangedFiles == that.commentOnlyChangedFiles && this.createCommentWithAllSingleFileComments == that.createCommentWithAllSingleFileComments && this.createSingleFileComments == that.createSingleFileComments && Objects.equals(this.violationConfigs, that.violationConfigs) && Objects.equals(this.gitLabUrl, that.gitLabUrl) && Objects.equals(this.apiToken, that.apiToken) && Objects.equals(this.projectId, that.projectId) && Objects.equals(this.mergeRequestIid, that.mergeRequestIid) && Objects.equals(this.mergeRequestId, that.mergeRequestId) && Objects.equals(this.apiTokenCredentialsId, that.apiTokenCredentialsId) && Objects.equals(this.ignoreCertificateErrors, that.ignoreCertificateErrors) && Objects.equals(this.apiTokenPrivate, that.apiTokenPrivate) && Objects.equals(this.authMethodHeader, that.authMethodHeader) && this.minSeverity == that.minSeverity && Objects.equals(this.keepOldComments, that.keepOldComments) && Objects.equals(this.commentTemplate, that.commentTemplate) && Objects.equals(this.shouldSetWip, that.shouldSetWip) && Objects.equals(this.proxyUri, that.proxyUri) && Objects.equals(this.proxyUser, that.proxyUser) && Objects.equals(this.proxyPassword, that.proxyPassword) && Objects.equals(this.enableLogging, that.enableLogging);
    }

    public int hashCode() {
        return Objects.hash(this.commentOnlyChangedContent, this.commentOnlyChangedFiles, this.createCommentWithAllSingleFileComments, this.createSingleFileComments, this.violationConfigs, this.gitLabUrl, this.apiToken, this.projectId, this.mergeRequestIid, this.mergeRequestId, this.apiTokenCredentialsId, this.ignoreCertificateErrors, this.apiTokenPrivate, this.authMethodHeader, this.minSeverity, this.keepOldComments, this.commentTemplate, this.shouldSetWip, this.proxyUri, this.proxyUser, this.proxyPassword, this.enableLogging);
    }

    public String toString() {
        return "ViolationsToGitLabConfig{commentOnlyChangedContent=" + this.commentOnlyChangedContent + "commentOnlyChangedFiles=" + this.commentOnlyChangedFiles + ", createCommentWithAllSingleFileComments=" + this.createCommentWithAllSingleFileComments + ", createSingleFileComments=" + this.createSingleFileComments + ", violationConfigs=" + this.violationConfigs + ", gitLabUrl='" + this.gitLabUrl + '\'' + ", projectId='" + this.projectId + '\'' + ", mergeRequestIid='" + this.mergeRequestIid + '\'' + ", mergeRequestId='" + this.mergeRequestId + '\'' + ", apiTokenCredentialsId='" + this.apiTokenCredentialsId + '\'' + ", ignoreCertificateErrors=" + this.ignoreCertificateErrors + ", apiTokenPrivate=" + this.apiTokenPrivate + ", authMethodHeader=" + this.authMethodHeader + ", minSeverity=" + this.minSeverity + ", keepOldComments=" + this.keepOldComments + ", commentTemplate='" + this.commentTemplate + '\'' + ", shouldSetWip=" + this.shouldSetWip + '}';
    }

    public Boolean getKeepOldComments() {
        return this.keepOldComments;
    }

    public Boolean getShouldSetWip() {
        return this.shouldSetWip;
    }

    @DataBoundSetter
    public void setShouldSetWip(Boolean shouldSetWip) {
        this.shouldSetWip = shouldSetWip;
    }

    @DataBoundSetter
    public void setKeepOldComments(Boolean keepOldComments) {
        this.keepOldComments = keepOldComments;
    }

    @DataBoundSetter
    public void setProxyUri(String proxyUri) {
        this.proxyUri = proxyUri;
    }

    @DataBoundSetter
    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    @DataBoundSetter
    public void setProxyUser(String proxyUser) {
        this.proxyUser = proxyUser;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public String getProxyUri() {
        return this.proxyUri;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    @DataBoundSetter
    public void setEnableLogging(Boolean enableLogging) {
        this.enableLogging = enableLogging;
    }

    public Boolean getEnableLogging() {
        return this.enableLogging;
    }

    public Integer getMaxNumberOfViolations() {
        return this.maxNumberOfViolations;
    }

    @DataBoundSetter
    public void setMaxNumberOfViolations(Integer maxNumberOfViolations) {
        this.maxNumberOfViolations = maxNumberOfViolations;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<ViolationsToGitLabConfig> {
        @NonNull
        public String getDisplayName() {
            return "Violations To GitHub Server Config";
        }

        @Restricted(value={NoExternalUse.class})
        public ListBoxModel doFillMinSeverityItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("Default, Global Config or Info", "");
            for (SEVERITY severity : SEVERITY.values()) {
                items.add(severity.name());
            }
            return items;
        }

        public ListBoxModel doFillApiTokenCredentialsIdItems(@AncestorInPath Item item, @QueryParameter String apiTokenCredentialsId, @QueryParameter String gitLabUrl) {
            return CredentialsHelper.doFillApiTokenCredentialsIdItems(item, apiTokenCredentialsId, gitLabUrl);
        }

        public FormValidation doCheckApiTokenCredentialsId(@AncestorInPath Item item, @QueryParameter String value, @QueryParameter String gitLabUrl) {
            return CredentialsHelper.doCheckApiTokenCredentialsId(item, value, gitLabUrl);
        }
    }
}

