/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.jvctgl.config;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.ListBoxModel;
import java.io.Serializable;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import se.bjurr.violations.lib.reports.Parser;

public class ViolationConfig
extends AbstractDescribableImpl<ViolationConfig>
implements Serializable {
    private static final long serialVersionUID = 9009372864417543781L;
    private String pattern;
    private Parser parser;
    private String reporter;

    public ViolationConfig() {
    }

    @DataBoundConstructor
    public ViolationConfig(Parser parser, String pattern, String reporter) {
        this.parser = parser;
        this.pattern = pattern;
        this.reporter = reporter;
    }

    public String getPattern() {
        return this.pattern;
    }

    public Parser getParser() {
        return this.parser;
    }

    public String getReporter() {
        if (this.reporter == null) {
            return this.parser.name();
        }
        return this.reporter;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setParser(Parser parser) {
        this.parser = parser;
    }

    public void setReporter(String reporter) {
        this.reporter = reporter;
    }

    public String toString() {
        return "ViolationConfig [pattern=" + this.pattern + ", parser=" + this.parser + ", reporter=" + this.reporter + "]";
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<ViolationConfig> {
        @NonNull
        public String getDisplayName() {
            return "Violations Parser Config";
        }

        @Restricted(value={NoExternalUse.class})
        public ListBoxModel doFillParserItems() {
            ListBoxModel items = new ListBoxModel();
            for (Parser parser : Parser.values()) {
                items.add(parser.name());
            }
            return items;
        }
    }
}

