/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.jvctgl;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.Serializable;
import jenkins.model.GlobalConfiguration;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.jvctgl.config.CredentialsHelper;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import se.bjurr.violations.lib.model.SEVERITY;

@Extension
public class ViolationsToGitLabGlobalConfiguration
extends GlobalConfiguration
implements Serializable {
    private static final long serialVersionUID = -7071307231169224261L;
    private String gitLabUrl;
    private boolean ignoreCertificateErrors;
    private String apiToken;
    private boolean apiTokenPrivate;
    private boolean authMethodHeader;
    private String apiTokenCredentialsId;
    private SEVERITY minSeverity = SEVERITY.INFO;

    public static ViolationsToGitLabGlobalConfiguration get() {
        return (ViolationsToGitLabGlobalConfiguration)GlobalConfiguration.all().get(ViolationsToGitLabGlobalConfiguration.class);
    }

    public ViolationsToGitLabGlobalConfiguration() {
        this.load();
    }

    public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
        req.bindJSON((Object)this, json);
        this.save();
        return true;
    }

    @Restricted(value={NoExternalUse.class})
    public ListBoxModel doFillMinSeverityItems() {
        ListBoxModel items = new ListBoxModel();
        for (SEVERITY severity : SEVERITY.values()) {
            items.add(severity.name());
        }
        return items;
    }

    public ListBoxModel doFillApiTokenCredentialsIdItems(@AncestorInPath Item item, @QueryParameter String apiTokenCredentialsId, @QueryParameter String gitLabUrl) {
        return CredentialsHelper.doFillApiTokenCredentialsIdItems(item, apiTokenCredentialsId, gitLabUrl);
    }

    public FormValidation doCheckApiTokenCredentialsId(@AncestorInPath Item item, @QueryParameter String value, @QueryParameter String gitLabUrl) {
        return CredentialsHelper.doCheckApiTokenCredentialsId(item, value, gitLabUrl);
    }

    public String getGitLabUrl() {
        return this.gitLabUrl;
    }

    public boolean isIgnoreCertificateErrors() {
        return this.ignoreCertificateErrors;
    }

    @DataBoundSetter
    public void setIgnoreCertificateErrors(boolean ignoreCertificateErrors) {
        this.ignoreCertificateErrors = ignoreCertificateErrors;
    }

    public String getApiToken() {
        return this.apiToken;
    }

    @DataBoundSetter
    public void setApiToken(String apiToken) {
        this.apiToken = apiToken;
    }

    public String getApiTokenCredentialsId() {
        return this.apiTokenCredentialsId;
    }

    @DataBoundSetter
    public void setMinSeverity(SEVERITY minSeverity) {
        this.minSeverity = minSeverity;
    }

    public SEVERITY getMinSeverity() {
        return this.minSeverity;
    }

    @DataBoundSetter
    public void setApiTokenCredentialsId(String apiTokenCredentialsId) {
        this.apiTokenCredentialsId = apiTokenCredentialsId;
    }

    public static long getSerialversionuid() {
        return -7071307231169224261L;
    }

    @DataBoundSetter
    public void setGitLabUrl(String gitLabUrl) {
        this.gitLabUrl = gitLabUrl;
    }

    public boolean isApiTokenPrivate() {
        return this.apiTokenPrivate;
    }

    @DataBoundSetter
    public void setApiTokenPrivate(boolean apiTokenPrivate) {
        this.apiTokenPrivate = apiTokenPrivate;
    }

    public boolean isAuthMethodHeader() {
        return this.authMethodHeader;
    }

    @DataBoundSetter
    public void setAuthMethodHeader(boolean authMethodHeader) {
        this.authMethodHeader = authMethodHeader;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.apiToken == null ? 0 : this.apiToken.hashCode());
        result = 31 * result + (this.apiTokenCredentialsId == null ? 0 : this.apiTokenCredentialsId.hashCode());
        result = 31 * result + (this.apiTokenPrivate ? 1231 : 1237);
        result = 31 * result + (this.authMethodHeader ? 1231 : 1237);
        result = 31 * result + (this.gitLabUrl == null ? 0 : this.gitLabUrl.hashCode());
        result = 31 * result + (this.ignoreCertificateErrors ? 1231 : 1237);
        result = 31 * result + (this.minSeverity == null ? 0 : this.minSeverity.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ViolationsToGitLabGlobalConfiguration other = (ViolationsToGitLabGlobalConfiguration)obj;
        if (this.apiToken == null ? other.apiToken != null : !this.apiToken.equals(other.apiToken)) {
            return false;
        }
        if (this.apiTokenCredentialsId == null ? other.apiTokenCredentialsId != null : !this.apiTokenCredentialsId.equals(other.apiTokenCredentialsId)) {
            return false;
        }
        if (this.apiTokenPrivate != other.apiTokenPrivate) {
            return false;
        }
        if (this.authMethodHeader != other.authMethodHeader) {
            return false;
        }
        if (this.gitLabUrl == null ? other.gitLabUrl != null : !this.gitLabUrl.equals(other.gitLabUrl)) {
            return false;
        }
        if (this.ignoreCertificateErrors != other.ignoreCertificateErrors) {
            return false;
        }
        return this.minSeverity == other.minSeverity;
    }

    public String toString() {
        return "ViolationsToGitLabGlobalConfiguration [gitLabUrl=" + this.gitLabUrl + ", ignoreCertificateErrors=" + this.ignoreCertificateErrors + ", apiToken=" + this.apiToken + ", apiTokenPrivate=" + this.apiTokenPrivate + ", authMethodHeader=" + this.authMethodHeader + ", apiTokenCredentialsId=" + this.apiTokenCredentialsId + ", minSeverity=" + this.minSeverity + "]";
    }
}

