/*
 * Decompiled with CFR 0.152.
 */
package com.view26.ci.plugin.parse;

import com.view26.ci.plugin.Constants;
import com.view26.ci.plugin.model.AutomationAttachment;
import com.view26.ci.plugin.model.AutomationTestLog;
import com.view26.ci.plugin.model.AutomationTestResult;
import hudson.Util;
import hudson.tasks.junit.CaseResult;
import hudson.tasks.junit.SuiteResult;
import hudson.tasks.junit.TestResult;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;

public class CommonParsingUtils {
    public static List<AutomationTestResult> toAutomationTestResults(boolean useTestMethodAsTestCase, List<TestResult> testResults, Date startTime, Date completedTime) throws Exception {
        if (useTestMethodAsTestCase) {
            return CommonParsingUtils.useTestMethodAsTestCase(testResults, startTime, completedTime);
        }
        return CommonParsingUtils.useClassNameAsTestCase(testResults, startTime, completedTime);
    }

    private static List<AutomationTestResult> useTestMethodAsTestCase(List<TestResult> testResults, Date startTime, Date completedTime) throws Exception {
        HashMap<String, AutomationTestResult> automationTestResultMap = new HashMap<String, AutomationTestResult>();
        for (TestResult testResult : testResults) {
            for (SuiteResult suite : testResult.getSuites()) {
                if (suite.getCases() == null) continue;
                for (CaseResult caseResult : suite.getCases()) {
                    String automationContent = caseResult.getClassName() + "#" + caseResult.getName();
                    if (automationTestResultMap.containsKey(automationContent)) continue;
                    AutomationTestResult automationTestResult = new AutomationTestResult();
                    automationTestResult.setName(automationContent);
                    automationTestResult.setAutomationContent(automationContent);
                    automationTestResult.setExecutedEndDate(completedTime);
                    automationTestResult.setExecutedStartDate(startTime);
                    automationTestResult.setDuration(Float.valueOf(caseResult.getDuration()));
                    automationTestResult.setAttachments(new ArrayList<AutomationAttachment>());
                    AutomationTestLog automationTestLog = new AutomationTestLog(caseResult);
                    automationTestResult.addTestLog(automationTestLog);
                    if (caseResult.isFailed()) {
                        AutomationAttachment attachment = new AutomationAttachment(caseResult);
                        automationTestResult.getAttachments().add(attachment);
                    }
                    automationTestResultMap.put(automationContent, automationTestResult);
                }
            }
        }
        return new ArrayList<AutomationTestResult>(automationTestResultMap.values());
    }

    private static List<AutomationTestResult> useClassNameAsTestCase(List<TestResult> testResults, Date startTime, Date completedTime) throws Exception {
        Map<String, AutomationTestResult> automationTestResultMap = new HashMap<String, AutomationTestResult>();
        for (TestResult testResult : testResults) {
            for (SuiteResult suite : testResult.getSuites()) {
                if (suite.getCases() == null) continue;
                Float duration = Float.valueOf(suite.getDuration());
                for (CaseResult caseResult : suite.getCases()) {
                    AutomationTestResult automationTestResult = null;
                    if (automationTestResultMap.containsKey(caseResult.getClassName())) {
                        automationTestResult = automationTestResultMap.get(caseResult.getClassName());
                    } else {
                        automationTestResult = new AutomationTestResult();
                        automationTestResult.setName(caseResult.getClassName());
                        automationTestResult.setAutomationContent(caseResult.getClassName());
                        automationTestResult.setExecutedEndDate(completedTime);
                        automationTestResult.setExecutedStartDate(startTime);
                        automationTestResult.setDuration(duration);
                        automationTestResult.setAttachments(new ArrayList<AutomationAttachment>());
                        automationTestResultMap.put(caseResult.getClassName(), automationTestResult);
                    }
                    AutomationTestLog automationTestLog = new AutomationTestLog(caseResult);
                    automationTestResult.addTestLog(automationTestLog);
                    if (!caseResult.isFailed()) continue;
                    AutomationAttachment attachment = new AutomationAttachment(caseResult);
                    automationTestResult.getAttachments().add(attachment);
                }
            }
        }
        automationTestResultMap = CommonParsingUtils.processAttachment(automationTestResultMap);
        return new ArrayList<AutomationTestResult>(automationTestResultMap.values());
    }

    private static Map<String, AutomationTestResult> processAttachment(Map<String, AutomationTestResult> automationTestResultMap) throws Exception {
        for (String key : automationTestResultMap.keySet()) {
            AutomationTestResult automationTestResult = automationTestResultMap.get(key);
            int totalAttachments = automationTestResult.getAttachments().size();
            if (totalAttachments > Constants.LIMIT_TXT_FILES) {
                File zipFile = File.createTempFile(automationTestResult.getName(), ".zip");
                ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(zipFile));
                HashMap<String, Integer> attachmentNames = new HashMap<String, Integer>();
                for (int i = 0; i < totalAttachments; ++i) {
                    AutomationAttachment attachment = automationTestResult.getAttachments().get(i);
                    String attachmentName = attachment.getName();
                    if (attachmentNames.containsKey(attachment.getName())) {
                        Integer count = (Integer)attachmentNames.get(attachment.getName());
                        attachmentName = attachmentName.replace(".txt", "_" + count + ".txt");
                        count = count + 1;
                        attachmentNames.put(attachment.getName(), count);
                    } else {
                        attachmentNames.put(attachment.getName(), 1);
                    }
                    zipOutputStream.putNextEntry(new ZipEntry(attachmentName));
                    zipOutputStream.write(attachment.getData().getBytes());
                    zipOutputStream.closeEntry();
                }
                zipOutputStream.close();
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(zipFile));
                int zipFileLength = (int)zipFile.length();
                byte[] zipFileBytes = new byte[zipFileLength];
                bufferedInputStream.read(zipFileBytes, 0, zipFileLength);
                bufferedInputStream.close();
                AutomationAttachment attachment = new AutomationAttachment();
                attachment.setData(Base64.encodeBase64String((byte[])zipFileBytes));
                attachment.setContentType("application/zip");
                attachment.setName(automationTestResult.getName() + ".zip");
                automationTestResult.setAttachments(Arrays.asList(attachment));
                zipFile.delete();
                continue;
            }
            for (int i = 0; i < totalAttachments; ++i) {
                AutomationAttachment attachment = automationTestResult.getAttachments().get(i);
                attachment.setContentType("text/plain");
                attachment.setData(Base64.encodeBase64String((byte[])attachment.getData().getBytes()));
            }
        }
        return automationTestResultMap;
    }

    public static List<String> scanJunitTestResultFolder(String basedDir) {
        File currentBasedDir = new File(basedDir);
        FileSet fs = Util.createFileSet((File)new File(basedDir), (String)"TEST-*");
        DirectoryScanner ds = fs.getDirectoryScanner();
        ArrayList<String> resultFolders = new ArrayList<String>();
        if (ds.getIncludedFiles().length > 0) {
            resultFolders.add("");
        }
        for (String notIncludedDirName : ds.getNotIncludedDirectories()) {
            File dirToScan;
            FileSet subFileSet;
            DirectoryScanner subDirScanner;
            if (StringUtils.isEmpty((String)notIncludedDirName) || (subDirScanner = (subFileSet = Util.createFileSet((File)(dirToScan = new File(currentBasedDir.getPath(), notIncludedDirName)), (String)"TEST-*")).getDirectoryScanner()).getIncludedFiles().length <= 0) continue;
            resultFolders.add(notIncludedDirName);
        }
        return resultFolders;
    }
}

