/*
 * Decompiled with CFR 0.152.
 */
package com.view26.ci.plugin.utils;

import com.view26.ci.plugin.utils.ClientRequestException;
import com.view26.ci.plugin.utils.ResponseEntity;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URL;
import java.net.URLEncoder;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang.StringUtils;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.NoConnectionReuseStrategy;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.kohsuke.stapler.StaplerRequest;

public class HttpClientUtils {
    public static Integer RETRY_MAX_COUNT = 3;
    public static Boolean RETRY_REQUEST_SEND_RETRY_ENABLED = false;
    private static final String AWS_METADATA_MAC_URL = "http://169.254.169.254/latest/meta-data/mac";
    private static HttpClient CLIENT;

    private HttpClientUtils() {
    }

    private static HttpClient getClient() throws ClientRequestException {
        HttpClientUtils.initClient();
        return CLIENT;
    }

    private static synchronized void initClient() throws ClientRequestException {
        if (null == CLIENT) {
            try {
                CLIENT = HttpClientUtils.getHttpClient();
            }
            catch (Exception e) {
                throw new ClientRequestException(e.getMessage());
            }
        }
    }

    public static String encode(String url) {
        try {
            return URLEncoder.encode(url, "UTF-8");
        }
        catch (Exception e) {
            return url;
        }
    }

    public static String getServerUrl(StaplerRequest request) {
        Boolean isDefaultPort = request.getServerPort() == 443 || request.getServerPort() == 80;
        return String.format("%s://%s%s%s%s", request.getScheme(), request.getServerName(), isDefaultPort != false ? "" : ":", request.getServerPort(), request.getContextPath());
    }

    public static int getPort(String url) {
        URL uri = null;
        try {
            uri = new URL(url);
        }
        catch (Exception exception) {
            // empty catch block
        }
        int port = 0;
        if (uri != null) {
            port = uri.getPort() > 0 ? uri.getPort() : ("http".equalsIgnoreCase(uri.getProtocol()) ? 80 : 443);
        }
        return port;
    }

    public static String getMacAddress() throws Exception {
        byte[] mac;
        NetworkInterface network = NetworkInterface.getByInetAddress(InetAddress.getLocalHost());
        if (null == network) {
            network = NetworkInterface.getByIndex(0);
        }
        try {
            mac = network.getHardwareAddress();
        }
        catch (Exception e) {
            mac = new byte[]{};
        }
        if (mac != null && mac.length <= 0) {
            return HttpClientUtils.get(AWS_METADATA_MAC_URL, null).getBody();
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < mac.length; ++i) {
            sb.append(String.format("%02X%s", mac[i], i < mac.length - 1 ? "-" : ""));
        }
        return sb.toString();
    }

    public static ResponseEntity get(String url, Map<String, String> headers) throws ClientRequestException {
        HttpGet request = new HttpGet(url);
        HttpClientUtils.addHeader((HttpRequestBase)request, headers);
        return HttpClientUtils.execute((HttpUriRequest)request);
    }

    public static ResponseEntity post(String url, Map<String, String> headers, String data) throws ClientRequestException {
        return HttpClientUtils.post(url, headers, data, ContentType.APPLICATION_JSON);
    }

    public static ResponseEntity post(String url, Map<String, String> headers, String data, ContentType contentType) throws ClientRequestException {
        HttpPost request = new HttpPost(url);
        HttpClientUtils.addHeader((HttpRequestBase)request, headers);
        if (!StringUtils.isEmpty((String)data)) {
            request.setEntity((HttpEntity)new StringEntity(data, contentType));
        }
        return HttpClientUtils.execute((HttpUriRequest)request);
    }

    public static ResponseEntity put(String url, Map<String, String> headers, String data) throws ClientRequestException {
        return HttpClientUtils.put(url, headers, data, ContentType.APPLICATION_JSON);
    }

    public static ResponseEntity put(String url, Map<String, String> headers, String data, ContentType contentType) throws ClientRequestException {
        HttpPut request = new HttpPut(url);
        HttpClientUtils.addHeader((HttpRequestBase)request, headers);
        if (!StringUtils.isEmpty((String)data)) {
            request.setEntity((HttpEntity)new StringEntity(data, contentType));
        }
        return HttpClientUtils.execute((HttpUriRequest)request);
    }

    public static ResponseEntity delete(String url, Map<String, String> headers) throws ClientRequestException {
        return HttpClientUtils.delete(url, headers, ContentType.APPLICATION_JSON);
    }

    public static ResponseEntity delete(String url, Map<String, String> headers, ContentType contentType) throws ClientRequestException {
        HttpDelete request = new HttpDelete(url);
        HttpClientUtils.addHeader((HttpRequestBase)request, headers);
        return HttpClientUtils.execute((HttpUriRequest)request);
    }

    private static ResponseEntity doExecute(HttpResponse response) throws Exception {
        if (null == response) {
            throw new Exception("response is null.");
        }
        HttpEntity entity = response.getEntity();
        BufferedReader rd = new BufferedReader(new InputStreamReader(entity.getContent()));
        StringBuilder result = new StringBuilder();
        String line = "";
        while ((line = rd.readLine()) != null) {
            result.append(line);
        }
        return new ResponseEntity(result.toString(), response.getStatusLine().getStatusCode());
    }

    public static ResponseEntity execute(HttpUriRequest request) throws ClientRequestException {
        ResponseEntity responseEntity;
        HttpClient client;
        try {
            client = HttpClientUtils.getClient();
        }
        catch (Exception e) {
            throw new ClientRequestException("Cannot get HttpClient." + e.getMessage(), e);
        }
        HttpResponse response = null;
        try {
            response = client.execute(request);
            responseEntity = HttpClientUtils.doExecute(response);
        }
        catch (Exception e) {
            throw new ClientRequestException(e.getMessage(), e);
        }
        finally {
            if (null != response) {
                org.apache.http.client.utils.HttpClientUtils.closeQuietly((HttpResponse)response);
            }
        }
        return responseEntity;
    }

    private static void addHeader(HttpRequestBase httpRequestBase, Map<String, String> headers) {
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                httpRequestBase.addHeader(entry.getKey(), entry.getValue());
            }
        }
    }

    public static HttpClient getHttpClient() throws Exception {
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        SSLConnectionSocketFactory sslSocketFactory = HttpClientUtils.getSslSocketFactory();
        httpClientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslSocketFactory).setConnectionReuseStrategy((ConnectionReuseStrategy)new NoConnectionReuseStrategy());
        httpClientBuilder.setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(RETRY_MAX_COUNT, RETRY_REQUEST_SEND_RETRY_ENABLED){

            public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
                if (executionCount > this.getRetryCount()) {
                    return false;
                }
                if (exception instanceof HttpHostConnectException) {
                    return true;
                }
                return super.retryRequest(exception, executionCount, context);
            }
        });
        return httpClientBuilder.build();
    }

    private static SSLConnectionSocketFactory getSslSocketFactory() throws KeyStoreException, NoSuchAlgorithmException, KeyManagementException {
        SSLContext sslContext = HttpClientUtils.getSslContext();
        return new SSLConnectionSocketFactory(sslContext, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
    }

    private static SSLContext getSslContext() throws KeyStoreException, NoSuchAlgorithmException, KeyManagementException {
        SSLContextBuilder sslContextBuilder = new SSLContextBuilder();
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        TrustAllStrategy trustStrategy = new TrustAllStrategy();
        sslContextBuilder.loadTrustMaterial(keyStore, (TrustStrategy)trustStrategy);
        return sslContextBuilder.build();
    }

    public static class TrustAllStrategy
    implements TrustStrategy {
        public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            return true;
        }
    }
}

