/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.valgrind.util;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Logger;

public class ValgrindSourceResolver {
    private static Logger logger = Logger.getLogger(ValgrindSourceResolver.class.getName());
    protected final List<AbstractMap.SimpleEntry<String, String>> substitutionPathList = new ArrayList<AbstractMap.SimpleEntry<String, String>>();

    public ValgrindSourceResolver() {
    }

    public ValgrindSourceResolver(String sourcePathSubstitutions) {
        this.parseSubstitutions(sourcePathSubstitutions);
    }

    public String resolveFilePath(String filePath) {
        if (filePath == null) {
            return null;
        }
        for (AbstractMap.SimpleEntry<String, String> substitute : this.substitutionPathList) {
            if (!filePath.startsWith(substitute.getKey())) continue;
            return filePath.replaceFirst(substitute.getKey(), substitute.getValue());
        }
        return filePath;
    }

    private void parseSubstitutions(String sourcePathSubstitutions) {
        String[] sourcePathSubstitutionArray;
        if (sourcePathSubstitutions != null && (sourcePathSubstitutionArray = sourcePathSubstitutions.split(",")) != null) {
            for (String sourcePathSubstitution : sourcePathSubstitutionArray) {
                if ((sourcePathSubstitution = sourcePathSubstitution.trim()).isEmpty()) continue;
                String[] sourcePathsPair = sourcePathSubstitution.split(":");
                if (sourcePathsPair.length != 2) {
                    logger.warning(String.format("Source path substitution '%s' is incorrect", sourcePathSubstitution));
                    continue;
                }
                AbstractMap.SimpleEntry<String, String> sourcePathSubstitutionKVP = new AbstractMap.SimpleEntry<String, String>(sourcePathsPair[0].trim(), sourcePathsPair[1].trim());
                logger.fine(String.format("Adding source path substitution '%s:%s'", sourcePathSubstitutionKVP.getKey(), sourcePathSubstitutionKVP.getValue()));
                this.substitutionPathList.add(sourcePathSubstitutionKVP);
            }
        }
        Comparator<AbstractMap.SimpleEntry<String, String>> longestFirstComparator = new Comparator<AbstractMap.SimpleEntry<String, String>>(){

            @Override
            public int compare(AbstractMap.SimpleEntry<String, String> o1, AbstractMap.SimpleEntry<String, String> o2) {
                return Integer.compare(o2.getKey().length(), o1.getKey().length());
            }
        };
        Collections.sort(this.substitutionPathList, longestFirstComparator);
    }
}

