/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.valgrind.util;

import hudson.FilePath;
import hudson.model.TaskListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.jenkinsci.plugins.valgrind.model.ValgrindStacktrace;
import org.jenkinsci.plugins.valgrind.model.ValgrindStacktraceFrame;
import org.jenkinsci.plugins.valgrind.util.ValgrindLogger;
import org.jenkinsci.plugins.valgrind.util.ValgrindSourceResolver;

public class ValgrindSourceGrabber {
    private TaskListener listener;
    private Map<String, String> lookup = new HashMap<String, String>();
    private File destDirectory;
    private FilePath basedir;
    private int index = 0;
    private final ValgrindSourceResolver sourceResolver;

    public ValgrindSourceGrabber(TaskListener listener, FilePath basedir) {
        this(listener, basedir, new ValgrindSourceResolver());
    }

    public ValgrindSourceGrabber(TaskListener listener, FilePath basedir, ValgrindSourceResolver sourceResolver) {
        this.listener = listener;
        this.basedir = basedir;
        this.sourceResolver = sourceResolver;
    }

    public boolean init(File localRoot) {
        this.destDirectory = new File(localRoot, "valgrind-plugin/source-files");
        if (!this.destDirectory.exists() && !this.destDirectory.mkdirs()) {
            ValgrindLogger.log(this.listener, "ERROR: failed to create local directory for source files: '" + this.destDirectory.getAbsolutePath() + "'");
            return false;
        }
        return true;
    }

    public void grabFromStacktrace(ValgrindStacktrace stacktrace) {
        if (stacktrace == null) {
            return;
        }
        for (ValgrindStacktraceFrame frame : stacktrace.getFrames()) {
            String resolvedFilePath;
            String filePath;
            if (frame == null || (filePath = frame.getFilePath()) == null || filePath.isEmpty() || this.lookup.containsKey(filePath) || (resolvedFilePath = this.sourceResolver.resolveFilePath(filePath)) == null || resolvedFilePath.isEmpty()) continue;
            FilePath file = new FilePath(this.basedir, resolvedFilePath);
            ++this.index;
            this.lookup.put(filePath, this.retrieveSourceFile(file));
        }
    }

    public Map<String, String> getLookupMap() {
        return this.lookup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String retrieveSourceFile(FilePath file) {
        try {
            if (!file.exists()) {
                ValgrindLogger.log(this.listener, "'" + file.getRemote() + "' does not exist, source code won't be available");
                return null;
            }
            if (file.isDirectory()) {
                ValgrindLogger.log(this.listener, "WARN: '" + file.getRemote() + "' is a directory, source code won't be available");
                return null;
            }
            String fileName = "source_" + this.index + ".tmp";
            File masterFile = new File(this.destDirectory, fileName);
            ValgrindLogger.log(this.listener, "copying source file '" + file.getRemote() + "' to '" + fileName + "'...");
            if (masterFile.exists()) {
                ValgrindLogger.log(this.listener, "WARN: local file '" + fileName + "' already exists");
                return null;
            }
            try (FileOutputStream outputStream = new FileOutputStream(masterFile);){
                file.copyTo((OutputStream)outputStream);
            }
            return fileName;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            ValgrindLogger.log(this.listener, "ERROR: failed to retrieve '" + file.getRemote() + "', " + e.getMessage());
            return null;
        }
    }
}

