/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.valgrind.util;

import java.util.ArrayList;
import java.util.List;
import org.jenkinsci.plugins.valgrind.model.ValgrindError;
import org.jenkinsci.plugins.valgrind.model.ValgrindErrorKind;

public class ValgrindErrorList {
    private List<ValgrindError> errors;

    public ValgrindErrorList(List<ValgrindError> errors) {
        this.errors = errors;
    }

    public int getOverlapErrorCount() {
        return this.getErrorCountByKind(ValgrindErrorKind.Overlap);
    }

    public List<ValgrindError> getOverlapErrors() {
        return this.getErrorsByKind(ValgrindErrorKind.Overlap);
    }

    public int getSyscallParamErrorCount() {
        return this.getErrorCountByKind(ValgrindErrorKind.SyscallParam);
    }

    public List<ValgrindError> getSyscallParamErrors() {
        return this.getErrorsByKind(ValgrindErrorKind.SyscallParam);
    }

    public int getInvalidFreeErrorCount() {
        return this.getErrorCountByKind(ValgrindErrorKind.InvalidFree);
    }

    public List<ValgrindError> getInvalidFreeErrors() {
        return this.getErrorsByKind(ValgrindErrorKind.InvalidFree);
    }

    public int getMismatchedFreeErrorCount() {
        return this.getErrorCountByKind(ValgrindErrorKind.MismatchedFree);
    }

    public List<ValgrindError> getMismatchedFreeErrors() {
        return this.getErrorsByKind(ValgrindErrorKind.MismatchedFree);
    }

    public int getUninitializedValueErrorCount() {
        return this.getErrorCountByKind(ValgrindErrorKind.UninitValue);
    }

    public List<ValgrindError> getUninitializedValueErrors() {
        return this.getErrorsByKind(ValgrindErrorKind.UninitValue);
    }

    public int getUninitializedConditionErrorCount() {
        return this.getErrorCountByKind(ValgrindErrorKind.UninitCondition);
    }

    public List<ValgrindError> getUninitializedConditionErrors() {
        return this.getErrorsByKind(ValgrindErrorKind.UninitCondition);
    }

    public int getInvalidReadErrorCount() {
        return this.getErrorCountByKind(ValgrindErrorKind.InvalidRead);
    }

    public List<ValgrindError> getInvalidReadErrors() {
        return this.getErrorsByKind(ValgrindErrorKind.InvalidRead);
    }

    public int getInvalidWriteErrorCount() {
        return this.getErrorCountByKind(ValgrindErrorKind.InvalidWrite);
    }

    public List<ValgrindError> getInvalidWriteErrors() {
        return this.getErrorsByKind(ValgrindErrorKind.InvalidWrite);
    }

    public int getLeakDefinitelyLostErrorCount() {
        return this.getErrorCountByKind(ValgrindErrorKind.Leak_DefinitelyLost);
    }

    public List<ValgrindError> getLeakDefinitelyLostErrors() {
        return this.getErrorsByKind(ValgrindErrorKind.Leak_DefinitelyLost);
    }

    public int getLeakPossiblyLostErrorCount() {
        return this.getErrorCountByKind(ValgrindErrorKind.Leak_PossiblyLost);
    }

    public List<ValgrindError> getLeakPossiblyLostErrors() {
        return this.getErrorsByKind(ValgrindErrorKind.Leak_PossiblyLost);
    }

    public int getLeakStillReachableErrorCount() {
        return this.getErrorCountByKind(ValgrindErrorKind.Leak_StillReachable);
    }

    public List<ValgrindError> getLeakStillReachableErrors() {
        return this.getErrorsByKind(ValgrindErrorKind.Leak_StillReachable);
    }

    public int getLeakIndirectlyLostErrorCount() {
        return this.getErrorCountByKind(ValgrindErrorKind.Leak_IndirectlyLost);
    }

    public List<ValgrindError> getLeakIndirectlyLostErrors() {
        return this.getErrorsByKind(ValgrindErrorKind.Leak_IndirectlyLost);
    }

    public int getRaceErrorCount() {
        return this.getErrorCountByKind(ValgrindErrorKind.Race);
    }

    public List<ValgrindError> getRaceErrors() {
        return this.getErrorsByKind(ValgrindErrorKind.Race);
    }

    public int getUnlockUnlockedErrorCount() {
        return this.getErrorCountByKind(ValgrindErrorKind.UnlockUnlocked);
    }

    public List<ValgrindError> getUnlockUnlockedErrors() {
        return this.getErrorsByKind(ValgrindErrorKind.UnlockUnlocked);
    }

    public int getUnlockForeignErrorCount() {
        return this.getErrorCountByKind(ValgrindErrorKind.UnlockForeign);
    }

    public List<ValgrindError> getUnlockForeignErrors() {
        return this.getErrorsByKind(ValgrindErrorKind.UnlockForeign);
    }

    public int getUnlockBogusErrorCount() {
        return this.getErrorCountByKind(ValgrindErrorKind.UnlockBogus);
    }

    public List<ValgrindError> getUnlockBogusErrors() {
        return this.getErrorsByKind(ValgrindErrorKind.UnlockBogus);
    }

    public int getPthAPIErrorCount() {
        return this.getErrorCountByKind(ValgrindErrorKind.PthAPIerror);
    }

    public List<ValgrindError> getPthAPIErrors() {
        return this.getErrorsByKind(ValgrindErrorKind.PthAPIerror);
    }

    public int getLockOrderErrorCount() {
        return this.getErrorCountByKind(ValgrindErrorKind.LockOrder);
    }

    public List<ValgrindError> getLockOrderErrors() {
        return this.getErrorsByKind(ValgrindErrorKind.LockOrder);
    }

    public int getMiscErrorCount() {
        return this.getErrorCountByKind(ValgrindErrorKind.Misc);
    }

    public List<ValgrindError> getMiscErrors() {
        return this.getErrorsByKind(ValgrindErrorKind.Misc);
    }

    public int getErrorCount() {
        if (this.errors == null) {
            return 0;
        }
        return this.errors.size();
    }

    public int getErrorCountByKind(ValgrindErrorKind valgrindErrorKind) {
        if (this.errors == null) {
            return 0;
        }
        int count = 0;
        for (ValgrindError error : this.errors) {
            if (error.getKind() == null || !error.getKind().equals((Object)valgrindErrorKind)) continue;
            ++count;
        }
        return count;
    }

    public List<ValgrindError> getErrorsByKind(ValgrindErrorKind valgrindErrorKind) {
        if (this.errors == null || this.errors.isEmpty()) {
            return null;
        }
        ArrayList<ValgrindError> result = new ArrayList<ValgrindError>();
        for (ValgrindError error : this.errors) {
            if (!error.getKind().equals((Object)valgrindErrorKind)) continue;
            result.add(error);
        }
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    public int getDefinitelyLeakedBytes() {
        if (this.errors == null) {
            return 0;
        }
        int bytes = 0;
        for (ValgrindError error : this.errors) {
            if (error.getKind() != ValgrindErrorKind.Leak_DefinitelyLost || error.getLeakedBytes() == null) continue;
            bytes += error.getLeakedBytes().intValue();
        }
        return bytes;
    }

    public int getPossiblyLeakedBytes() {
        if (this.errors == null) {
            return 0;
        }
        int bytes = 0;
        for (ValgrindError error : this.errors) {
            if (error.getKind() != ValgrindErrorKind.Leak_PossiblyLost || error.getLeakedBytes() == null) continue;
            bytes += error.getLeakedBytes().intValue();
        }
        return bytes;
    }

    public int getIndirectlyLeakedBytes() {
        if (this.errors == null) {
            return 0;
        }
        int bytes = 0;
        for (ValgrindError error : this.errors) {
            if (error.getKind() != ValgrindErrorKind.Leak_IndirectlyLost || error.getLeakedBytes() == null) continue;
            bytes += error.getLeakedBytes().intValue();
        }
        return bytes;
    }

    public int getStillReachableLeakedBytes() {
        if (this.errors == null) {
            return 0;
        }
        int bytes = 0;
        for (ValgrindError error : this.errors) {
            if (error.getKind() != ValgrindErrorKind.Leak_StillReachable || error.getLeakedBytes() == null) continue;
            bytes += error.getLeakedBytes().intValue();
        }
        return bytes;
    }

    public int getLeakedBytes(ValgrindErrorKind kind, String executable) {
        if (this.errors == null) {
            return 0;
        }
        int bytes = 0;
        for (ValgrindError error : this.errors) {
            if (error.getKind() != kind || !error.getExecutable().equals(executable) || error.getLeakedBytes() == null) continue;
            bytes += error.getLeakedBytes().intValue();
        }
        return bytes;
    }
}

