/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.valgrind.steps;

import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.valgrind.ValgrindBuilder;
import org.jenkinsci.plugins.valgrind.config.ValgrindBuilderConfig;
import org.jenkinsci.plugins.valgrind.steps.ValgrindBuilderStepExecution;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class ValgrindBuilderStep
extends AbstractStepImpl
implements Serializable {
    private static final long serialVersionUID = 2920077056924894969L;
    private ValgrindBuilderConfig valgrindBuilderConfig;

    @DataBoundConstructor
    public ValgrindBuilderStep(String valgrindExecutable, String workingDirectory, String includePattern, String excludePattern, String outputDirectory, String outputFileEnding, String programOptions, ValgrindBuilder.ValgrindTool tool, String valgrindOptions, boolean ignoreExitCode, boolean traceChildren, boolean childSilentAfterFork, boolean generateSuppressions, String suppressionFiles, boolean removeOldReports) {
        this.valgrindBuilderConfig = new ValgrindBuilderConfig(valgrindExecutable.trim(), workingDirectory.trim(), includePattern.trim(), excludePattern, outputDirectory.trim(), outputFileEnding.trim(), programOptions, tool, valgrindOptions, ignoreExitCode, traceChildren, childSilentAfterFork, generateSuppressions, suppressionFiles, removeOldReports);
    }

    public ValgrindBuilderConfig getValgrindBuilderConfig() {
        return this.valgrindBuilderConfig;
    }

    public void setValgrindBuilderConfig(ValgrindBuilderConfig valgrindBuilderConfig) {
        this.valgrindBuilderConfig = valgrindBuilderConfig;
    }

    public String getValgrindExecutable() {
        return this.valgrindBuilderConfig.valgrindExecutable;
    }

    public String getWorkingDirectory() {
        return this.valgrindBuilderConfig.workingDirectory;
    }

    public String getIncludePattern() {
        return this.valgrindBuilderConfig.includePattern;
    }

    public String getExcludePattern() {
        return this.valgrindBuilderConfig.excludePattern;
    }

    public String getOutputDirectory() {
        return this.valgrindBuilderConfig.outputDirectory;
    }

    public String getOutputFileEnding() {
        return this.valgrindBuilderConfig.outputFileEnding;
    }

    public String getProgramOptions() {
        return this.valgrindBuilderConfig.programOptions;
    }

    public ValgrindBuilder.ValgrindTool getTool() {
        return this.valgrindBuilderConfig.tool;
    }

    public String getValgrindOptions() {
        return this.valgrindBuilderConfig.valgrindOptions;
    }

    public boolean isIgnoreExitCode() {
        return this.valgrindBuilderConfig.ignoreExitCode;
    }

    public boolean isTraceChildren() {
        return this.valgrindBuilderConfig.traceChildren;
    }

    public boolean isChildSilentAfterFork() {
        return this.valgrindBuilderConfig.childSilentAfterFork;
    }

    public boolean isGenerateSuppressions() {
        return this.valgrindBuilderConfig.generateSuppressions;
    }

    public String getSuppressionFiles() {
        return this.valgrindBuilderConfig.suppressionFiles;
    }

    public boolean isRemoveOldReports() {
        return this.valgrindBuilderConfig.removeOldReports;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(ValgrindBuilderStepExecution.class);
        }

        public String getFunctionName() {
            return "runValgrind";
        }

        @Nonnull
        public String getDisplayName() {
            return "Run valgrind";
        }

        public static DescriptorExtensionList<ValgrindBuilder.ValgrindTool, ValgrindBuilder.ValgrindTool.ValgrindToolDescriptor> getToolDescriptors() {
            return Jenkins.getInstance().getDescriptorList(ValgrindBuilder.ValgrindTool.class);
        }

        public FormValidation doCheckIncludePattern(@QueryParameter String includePattern) throws IOException, ServletException {
            if (includePattern.length() == 0) {
                return FormValidation.error((String)"Please set a pattern");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckOutputFileEnding(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set a file ending for generated xml reports");
            }
            if (value.charAt(0) != '.') {
                return FormValidation.warning((String)"File ending does not start with a dot");
            }
            return FormValidation.ok();
        }
    }
}

