/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.valgrind.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jenkinsci.plugins.valgrind.model.ValgrindError;
import org.jenkinsci.plugins.valgrind.model.ValgrindThread;
import org.jenkinsci.plugins.valgrind.util.ValgrindErrorList;

public class ValgrindProcess
implements Serializable {
    private static final long serialVersionUID = -7073482135992069077L;
    private String tool;
    private String executable;
    private List<String> arguments;
    private List<String> valgrind_arguments;
    private String pid;
    private String ppid;
    private List<ValgrindError> errors;
    private List<ValgrindThread> threads;
    private transient ValgrindProcess parent = null;
    private transient List<ValgrindProcess> childs = null;

    public boolean isValid() {
        return this.executable != null;
    }

    public ValgrindProcess getParent() {
        return this.parent;
    }

    public List<ValgrindProcess> getChilds() {
        return this.childs;
    }

    public String getExecutable() {
        return this.executable;
    }

    public void setExecutable(String executable) {
        this.executable = executable;
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public List<String> getValgrindArguments() {
        return this.valgrind_arguments;
    }

    public void setArguments(List<String> arguments) {
        this.arguments = arguments;
    }

    public void addArgument(String arg) {
        if (this.arguments == null) {
            this.arguments = new ArrayList<String>();
        }
        this.arguments.add(arg);
    }

    public void addValgrindArgument(String arg) {
        if (this.valgrind_arguments == null) {
            this.valgrind_arguments = new ArrayList<String>();
        }
        this.valgrind_arguments.add(arg);
        if (arg.startsWith("--tool=")) {
            this.tool = arg.substring(7);
        }
    }

    public String getPid() {
        return this.pid;
    }

    public void setPid(String pid) {
        this.pid = pid;
    }

    public String getPpid() {
        return this.ppid;
    }

    public void setPpid(String ppid) {
        this.ppid = ppid;
    }

    public List<ValgrindError> getErrors() {
        return this.errors;
    }

    public void setErrors(List<ValgrindError> errors) {
        this.errors = errors;
    }

    public void addError(ValgrindError error) {
        if (this.errors == null) {
            this.errors = new ArrayList<ValgrindError>();
        }
        this.errors.add(error);
    }

    public ValgrindError findErrorByUniqueId(String id) {
        if (this.errors == null) {
            return null;
        }
        for (ValgrindError error : this.errors) {
            if (!error.getUniqueId().equals(id)) continue;
            return error;
        }
        return null;
    }

    public ValgrindErrorList getErrorList() {
        return new ValgrindErrorList(this.errors);
    }

    public List<ValgrindThread> getThreads() {
        return this.threads;
    }

    public void setThreads(List<ValgrindThread> threads) {
        this.threads = threads;
    }

    public void addThread(ValgrindThread thread) {
        if (this.threads == null) {
            this.threads = new ArrayList<ValgrindThread>();
        }
        this.threads.add(thread);
    }

    public ValgrindThread findThreadByHthreadid(String hthreadid) {
        if (this.threads == null) {
            return null;
        }
        for (ValgrindThread thread : this.threads) {
            if (!thread.getHthreadid().equals(hthreadid)) continue;
            return thread;
        }
        return null;
    }

    public void setupParentChilds(List<ValgrindProcess> processes) {
        if (this.parent != null || this.childs != null || processes == null) {
            return;
        }
        for (ValgrindProcess p : processes) {
            if (this.parent == null && this.ppid != null && this.ppid.equals(p.pid)) {
                this.parent = p;
            }
            if (this.pid == null || !this.pid.equals(p.ppid)) continue;
            if (this.childs == null) {
                this.childs = new ArrayList<ValgrindProcess>();
            }
            this.childs.add(p);
        }
    }

    String concatArguments(List<String> args) {
        if (args == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        for (String a : args) {
            buf.append(a + "<br>");
        }
        return buf.toString().trim();
    }

    public String getArgumentsString() {
        return this.concatArguments(this.arguments);
    }

    public String getValgrindArgumentsString() {
        return this.concatArguments(this.valgrind_arguments);
    }

    public String getTool() {
        if (this.tool == null) {
            return "unknown tool";
        }
        return this.tool;
    }
}

