/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.valgrind.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jenkinsci.plugins.valgrind.model.ValgrindAuxiliary;
import org.jenkinsci.plugins.valgrind.model.ValgrindErrorKind;
import org.jenkinsci.plugins.valgrind.model.ValgrindStacktrace;
import org.jenkinsci.plugins.valgrind.util.ValgrindSourceFile;
import org.jenkinsci.plugins.valgrind.util.ValgrindUtil;

public class ValgrindError
implements Serializable {
    private static final long serialVersionUID = 6470943829358084900L;
    @Deprecated
    private String executable;
    @Deprecated
    private String pid;
    @Deprecated
    private String ppid;
    private String uniqueId;
    private ValgrindErrorKind kind;
    private ValgrindStacktrace stacktrace;
    private String description;
    private Integer leakedBytes;
    private Integer leakedBlocks;
    private List<ValgrindAuxiliary> auxiliaryData;
    private String suppression;

    public String toString() {
        if (this.kind != null && this.description != null && this.stacktrace != null) {
            return "kind: " + (Object)((Object)this.kind) + "\ntext: " + this.description + "\nstack: " + this.stacktrace.toString();
        }
        return "";
    }

    public void setSourceCode(ValgrindSourceFile sourceFile) {
        if (this.stacktrace != null) {
            this.stacktrace.setSourceCode(sourceFile);
        }
        if (this.auxiliaryData != null) {
            for (ValgrindAuxiliary aux : this.auxiliaryData) {
                if (aux == null || aux.getStacktrace() == null) continue;
                aux.getStacktrace().setSourceCode(sourceFile);
            }
        }
    }

    public ValgrindStacktrace getStacktrace() {
        return this.stacktrace;
    }

    public void setStacktrace(ValgrindStacktrace stacktrace) {
        this.stacktrace = stacktrace;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = ValgrindUtil.trimToNull(description);
    }

    public ValgrindErrorKind getKind() {
        return this.kind;
    }

    public void setKind(ValgrindErrorKind kind) {
        this.kind = kind;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public void setUniqueId(String uniqueId) {
        this.uniqueId = ValgrindUtil.trimToNull(uniqueId);
    }

    @Deprecated
    public String getExecutable() {
        return this.executable;
    }

    public Integer getLeakedBytes() {
        return this.leakedBytes;
    }

    public void setLeakedBytes(Integer leakedBytes) {
        this.leakedBytes = leakedBytes;
    }

    public Integer getLeakedBlocks() {
        return this.leakedBlocks;
    }

    public void setLeakedBlocks(Integer leakedBlocks) {
        this.leakedBlocks = leakedBlocks;
    }

    public List<ValgrindAuxiliary> getAuxiliaryData() {
        return this.auxiliaryData;
    }

    public void setAuxiliaryData(List<ValgrindAuxiliary> auxiliaryData) {
        this.auxiliaryData = auxiliaryData;
    }

    public void addAuxiliaryData(ValgrindAuxiliary auxiliaryData) {
        if (this.auxiliaryData == null) {
            this.auxiliaryData = new ArrayList<ValgrindAuxiliary>();
        }
        this.auxiliaryData.add(auxiliaryData);
    }

    public String getSuppression() {
        return this.suppression;
    }

    public void setSuppression(String suppression) {
        this.suppression = suppression;
    }

    public String getSuppressionHtml() {
        if (this.suppression == null) {
            return "";
        }
        return this.suppression.replaceAll(" ", "&nbsp;").replaceAll("\t", "&nbsp;&nbsp;").replaceAll(">", "&gt;").replaceAll("<", "&lt;").replaceAll("\\n", "<br />");
    }
}

