/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.valgrind.call;

import org.jenkinsci.plugins.valgrind.call.ValgrindOption;
import org.jenkinsci.plugins.valgrind.call.ValgrindOptionNotApplicableException;
import org.jenkinsci.plugins.valgrind.call.ValgrindVersion;

public class ValgrindStringOption
implements ValgrindOption {
    private final String name;
    private final String value;
    private final ValgrindVersion minimumVersion;

    public ValgrindStringOption(String name, String value) {
        this.name = name;
        this.value = value;
        this.minimumVersion = ValgrindVersion.createInstance(0);
    }

    public ValgrindStringOption(String name, String value, ValgrindVersion minimumVersion) {
        this.name = name;
        this.value = value;
        this.minimumVersion = minimumVersion;
    }

    @Override
    public String getArgumentString(ValgrindVersion valgrindVersion) throws ValgrindOptionNotApplicableException {
        if (!valgrindVersion.isGreaterOrEqual(this.minimumVersion)) {
            throw new ValgrindOptionNotApplicableException("valgrind version " + this.minimumVersion.toString() + " required");
        }
        if (this.value == null) {
            throw new ValgrindOptionNotApplicableException("no value");
        }
        return "--" + this.name + "=" + this.value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }
}

