/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.valgrind.call;

import hudson.Launcher;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jenkinsci.plugins.valgrind.call.ValgrindVersion;

public class ValgrindExecutable {
    private final String executable;
    private final ValgrindVersion version;

    public ValgrindExecutable(Launcher launcher, String executable) throws IOException, InterruptedException {
        this.executable = executable == null || executable.trim().isEmpty() ? "valgrind" : executable.trim();
        this.version = ValgrindExecutable.detectValgrindVersion(launcher, this.executable);
    }

    public String getExecutable() {
        return this.executable;
    }

    public ValgrindVersion getVersion() {
        return this.version;
    }

    private static ValgrindVersion detectValgrindVersion(Launcher launcher, String executable) throws IOException, InterruptedException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        Launcher.ProcStarter starter = launcher.launch();
        starter = starter.stdout((OutputStream)os);
        starter = starter.stderr((OutputStream)os);
        int ret = (starter = starter.cmds(new String[]{executable, "--version"})).join();
        if (ret != 0) {
            throw new IllegalArgumentException("Failed to detect version of valgrind " + executable + " (return code " + ret + "): " + os.toString("UTF-8"));
        }
        ValgrindVersion version = ValgrindVersion.createInstanceFromString(os.toString("UTF-8"));
        if (version == null) {
            throw new IllegalArgumentException("Failed to detect version of valgrind " + executable + ", '" + os.toString("UTF-8") + "' is not a valid version string");
        }
        return version;
    }
}

