/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.valgrind.call;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.TaskListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jenkinsci.plugins.valgrind.call.ValgrindExecutable;
import org.jenkinsci.plugins.valgrind.call.ValgrindOption;
import org.jenkinsci.plugins.valgrind.call.ValgrindOptionNotApplicableException;
import org.jenkinsci.plugins.valgrind.util.ValgrindLogger;

public class ValgrindCall {
    private ValgrindExecutable valgrindExecutable;
    private EnvVars env;
    private String programName;
    private FilePath workingDirectory;
    private List<ValgrindOption> valgrindOptions = new ArrayList<ValgrindOption>();
    private List<String> customValgindOptions = new ArrayList<String>();
    private List<String> programArguments = new ArrayList<String>();

    public void setValgrindExecutable(ValgrindExecutable valgrindExecutable) {
        this.valgrindExecutable = valgrindExecutable;
    }

    public void setEnv(EnvVars env) {
        this.env = env;
    }

    public void setProgramName(String programName) {
        this.programName = programName;
        if (this.programName != null && this.programName.isEmpty()) {
            this.programName = null;
        }
    }

    public void setWorkingDirectory(FilePath workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public void addValgrindOption(ValgrindOption option) {
        if (option != null) {
            this.valgrindOptions.add(option);
        }
    }

    public void addCustomValgrindOptions(String ... options) {
        for (String option : options) {
            this.addCustomValgrindOption(option);
        }
    }

    public void addCustomValgrindOption(String option) {
        if (option == null) {
            return;
        }
        if ((option = option.trim()).isEmpty()) {
            return;
        }
        this.customValgindOptions.add(option);
    }

    public void addProgramArguments(String ... arguments) {
        for (String arg : arguments) {
            if (arg == null) continue;
            this.programArguments.add(arg);
        }
    }

    public int exec(TaskListener listener, Launcher launcher, ByteArrayOutputStream stdout, ByteArrayOutputStream stderr) throws IOException, InterruptedException {
        if (this.valgrindExecutable == null) {
            throw new IllegalStateException("valgrind executable is null");
        }
        if (this.programName == null) {
            throw new IllegalStateException("program name is null");
        }
        if (this.env == null) {
            throw new IllegalStateException("environment is null");
        }
        if (this.workingDirectory == null) {
            throw new IllegalStateException("working directory is null");
        }
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add(this.valgrindExecutable.getExecutable());
        for (ValgrindOption valgrindOption : this.valgrindOptions) {
            try {
                cmds.add(this.env.expand(valgrindOption.getArgumentString(this.valgrindExecutable.getVersion())));
            }
            catch (ValgrindOptionNotApplicableException e) {
                ValgrindLogger.log(listener, "option '" + valgrindOption.getName() + "' is not applicable: " + e.getMessage());
            }
        }
        for (String string : this.customValgindOptions) {
            cmds.add(this.env.expand(string));
        }
        cmds.add(this.programName);
        for (String string : this.programArguments) {
            cmds.add(this.env.expand(string));
        }
        ValgrindLogger.log(listener, "working dir: " + this.workingDirectory);
        Launcher.ProcStarter starter = launcher.launch();
        starter = starter.pwd(this.workingDirectory);
        starter = starter.stdout((OutputStream)stdout);
        starter = starter.stderr((OutputStream)stderr);
        starter = starter.cmds(cmds);
        starter = starter.envs((Map)this.env);
        return starter.join();
    }
}

