/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.valgrind.call;

import org.jenkinsci.plugins.valgrind.call.ValgrindOption;
import org.jenkinsci.plugins.valgrind.call.ValgrindOptionNotApplicableException;
import org.jenkinsci.plugins.valgrind.call.ValgrindVersion;

public class ValgrindBooleanOption
implements ValgrindOption {
    private final String name;
    private final boolean value;
    private final ValgrindVersion minimumVersion;

    public ValgrindBooleanOption(String name, boolean value) {
        this.name = name;
        this.value = value;
        this.minimumVersion = ValgrindVersion.createInstance(0);
    }

    public ValgrindBooleanOption(String name, boolean value, ValgrindVersion minimumVersion) {
        this.name = name;
        this.value = value;
        this.minimumVersion = minimumVersion;
    }

    @Override
    public String getArgumentString(ValgrindVersion valgrindVersion) throws ValgrindOptionNotApplicableException {
        if (!valgrindVersion.isGreaterOrEqual(this.minimumVersion)) {
            throw new ValgrindOptionNotApplicableException("valgrind version " + this.minimumVersion.toString() + " required");
        }
        return "--" + this.name + "=" + (this.value ? "yes" : "no");
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean getValue() {
        return this.value;
    }
}

