/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.urltrigger;

import antlr.ANTLRException;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import com.sun.jersey.client.apache.ApacheHttpClient;
import com.sun.jersey.client.apache.config.DefaultApacheHttpClientConfig;
import com.sun.jersey.client.urlconnection.HTTPSProperties;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.DescriptorExtensionList;
import hudson.EnvVars;
import hudson.Extension;
import hudson.ProxyConfiguration;
import hudson.Util;
import hudson.console.AnnotatedLargeText;
import hudson.model.Action;
import hudson.model.BuildableItem;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Node;
import hudson.slaves.EnvironmentVariablesNodeProperty;
import hudson.slaves.NodeProperty;
import hudson.util.DescribableList;
import hudson.util.FormValidation;
import hudson.util.Secret;
import hudson.util.SequentialExecutionQueue;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import jenkins.model.Jenkins;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.net.ftp.FTPClient;
import org.jenkinsci.Symbol;
import org.jenkinsci.lib.xtrigger.AbstractTrigger;
import org.jenkinsci.lib.xtrigger.XTriggerDescriptor;
import org.jenkinsci.lib.xtrigger.XTriggerException;
import org.jenkinsci.lib.xtrigger.XTriggerLog;
import org.jenkinsci.plugins.urltrigger.Messages;
import org.jenkinsci.plugins.urltrigger.URLTriggerAction;
import org.jenkinsci.plugins.urltrigger.URLTriggerEntry;
import org.jenkinsci.plugins.urltrigger.URLTriggerRequestHeader;
import org.jenkinsci.plugins.urltrigger.URLTriggerResolvedEntry;
import org.jenkinsci.plugins.urltrigger.content.URLTriggerContentType;
import org.jenkinsci.plugins.urltrigger.content.URLTriggerContentTypeDescriptor;
import org.jenkinsci.plugins.urltrigger.service.FTPResponse;
import org.jenkinsci.plugins.urltrigger.service.HTTPResponse;
import org.jenkinsci.plugins.urltrigger.service.URLTriggerService;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class URLTrigger
extends AbstractTrigger {
    private static final long serialVersionUID = 4770775641674010339L;
    private List<URLTriggerEntry> entries = new ArrayList<URLTriggerEntry>();
    private boolean labelRestriction;

    @DataBoundConstructor
    public URLTrigger(String cronTabSpec, String triggerLabel) throws ANTLRException {
        super(cronTabSpec, triggerLabel);
    }

    public URLTrigger(String cronTabSpec, List<URLTriggerEntry> entries, boolean labelRestriction, String triggerLabel) throws ANTLRException {
        super(cronTabSpec, triggerLabel);
        this.entries = entries;
        this.labelRestriction = labelRestriction;
    }

    public String getCronTabSpec() {
        return this.spec;
    }

    public List<URLTriggerEntry> getEntries() {
        return this.entries;
    }

    @DataBoundSetter
    public void setEntries(List<URLTriggerEntry> entries) {
        this.entries = entries;
    }

    public boolean isLabelRestriction() {
        return this.labelRestriction;
    }

    @DataBoundSetter
    public void setLabelRestriction(boolean labelRestriction) {
        this.labelRestriction = labelRestriction;
    }

    public Collection<? extends Action> getProjectActions() {
        HashMap<String, String> subActionTitles = null;
        for (URLTriggerEntry entry : this.entries) {
            String url = entry.getUrl();
            URLTriggerContentType[] urlTriggerContentTypes = entry.getContentTypes();
            if (entry.getContentTypes() == null) continue;
            subActionTitles = new HashMap<String, String>(urlTriggerContentTypes.length);
            for (URLTriggerContentType fsTriggerContentFileType : urlTriggerContentTypes) {
                Descriptor<URLTriggerContentType> descriptor;
                if (fsTriggerContentFileType == null || !((descriptor = fsTriggerContentFileType.getDescriptor()) instanceof URLTriggerContentTypeDescriptor)) continue;
                subActionTitles.put(url, ((URLTriggerContentTypeDescriptor)descriptor).getLabel());
            }
        }
        InternalURLTriggerAction action = new InternalURLTriggerAction(this.getDescriptor().getDisplayName(), subActionTitles);
        return Collections.singleton(action);
    }

    private String getURLValue(URLTriggerEntry entry, Node node, XTriggerLog log) throws XTriggerException {
        String entryURL = entry.getUrl();
        if (entryURL != null) {
            DescribableList globalNodeProperties;
            log.info("Resolving environment variables using global values");
            EnvVars envVars = new EnvVars();
            Jenkins hudson = Jenkins.getInstanceOrNull();
            if (hudson != null && (globalNodeProperties = hudson.getGlobalNodeProperties()) != null) {
                for (NodeProperty nodeProperty : globalNodeProperties) {
                    if (nodeProperty == null || !(nodeProperty instanceof EnvironmentVariablesNodeProperty)) continue;
                    envVars.putAll(((EnvironmentVariablesNodeProperty)nodeProperty).getEnvVars());
                }
            }
            return Util.replaceMacro((String)entryURL, (Map)envVars);
        }
        return null;
    }

    protected boolean checkIfModified(Node pollingNode, XTriggerLog log) throws XTriggerException {
        if (this.entries == null || this.entries.isEmpty()) {
            log.info("No URLs to poll.");
            return false;
        }
        for (URLTriggerEntry entry : this.entries) {
            boolean modified = this.checkIfModifiedEntry(entry, pollingNode, log);
            if (!modified) continue;
            return true;
        }
        return false;
    }

    private boolean checkIfModifiedEntry(URLTriggerEntry entry, Node pollingNode, XTriggerLog log) throws XTriggerException {
        String resolvedURL = this.getURLValue(entry, pollingNode, log);
        URLTriggerResolvedEntry resolvedEntry = new URLTriggerResolvedEntry(resolvedURL, entry);
        if (!resolvedEntry.isURLTriggerValidURL()) {
            throw new IllegalArgumentException("Only http(s) and ftp URLs are supported. For non-http/ftp protocols, consider other XTrigger plugins");
        }
        if (resolvedEntry.getResolvedURL().contains("$")) {
            log.info("URL contains unresolved environment variables.");
            log.info("Skipping URLTrigger initialization. Waiting next schedule");
            return false;
        }
        if (resolvedEntry.isHttp() || resolvedEntry.isHttps()) {
            return this.checkIfModifiedEntryForHttpOrHttpsURL(resolvedEntry, log);
        }
        return this.checkIfModifiedEntryFoFTPURL(resolvedEntry, log);
    }

    private boolean checkIfModifiedEntryForHttpOrHttpsURL(URLTriggerResolvedEntry resolvedEntry, XTriggerLog log) throws XTriggerException {
        Client client = this.getClientObject(resolvedEntry, log);
        String url = resolvedEntry.getResolvedURL();
        WebResource.Builder webResourceBuilder = client.resource(url).getRequestBuilder();
        List<URLTriggerRequestHeader> requestHeaders = resolvedEntry.getEntry().getRequestHeaders();
        if (requestHeaders.size() > 0) {
            for (URLTriggerRequestHeader requestHeader : requestHeaders) {
                log.info("Adding header - " + requestHeader.headerName + ":" + requestHeader.headerValue);
                webResourceBuilder = (WebResource.Builder)webResourceBuilder.header(requestHeader.headerName, (Object)requestHeader.headerValue);
            }
        }
        log.info(String.format("Invoking the url: %n %s", url));
        ClientResponse clientResponse = (ClientResponse)webResourceBuilder.get(ClientResponse.class);
        URLTriggerEntry entry = resolvedEntry.getEntry();
        if (this.isServiceUnavailableAndNotExpected(clientResponse, entry) || this.isURLNotFoundAndNotExpected(clientResponse, entry)) {
            log.info("URL to poll unavailable.");
            log.info("Skipping URLTrigger initialization. Waiting next schedule");
            return false;
        }
        HTTPResponse response = new HTTPResponse(clientResponse);
        URLTriggerService urlTriggerService = URLTriggerService.getInstance();
        return urlTriggerService.isSchedulingAndGetRefresh(response, entry, log);
    }

    private boolean checkIfModifiedEntryFoFTPURL(URLTriggerResolvedEntry resolvedEntry, XTriggerLog log) throws XTriggerException {
        FTPResponse response;
        try {
            response = this.getFTPResponse(resolvedEntry);
            if (response == null) {
                return false;
            }
            log.info("FTP poll result: " + response.getEntityTagValue());
        }
        catch (Exception ex) {
            log.info("Failed to poll URL: " + ex.toString());
            log.info("Skipping URLTrigger initialization. Waiting next schedule");
            return false;
        }
        URLTriggerService urlTriggerService = URLTriggerService.getInstance();
        return urlTriggerService.isSchedulingAndGetRefresh(response, resolvedEntry.getEntry(), log);
    }

    private boolean isServiceUnavailableAndNotExpected(ClientResponse clientResponse, URLTriggerEntry entry) {
        return 503 == clientResponse.getStatus() && entry.getStatusCode() != 503;
    }

    private boolean isURLNotFoundAndNotExpected(ClientResponse clientResponse, URLTriggerEntry entry) {
        return 404 == clientResponse.getStatus() && entry.getStatusCode() != 404;
    }

    public String getCause() {
        return "A change within the response URL invocation";
    }

    protected String getName() {
        return "URLTrigger";
    }

    private Client getClientObject(URLTriggerResolvedEntry resolvedEntry, XTriggerLog log) throws XTriggerException {
        URLTriggerEntry entry = resolvedEntry.getEntry();
        Client client = this.createClient(resolvedEntry.isHttps(), entry.isProxyActivated());
        if (this.isAuthBasic(entry)) {
            this.addBasicAuth(entry, log, client);
        }
        int timeout = entry.getTimeout();
        client.setConnectTimeout(Integer.valueOf(timeout * 1000));
        client.setReadTimeout(Integer.valueOf(timeout * 1000));
        return client;
    }

    private Client createClient(boolean isHttps, boolean withProxy) throws XTriggerException {
        Client client = withProxy ? this.createClientWithProxy(isHttps) : this.createClientWithoutProxy(isHttps);
        return client;
    }

    private void addBasicAuth(URLTriggerEntry entry, XTriggerLog log, Client client) {
        if (log != null) {
            log.info(String.format("Using Basic Authentication with the user '%s'", entry.getUsername()));
        }
        String password = entry.getRealPassword();
        client.addFilter((ClientFilter)new HTTPBasicAuthFilter(entry.getUsername(), password));
    }

    private Client createClientWithoutProxy(boolean isHttps) throws XTriggerException {
        DefaultClientConfig config = new DefaultClientConfig();
        if (isHttps) {
            config.getProperties().put("com.sun.jersey.client.impl.urlconnection.httpsProperties", new HTTPSProperties(this.getHostnameVerifier(), this.getSSLContext()));
        }
        return Client.create((ClientConfig)config);
    }

    private HostnameVerifier getHostnameVerifier() {
        return new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession sslSession) {
                return true;
            }
        };
    }

    private SSLContext getSSLContext() throws XTriggerException {
        SSLContext ctx;
        X509TrustManager x509 = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        try {
            ctx = SSLContext.getInstance("SSL");
            ctx.init(null, new TrustManager[]{x509}, null);
        }
        catch (GeneralSecurityException ex) {
            throw new XTriggerException((Throwable)ex);
        }
        return ctx;
    }

    private Client createClientWithProxy(boolean isHttps) throws XTriggerException {
        DefaultApacheHttpClientConfig config = new DefaultApacheHttpClientConfig();
        Jenkins h = Jenkins.get();
        ProxyConfiguration p = h.proxy;
        if (p != null) {
            config.getProperties().put("com.sun.jersey.impl.client.httpclient.proxyURI", "http://" + p.name + ":" + p.port);
            String password = this.getProxyPasswordDecrypted(p);
            config.getState().setProxyCredentials(AuthScope.ANY_REALM, p.name, p.port, p.getUserName(), Util.fixNull((String)password));
        }
        if (isHttps) {
            config.getProperties().put("com.sun.jersey.client.impl.urlconnection.httpsProperties", new HTTPSProperties(this.getHostnameVerifier(), this.getSSLContext()));
        }
        ApacheHttpClient client = ApacheHttpClient.create((ClientConfig)config);
        return client;
    }

    private String getProxyPasswordDecrypted(ProxyConfiguration p) {
        String passwordEncrypted = p.getPassword();
        String password = null;
        if (passwordEncrypted != null) {
            Secret secret = Secret.fromString((String)passwordEncrypted);
            password = Secret.toString((Secret)secret);
        }
        return password;
    }

    private boolean isAuthBasic(URLTriggerEntry entry) {
        return entry.getUsername() != null;
    }

    protected File getLogFile() {
        if (this.job != null) {
            return new File(((BuildableItem)this.job).getRootDir(), "trigger-script-polling.log");
        }
        return null;
    }

    protected Action[] getScheduledActions(Node node, XTriggerLog log) {
        return new Action[0];
    }

    protected boolean requiresWorkspaceForPolling() {
        return false;
    }

    public URLTriggerDescriptor getDescriptor() {
        return (URLTriggerDescriptor)Jenkins.get().getDescriptorOrDie(((Object)((Object)this)).getClass());
    }

    private static FTPClient getFTPClientObject(URLTriggerResolvedEntry resolvedEntry) throws URISyntaxException, IOException {
        URLTriggerEntry entry = resolvedEntry.getEntry();
        return URLTrigger.getFTPClientObject(resolvedEntry.getResolvedURL(), entry.getUsername(), entry.getRealPassword());
    }

    private static FTPClient getFTPClientObject(String url, String basicUsername, String basicPassword) throws URISyntaxException, IOException {
        URI uri = new URI(url);
        String host = uri.getHost();
        int port = uri.getPort();
        String userInfo = uri.getUserInfo();
        FTPClient ftpClient = new FTPClient();
        if (port < 0) {
            ftpClient.connect(host);
        } else {
            ftpClient.connect(host, port);
        }
        if (userInfo != null && !userInfo.isEmpty() || basicUsername != null) {
            String pass;
            String user;
            if (userInfo != null && !userInfo.isEmpty()) {
                int i = userInfo.indexOf(58);
                user = i < 0 ? userInfo : userInfo.substring(0, i);
                pass = i < 0 ? "" : userInfo.substring(i + 1, userInfo.length());
            } else {
                user = basicUsername;
                pass = basicPassword;
            }
            if (!ftpClient.login(user, pass)) {
                throw new IOException("Authentification failed");
            }
        }
        return ftpClient;
    }

    private FTPResponse getFTPResponse(URLTriggerResolvedEntry resolvedEntry) throws IOException, ParseException, URISyntaxException {
        FTPClient ftpClient = URLTrigger.getFTPClientObject(resolvedEntry);
        URI uri = new URI(resolvedEntry.getResolvedURL());
        FTPResponse response = new FTPResponse();
        String timeResponse = ftpClient.getModificationTime(uri.getPath());
        if (timeResponse == null) {
            return null;
        }
        String[] dateResponse = timeResponse.split(" ");
        if (dateResponse.length != 2) {
            throw new IOException("Illegal FTP response");
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddhhmmss");
        response.setLastModified(format.parse(dateResponse[1]));
        response.setStatus(Integer.parseInt(dateResponse[0]));
        response.setEntityTagValue(timeResponse);
        URLTriggerEntry entry = resolvedEntry.getEntry();
        if (entry.isInspectingContent()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ftpClient.retrieveFile(uri.getPath(), (OutputStream)baos);
            response.setContent(baos.toString("UTF-8"));
        }
        return response;
    }

    @Symbol(value={"URLTrigger"})
    @Extension
    public static class URLTriggerDescriptor
    extends XTriggerDescriptor {
        private final transient SequentialExecutionQueue queue = new SequentialExecutionQueue(Executors.newSingleThreadExecutor(new ThreadFactory(){
            private final ThreadFactory factory = Executors.defaultThreadFactory();

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = this.factory.newThread(r);
                thread.setName("URLTrigger queue thread");
                return thread;
            }
        }));

        public ExecutorService getExecutor() {
            return this.queue.getExecutors();
        }

        public boolean isApplicable(Item item) {
            return true;
        }

        public URLTrigger newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            URLTrigger urlTrigger;
            String cronTabSpec = formData.getString("cronTabSpec");
            boolean labelRestriction = false;
            String triggerLabel = null;
            Object labelRestrictionObject = formData.get("labelRestriction");
            if (labelRestrictionObject != null) {
                labelRestriction = true;
                triggerLabel = ((JSONObject)labelRestrictionObject).getString("triggerLabel");
            }
            Object entryObject = formData.get("urlElements");
            ArrayList<URLTriggerEntry> entries = new ArrayList<URLTriggerEntry>();
            if (entryObject instanceof JSONObject) {
                entries.add(this.fillAndGetEntry(req, (JSONObject)entryObject));
            } else {
                JSONArray jsonArray = (JSONArray)entryObject;
                if (jsonArray != null) {
                    for (Object aJsonArray : jsonArray) {
                        entries.add(this.fillAndGetEntry(req, (JSONObject)aJsonArray));
                    }
                }
            }
            try {
                urlTrigger = new URLTrigger(cronTabSpec, entries, labelRestriction, triggerLabel);
            }
            catch (ANTLRException e) {
                throw new RuntimeException(e.getMessage());
            }
            return urlTrigger;
        }

        private URLTriggerEntry fillAndGetEntry(StaplerRequest req, JSONObject entryObject) {
            Object checkStatusObject;
            URLTriggerEntry urlTriggerEntry = new URLTriggerEntry();
            urlTriggerEntry.setUrl(entryObject.getString("url"));
            urlTriggerEntry.setProxyActivated(entryObject.getBoolean("proxyActivated"));
            urlTriggerEntry.setUseGlobalEnvVars(entryObject.getBoolean("useGlobalEnvVars"));
            String username = Util.fixEmpty((String)entryObject.getString("username"));
            if (username != null) {
                urlTriggerEntry.setUsername(username);
                Secret secret = Secret.fromString((String)Util.fixEmpty((String)entryObject.getString("password")));
                String encryptedValue = secret.getEncryptedValue();
                urlTriggerEntry.setPassword(encryptedValue);
            }
            urlTriggerEntry.setTimeout(300);
            String timeout = entryObject.getString("timeout");
            if (timeout != null) {
                try {
                    int timeoutSeconds = Integer.parseInt(timeout);
                    urlTriggerEntry.setTimeout(timeoutSeconds);
                }
                catch (NumberFormatException timeoutSeconds) {
                    // empty catch block
                }
            }
            if ((checkStatusObject = entryObject.get("checkStatus")) != null) {
                urlTriggerEntry.setCheckStatus(true);
                try {
                    JSONObject statusJSONObject = (JSONObject)checkStatusObject;
                    urlTriggerEntry.setStatusCode(statusJSONObject.getInt("statusCode"));
                }
                catch (JSONException jsne) {
                    urlTriggerEntry.setStatusCode(URLTriggerEntry.DEFAULT_STATUS_CODE);
                }
            } else {
                urlTriggerEntry.setCheckStatus(false);
                urlTriggerEntry.setStatusCode(URLTriggerEntry.DEFAULT_STATUS_CODE);
            }
            urlTriggerEntry.setCheckETag(entryObject.getBoolean("checkETag"));
            urlTriggerEntry.setCheckLastModificationDate(entryObject.getBoolean("checkLastModificationDate"));
            ArrayList<URLTriggerRequestHeader> requestHeaders = new ArrayList<URLTriggerRequestHeader>();
            Object requestHeaderListObject = entryObject.get("urlRequestHeaders");
            if (requestHeaderListObject instanceof JSONObject) {
                JSONObject requestHeaderItem = (JSONObject)requestHeaderListObject;
                String headerName = Util.fixEmpty((String)requestHeaderItem.getString("headerName"));
                String headerValue = Util.fixEmpty((String)requestHeaderItem.getString("headerValue"));
                if (headerName != null && headerValue != null) {
                    requestHeaders.add(new URLTriggerRequestHeader(headerName, headerValue));
                }
            } else {
                JSONArray requestHeaderListArray = (JSONArray)requestHeaderListObject;
                if (requestHeaderListArray != null) {
                    for (Object requestHeaderItemObject : requestHeaderListArray) {
                        JSONObject requestHeaderItem = (JSONObject)requestHeaderItemObject;
                        String headerName = Util.fixEmpty((String)requestHeaderItem.getString("headerName"));
                        String headerValue = Util.fixEmpty((String)requestHeaderItem.getString("headerValue"));
                        if (headerName == null || headerValue == null) continue;
                        requestHeaders.add(new URLTriggerRequestHeader(headerName, headerValue));
                    }
                }
            }
            urlTriggerEntry.setRequestHeaders(requestHeaders);
            Object inspectingContentObject = entryObject.get("inspectingContent");
            if (inspectingContentObject == null) {
                urlTriggerEntry.setInspectingContent(false);
                urlTriggerEntry.setContentTypes(new URLTriggerContentType[0]);
            } else {
                urlTriggerEntry.setInspectingContent(true);
                JSONObject inspectingContentJSONObject = entryObject.getJSONObject("inspectingContent");
                if (inspectingContentJSONObject.size() == 0) {
                    urlTriggerEntry.setInspectingContent(false);
                } else {
                    JSONArray contentTypesJsonElt;
                    try {
                        contentTypesJsonElt = inspectingContentJSONObject.getJSONArray("contentTypes");
                    }
                    catch (JSONException jsone) {
                        contentTypesJsonElt = inspectingContentJSONObject.getJSONObject("contentTypes");
                    }
                    List types = req.bindJSONToList(URLTriggerContentType.class, (Object)contentTypesJsonElt);
                    urlTriggerEntry.setContentTypes(types.toArray(new URLTriggerContentType[types.size()]));
                }
            }
            return urlTriggerEntry;
        }

        public String getDisplayName() {
            return Messages.urltrigger_displayName();
        }

        public String getHelpFile() {
            return "/plugin/urltrigger/help.html";
        }

        public DescriptorExtensionList<URLTriggerContentType, Descriptor<URLTriggerContentType>> getListURLTriggerDescriptors() {
            return DescriptorExtensionList.createDescriptorList((Jenkins)Jenkins.get(), URLTriggerContentType.class);
        }

        public FormValidation doCheckURL(@QueryParameter String value) {
            if (value == null || value.trim().isEmpty()) {
                return FormValidation.error((String)"The url field is mandatory.");
            }
            if (!value.startsWith("http") && !value.startsWith("ftp")) {
                return FormValidation.error((String)"Only http(s) and ftp URLs are supported. For non-http/ftp protocols, consider other XTrigger plugins");
            }
            if (value.contains("$")) {
                return FormValidation.warning((String)"URL is parameterised and cannot be fully validated");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckTimeout(@QueryParameter String value) {
            if (value != null && value.trim().length() != 0) {
                try {
                    Integer.parseInt(value);
                }
                catch (NumberFormatException ne) {
                    return FormValidation.error((String)"You must provide a timeout number (in seconds).");
                }
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckStatus(@QueryParameter String value) {
            if (value == null || value.trim().isEmpty()) {
                return FormValidation.ok();
            }
            try {
                Integer.parseInt(value);
                return FormValidation.ok();
            }
            catch (Exception e) {
                return FormValidation.error((String)"You must provide a valid number status such as 200, 301, ...");
            }
        }
    }

    public final class InternalURLTriggerAction
    extends URLTriggerAction {
        private transient String label;
        private transient Map<String, String> subActionTitle;

        public InternalURLTriggerAction(String label, Map<String, String> subActionTitle) {
            this.label = label;
            this.subActionTitle = subActionTitle;
        }

        public BuildableItem getOwner() {
            return (BuildableItem)URLTrigger.this.job;
        }

        public String getLabel() {
            return this.label;
        }

        public String getIconFileName() {
            return "clipboard.gif";
        }

        public String getDisplayName() {
            return "URLTrigger Log";
        }

        public String getUrlName() {
            return "urltriggerPollLog";
        }

        public String getLog() throws IOException {
            return Util.loadFile((File)URLTrigger.this.getLogFile());
        }

        public Map<String, String> getSubActionTitle() {
            return this.subActionTitle;
        }

        @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED"})
        public void writeLogTo(XMLOutput out) throws IOException {
            new AnnotatedLargeText(URLTrigger.this.getLogFile(), Charset.defaultCharset(), true, (Object)this).writeHtmlTo(0L, out.asWriter());
        }
    }
}

