/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.twitter;

import hudson.Extension;
import hudson.Functions;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.plugins.twitter.messages.AsyncTweetDeliverer;
import hudson.plugins.twitter.messages.DefaultTweetBuilder;
import hudson.plugins.twitter.messages.TinyUrlLinkGenerator;
import hudson.plugins.twitter.messages.TweetBuilder;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Mailer;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TwitterPublisher
extends Notifier {
    private static final Logger LOGGER = Logger.getLogger(TwitterPublisher.class.getName());
    private Boolean onlyOnFailureOrRecovery;
    private Boolean includeUrl;

    @DataBoundConstructor
    public TwitterPublisher(String onlyOnFailureOrRecovery, String includeUrl) {
        this.onlyOnFailureOrRecovery = TwitterPublisher.cleanToBoolean(onlyOnFailureOrRecovery);
        this.includeUrl = TwitterPublisher.cleanToBoolean(includeUrl);
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        if (this.shouldTweet(build)) {
            try {
                DescriptorImpl descriptor = (DescriptorImpl)this.getDescriptor();
                TweetBuilder builder = this.getTweetBuilder();
                String newStatus = builder.generateTweet(build, this.shouldIncludeUrl());
                this.updateTwit(newStatus, descriptor.token, descriptor.tokenSecret);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Unable to send tweet.", e);
            }
        }
        return true;
    }

    private void updateTwit(String message, String token, String tokenSecret) throws Exception {
        AsyncTweetDeliverer deliverer = new AsyncTweetDeliverer(token, tokenSecret);
        deliverer.deliverTweet(message);
    }

    protected TweetBuilder getTweetBuilder() {
        return new DefaultTweetBuilder(new TinyUrlLinkGenerator());
    }

    protected boolean shouldTweet(AbstractBuild<?, ?> build) {
        if (this.onlyOnFailureOrRecovery == null) {
            if (((DescriptorImpl)this.getDescriptor()).onlyOnFailureOrRecovery) {
                return this.isFailureOrRecovery(build);
            }
            return true;
        }
        if (this.onlyOnFailureOrRecovery.booleanValue()) {
            return this.isFailureOrRecovery(build);
        }
        return true;
    }

    private static Boolean cleanToBoolean(String string) {
        Boolean result = null;
        if ("true".equals(string) || "Yes".equals(string)) {
            result = Boolean.TRUE;
        } else if ("false".equals(string) || "No".equals(string)) {
            result = Boolean.FALSE;
        }
        return result;
    }

    public Boolean getIncludeUrl() {
        return this.includeUrl;
    }

    public Boolean getOnlyOnFailureOrRecovery() {
        return this.onlyOnFailureOrRecovery;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    protected boolean isFailureOrRecovery(AbstractBuild<?, ?> build) {
        if (build.getResult() == Result.FAILURE || build.getResult() == Result.UNSTABLE) {
            return true;
        }
        if (build.getResult() == Result.SUCCESS) {
            AbstractBuild previousBuild = (AbstractBuild)build.getPreviousBuild();
            return previousBuild != null && previousBuild.getResult() != Result.SUCCESS;
        }
        return false;
    }

    protected boolean shouldIncludeUrl() {
        if (this.includeUrl != null) {
            return this.includeUrl;
        }
        return ((DescriptorImpl)this.getDescriptor()).includeUrl;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        private static final Logger LOGGER = Logger.getLogger(DescriptorImpl.class.getName());
        public String token;
        public String tokenSecret;
        public String hudsonUrl;
        public boolean onlyOnFailureOrRecovery;
        public boolean includeUrl;
        @Deprecated
        public transient String id;
        @Deprecated
        public transient String password;

        public DescriptorImpl() {
            super(TwitterPublisher.class);
            this.load();
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.includeUrl = false;
            this.onlyOnFailureOrRecovery = false;
            req.bindParameters((Object)this, "twitter.");
            this.hudsonUrl = Mailer.descriptor().getUrl();
            this.save();
            return super.configure(req, formData);
        }

        public String getDisplayName() {
            return "Twitter";
        }

        public String getToken() {
            return this.token;
        }

        public String getTokenSecret() {
            return this.tokenSecret;
        }

        public String getUrl() {
            return this.hudsonUrl;
        }

        public boolean isIncludeUrl() {
            return this.includeUrl;
        }

        public boolean isOnlyOnFailureOrRecovery() {
            return this.onlyOnFailureOrRecovery;
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public Publisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            if (this.hudsonUrl == null) {
                this.hudsonUrl = Functions.inferHudsonURL((StaplerRequest)req);
                this.save();
            }
            return (Publisher)super.newInstance(req, formData);
        }
    }
}

