/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.tokenmacro.impl;

import hudson.Extension;
import hudson.FilePath;
import hudson.console.ConsoleNote;
import hudson.model.AbstractBuild;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;
import org.jenkinsci.plugins.tokenmacro.DataBoundTokenMacro;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;

@Extension
public class BuildLogRegexMacro
extends DataBoundTokenMacro {
    public static final String MACRO_NAME = "BUILD_LOG_REGEX";
    public static final int LINES_BEFORE_DEFAULT_VALUE = 0;
    public static final int LINES_AFTER_DEFAULT_VALUE = 0;
    public static final int MAX_MATCHES_DEFAULT_VALUE = 0;
    public static final int MAX_TAIL_MATCHES_DEFAULT_VALUE = 0;
    public static final int MAX_LINE_LENGTH_DEFAULT_VALUE = 0;
    @DataBoundTokenMacro.Parameter
    public String regex = "(?i)\\b(error|exception|fatal|fail(ed|ure)|un(defined|resolved))\\b";
    @DataBoundTokenMacro.Parameter
    public int linesBefore = 0;
    @DataBoundTokenMacro.Parameter
    public int linesAfter = 0;
    @DataBoundTokenMacro.Parameter
    public int maxMatches = 0;
    @DataBoundTokenMacro.Parameter
    public boolean showTruncatedLines = true;
    @DataBoundTokenMacro.Parameter
    public String substText = null;
    @DataBoundTokenMacro.Parameter
    public String matchedLineHtmlStyle = null;
    @DataBoundTokenMacro.Parameter
    public boolean addNewline = true;
    @DataBoundTokenMacro.Parameter
    public String defaultValue = "";
    @DataBoundTokenMacro.Parameter
    public boolean greedy = true;
    @DataBoundTokenMacro.Parameter
    public int maxTailMatches = 0;
    @DataBoundTokenMacro.Parameter
    public int maxLineLength = 0;

    @Override
    public boolean acceptsMacroName(String macroName) {
        return macroName.equals(MACRO_NAME);
    }

    @Override
    public List<String> getAcceptedMacroNames() {
        return Collections.singletonList(MACRO_NAME);
    }

    private Integer startPre(List<String> matchResults, int preStartLoc) {
        if (preStartLoc == -1) {
            matchResults.add("<pre>\n");
            preStartLoc = matchResults.size() - 1;
        }
        return preStartLoc;
    }

    private Integer stopPre(List<String> matchResults, Integer preStartLoc, Stack<Pair<Integer, Integer>> preRanges) {
        if (preStartLoc != -1) {
            matchResults.add("</pre>\n");
            preRanges.push(new Pair<Integer, Integer>(preStartLoc, matchResults.size() - 1));
            preStartLoc = -1;
        }
        return preStartLoc;
    }

    private void appendContextLine(List<String> matchResults, String line, boolean escapeHtml) {
        if (this.maxLineLength != 0 && ((String)line).length() > this.maxLineLength) {
            line = ((String)line).substring(0, this.maxLineLength) + "...";
        }
        if (escapeHtml) {
            line = StringEscapeUtils.escapeHtml((String)line);
        }
        matchResults.add((String)line + "\n");
    }

    private void appendMatchedLine(List<String> matchResults, String line, boolean escapeHtml, String style, boolean addNewline) {
        if (this.maxLineLength != 0 && ((String)line).length() > this.maxLineLength) {
            line = ((String)line).substring(0, this.maxLineLength) + "...";
        }
        if (escapeHtml) {
            line = StringEscapeUtils.escapeHtml((String)line);
        }
        StringBuffer buffer = new StringBuffer();
        if (style != null) {
            buffer.append("<b");
            if (style.length() > 0) {
                buffer.append(" style=\"");
                buffer.append(style);
                buffer.append("\"");
            }
            buffer.append(">");
        }
        buffer.append((String)line);
        if (style != null) {
            buffer.append("</b>");
        }
        if (addNewline) {
            buffer.append('\n');
        }
        matchResults.add(buffer.toString());
    }

    private void appendLinesTruncated(List<String> matchResults, int numLinesTruncated, boolean asHtml) {
        StringBuffer buffer = new StringBuffer();
        if (asHtml) {
            buffer.append("<p>");
        }
        buffer.append("[...truncated ");
        buffer.append(numLinesTruncated);
        buffer.append(" lines...]");
        if (asHtml) {
            buffer.append("</p>");
        }
        buffer.append('\n');
        matchResults.add(buffer.toString());
    }

    @Override
    public String evaluate(AbstractBuild<?, ?> build, TaskListener listener, String macroName) throws MacroEvaluationException, IOException, InterruptedException {
        return this.evaluate((Run<?, ?>)build, null, listener, macroName);
    }

    @Override
    public String evaluate(Run<?, ?> run, FilePath workspace, TaskListener listener, String macroName) throws MacroEvaluationException, IOException, InterruptedException {
        try {
            BufferedReader reader = new BufferedReader(run.getLogReader());
            String transformedContent = this.getContent(reader);
            reader.close();
            return transformedContent;
        }
        catch (IOException ex) {
            listener.error(ex.getMessage());
            return "";
        }
    }

    String getContent(BufferedReader reader) throws IOException {
        String line;
        boolean asHtml = this.matchedLineHtmlStyle != null;
        this.escapeHtml = asHtml || this.escapeHtml;
        Pattern pattern = Pattern.compile(this.regex);
        List<String> matchResults = new ArrayList<String>();
        Stack<Pair<Integer, Integer>> preRanges = new Stack<Pair<Integer, Integer>>();
        int numLinesTruncated = 0;
        int numMatches = 0;
        int numLinesStillNeeded = 0;
        Integer preStartLoc = -1;
        LinkedList<String> linesBeforeList = new LinkedList<String>();
        while ((line = reader.readLine()) != null) {
            line = ConsoleNote.removeNotes((String)line);
            while (linesBeforeList.size() > this.linesBefore) {
                linesBeforeList.remove();
                ++numLinesTruncated;
            }
            Matcher matcher = pattern.matcher(line);
            StringBuffer sb = new StringBuffer();
            boolean matched = false;
            while (matcher.find()) {
                matched = true;
                if (this.substText == null) break;
                matcher.appendReplacement(sb, this.substText);
            }
            if (matched && (this.greedy || this.maxMatches == 0 || numMatches < this.maxMatches)) {
                if (this.showTruncatedLines && numLinesTruncated > 0) {
                    preStartLoc = this.stopPre(matchResults, preStartLoc, preRanges);
                    this.appendLinesTruncated(matchResults, numLinesTruncated, asHtml);
                    numLinesTruncated = 0;
                }
                if (asHtml) {
                    preStartLoc = this.startPre(matchResults, preStartLoc);
                }
                while (!linesBeforeList.isEmpty()) {
                    this.appendContextLine(matchResults, (String)linesBeforeList.remove(), this.escapeHtml);
                }
                if (this.substText != null) {
                    matcher.appendTail(sb);
                    line = sb.toString();
                }
                this.appendMatchedLine(matchResults, line, this.escapeHtml, this.matchedLineHtmlStyle, this.addNewline);
                ++numMatches;
                numLinesStillNeeded = this.linesAfter;
            } else if (numLinesStillNeeded > 0) {
                this.appendContextLine(matchResults, line, this.escapeHtml);
                --numLinesStillNeeded;
            } else {
                linesBeforeList.offer(line);
            }
            if (this.maxMatches == 0 || numMatches < this.maxMatches || numLinesStillNeeded != 0) continue;
            break;
        }
        if (this.showTruncatedLines) {
            while (linesBeforeList.size() > 0) {
                linesBeforeList.remove();
                ++numLinesTruncated;
            }
            if (line != null) {
                while ((line = reader.readLine()) != null) {
                    ++numLinesTruncated;
                }
            }
            if (numLinesTruncated > 0) {
                preStartLoc = this.stopPre(matchResults, preStartLoc, preRanges);
                this.appendLinesTruncated(matchResults, numLinesTruncated, asHtml);
            }
        }
        preStartLoc = this.stopPre(matchResults, preStartLoc, preRanges);
        if (matchResults.size() == 0) {
            return this.defaultValue;
        }
        if (this.maxTailMatches > 0 && matchResults.size() > this.maxTailMatches) {
            int tailStartLocation;
            if (asHtml) {
                tailStartLocation = matchResults.size() - 1;
                int resultsNeeded = this.maxTailMatches;
                while (!preRanges.empty()) {
                    Pair<Integer, Integer> range = preRanges.pop();
                    int preStart = (Integer)range.getKey();
                    int preEnd = (Integer)range.getValue();
                    int resultsInPreBlock = preEnd - preStart - 1;
                    if (resultsNeeded > resultsInPreBlock) {
                        resultsNeeded -= resultsInPreBlock;
                        tailStartLocation = preStart;
                        continue;
                    }
                    tailStartLocation = preEnd - resultsNeeded;
                    if (preStart != tailStartLocation) {
                        matchResults.add(tailStartLocation, "<pre>\n");
                    }
                    resultsNeeded = 0;
                    break;
                }
                if (resultsNeeded != 0) {
                    tailStartLocation = 0;
                }
            } else if (this.showTruncatedLines) {
                int resultsNeeded = this.maxTailMatches;
                tailStartLocation = matchResults.size();
                while (resultsNeeded > 0 && tailStartLocation > 0) {
                    if (((String)matchResults.get(--tailStartLocation)).contains("...truncated ")) continue;
                    --resultsNeeded;
                }
                if (resultsNeeded != 0) {
                    tailStartLocation = 0;
                }
            } else {
                tailStartLocation = matchResults.size() - this.maxTailMatches;
            }
            matchResults = matchResults.subList(tailStartLocation, matchResults.size());
        }
        return String.join((CharSequence)"", matchResults);
    }

    @Override
    public boolean handlesHtmlEscapeInternally() {
        return true;
    }

    private static class Pair<K, V>
    extends AbstractMap.SimpleEntry<K, V> {
        Pair(K key, V val) {
            super(key, val);
        }
    }
}

