/*
 * Decompiled with CFR 0.152.
 */
package me.automationdomination.plugins.threadfix;

import com.denimgroup.threadfix.data.entities.Application;
import com.denimgroup.threadfix.data.entities.Organization;
import com.denimgroup.threadfix.remote.response.RestResponse;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import jenkins.security.MasterToSlaveCallable;
import jenkins.tasks.SimpleBuildStep;
import me.automationdomination.plugins.threadfix.ScanFile;
import me.automationdomination.plugins.threadfix.service.ThreadFixService;
import net.sf.json.JSONObject;
import org.apache.commons.validator.routines.IntegerValidator;
import org.apache.commons.validator.routines.UrlValidator;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class ThreadFixPublisher
extends Recorder
implements SimpleBuildStep,
Serializable {
    private static final long serialVersionUID = 3393285563021058327L;
    private final String LOG_FORMAT = "[ThreadFix Publisher] %s";
    private final String appId;
    private final List<ScanFile> scanFiles;

    @DataBoundConstructor
    public ThreadFixPublisher(String appId, List<ScanFile> scanFiles) {
        this.appId = appId;
        this.scanFiles = scanFiles;
    }

    public void perform(@Nonnull Run<?, ?> build, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        PrintStream out = launcher.getListener().getLogger();
        this.log("Starting ThreadFix publisher execution", out);
        this.log("Retrieving global configurations", out);
        DescriptorImpl descriptor = this.getDescriptor();
        descriptor.validateToken();
        descriptor.validateUrl();
        String threadFixServerUrl = descriptor.getUrl();
        this.log("Using ThreadFix server URL: " + threadFixServerUrl, out);
        String token = descriptor.getToken();
        this.log("Parameter application ID: " + this.appId, out);
        this.validateApplicationId(this.appId);
        this.log(String.format("Uploading %d scan files", this.scanFiles.size()), out);
        int failCount = 0;
        for (ScanFile scanFile : this.scanFiles) {
            if (this.uploadScanFile(build, workspace, launcher, listener, scanFile.getPath(), threadFixServerUrl, token)) continue;
            ++failCount;
        }
        if (failCount == 0) {
            build.setResult(Result.SUCCESS);
        } else {
            build.setResult(Result.FAILURE);
        }
    }

    private void log(String message, PrintStream out) {
        out.println(String.format("[ThreadFix Publisher] %s", message));
    }

    private void validateApplicationId(String applicationId) throws AbortException {
        Integer value = IntegerValidator.getInstance().validate(applicationId);
        if (value == null) {
            throw new AbortException(String.format("application id \"%s\" is invalid", this.appId));
        }
    }

    private void validateFilePathExists(FilePath filePath) throws IOException, InterruptedException {
        if (!filePath.exists()) {
            throw new AbortException(String.format("scan file \"%s\" is invalid or file is unreadable", filePath));
        }
    }

    public boolean uploadScanFile(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener, String scanFile, String threadFixServerUrl, String token) throws IOException, InterruptedException {
        PrintStream out = launcher.getListener().getLogger();
        this.log("Parameter scan file: " + scanFile, out);
        EnvVars envVars = build.getEnvironment(listener);
        String expandedScanFilePath = envVars.expand(scanFile);
        FilePath filePath = new FilePath(workspace, expandedScanFilePath);
        this.validateFilePathExists(filePath);
        this.log(String.format("Uploading scan file: %s", filePath), out);
        boolean success = (Boolean)launcher.getChannel().call((Callable)new ThreadFixFileUploadCallable(this.appId, threadFixServerUrl, token, filePath));
        if (success) {
            this.log("Scan file uploaded successfully!", out);
        } else {
            this.log("Scan file upload failed", out);
        }
        return success;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public String getAppId() {
        return this.appId;
    }

    public List<ScanFile> getScanFiles() {
        return this.scanFiles;
    }

    private final class ThreadFixFileUploadCallable
    extends MasterToSlaveCallable<Boolean, IOException> {
        private final String appId;
        private final String threadFixServerUrl;
        private final String token;
        private final FilePath filePath;

        private ThreadFixFileUploadCallable(String appId, String threadFixServerUrl, String token, FilePath filePath) {
            this.appId = appId;
            this.threadFixServerUrl = threadFixServerUrl;
            this.token = token;
            this.filePath = filePath;
        }

        public Boolean call() throws IOException {
            ThreadFixService threadFixService = new ThreadFixService(this.threadFixServerUrl, this.token);
            return threadFixService.uploadFile(this.appId, this.filePath);
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        private static final String DISPLAY_NAME = "Publish ThreadFix Scan";
        private static final String URL_PARAMETER = "url";
        private static final String TOKEN_PARAMETER = "token";
        private static final String THREAD_FIX_SERVER_URL_ERROR_FORMAT = "ThreadFix server URL \"%s\" is invalid";
        private static final String THREAD_FIX_TOKEN_ERROR_FORMAT = "ThreadFix server API token \"%s\" is invalid";
        private static final String API_TOKEN_PATTERN = "^[A-Za-z0-9]{40,}$";
        private final UrlValidator urlValidator = new UrlValidator(new String[]{"http", "https"}, 8L);
        private final Pattern apiTokenPattern = Pattern.compile("^[A-Za-z0-9]{40,}$");
        private String url;
        private String token;

        public DescriptorImpl() {
            this.load();
        }

        public FormValidation doCheckUrl(@QueryParameter String url) throws IOException, ServletException {
            if (!this.isUrlValid(url)) {
                return FormValidation.error((String)String.format(THREAD_FIX_SERVER_URL_ERROR_FORMAT, url));
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckToken(@QueryParameter String token) throws IOException, ServletException {
            if (!this.isApiTokenValid(token)) {
                return FormValidation.error((String)String.format(THREAD_FIX_TOKEN_ERROR_FORMAT, token));
            }
            return FormValidation.ok();
        }

        public FormValidation doTestConnection(@QueryParameter String url, @QueryParameter String token) throws IOException, ServletException {
            ThreadFixService threadFixService = new ThreadFixService(url, token);
            RestResponse<Organization[]> getAllTeamsResponse = threadFixService.getAllTeams();
            if (getAllTeamsResponse.success) {
                return FormValidation.ok((String)"ThreadFix server connection successful!");
            }
            return FormValidation.error((String)"Unable to connect to ThreadFix server");
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public boolean configure(StaplerRequest staplerRequest, JSONObject formData) throws Descriptor.FormException {
            this.url = formData.getString(URL_PARAMETER);
            if (!this.isUrlValid(this.url)) {
                throw new Descriptor.FormException(String.format(THREAD_FIX_SERVER_URL_ERROR_FORMAT, this.url), URL_PARAMETER);
            }
            this.token = formData.getString(TOKEN_PARAMETER);
            if (!this.isApiTokenValid(this.token)) {
                throw new Descriptor.FormException(String.format(THREAD_FIX_TOKEN_ERROR_FORMAT, this.token), TOKEN_PARAMETER);
            }
            this.save();
            return super.configure(staplerRequest, formData);
        }

        public ListBoxModel doFillAppIdItems() {
            ListBoxModel appIds = new ListBoxModel();
            ThreadFixService threadFixService = new ThreadFixService(this.url, this.token);
            RestResponse<Organization[]> getAllTeamsResponse = threadFixService.getAllTeams();
            if (getAllTeamsResponse.success) {
                for (Organization organization : (Organization[])getAllTeamsResponse.object) {
                    for (Application application : organization.getActiveApplications()) {
                        appIds.add(organization.getName() + " - " + application.getName(), Integer.toString(application.getId()));
                    }
                }
            } else {
                appIds.add("ERROR RETRIEVING TEAMS", "-1");
            }
            return appIds;
        }

        public String getDisplayName() {
            return DISPLAY_NAME;
        }

        private boolean isUrlValid(String url) {
            return this.urlValidator.isValid(url);
        }

        private void validateUrl() throws AbortException {
            if (!this.isUrlValid(this.url)) {
                throw new AbortException(String.format(THREAD_FIX_SERVER_URL_ERROR_FORMAT, this.url));
            }
        }

        private boolean isApiTokenValid(String apiToken) {
            if (apiToken == null) {
                return false;
            }
            if (apiToken.isEmpty()) {
                return false;
            }
            Matcher matcher = this.apiTokenPattern.matcher(apiToken);
            return matcher.matches();
        }

        private void validateToken() throws AbortException {
            if (!this.isApiTokenValid(this.token)) {
                throw new AbortException(String.format(THREAD_FIX_TOKEN_ERROR_FORMAT, this.token));
            }
        }

        public String getUrl() {
            return this.url;
        }

        public String getToken() {
            return this.token;
        }
    }
}

