/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XmlHelper {
    private static final XPathFactory XPF = XPathFactory.newInstance();
    private static final DocumentBuilderFactory DBF = DocumentBuilderFactory.newInstance();
    private static final TransformerFactory TF = TransformerFactory.newInstance();

    public static String peekValue(Document doc, String xpathExpression) throws XPathExpressionException {
        XPath xPath = XPF.newXPath();
        XPathExpression expression = xPath.compile(xpathExpression);
        Node node = (Node)expression.evaluate(doc, XPathConstants.NODE);
        String result = node != null ? node.getTextContent() : null;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String peekValue(File file, String xpathExpression) throws ParserConfigurationException, IOException, SAXException, XPathExpressionException {
        Document doc;
        DocumentBuilder db = DBF.newDocumentBuilder();
        try (FileInputStream fis = new FileInputStream(file);){
            doc = db.parse(fis);
        }
        String result = XmlHelper.peekValue(doc, xpathExpression);
        return result;
    }

    public static void pokeValue(Document doc, String xpathExpression, String value) throws XPathExpressionException {
        XPath xPath = XPF.newXPath();
        XPathExpression expression = xPath.compile(xpathExpression);
        Node node = (Node)expression.evaluate(doc, XPathConstants.NODE);
        node.setTextContent(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pokeValue(File file, String xpathExpression, String value) throws XPathExpressionException, ParserConfigurationException, SAXException, IOException, TransformerException {
        Document doc;
        DocumentBuilder db = DBF.newDocumentBuilder();
        try (FileInputStream fis = new FileInputStream(file);){
            doc = db.parse(fis);
        }
        XmlHelper.pokeValue(doc, xpathExpression, value);
        Transformer t = TF.newTransformer();
        DOMSource source = new DOMSource(doc);
        try (FileOutputStream fos = new FileOutputStream(file);){
            StreamResult result = new StreamResult(fos);
            t.transform(source, result);
        }
    }
}

