/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs.util;

import hudson.plugins.tfs.util.QueryString;
import hudson.plugins.tfs.util.StringHelper;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Scanner;
import java.util.TreeMap;
import org.eclipse.jgit.transport.URIish;

public class UriHelper {
    private static final Map<String, Integer> SCHEMES_TO_DEFAULT_PORTS;
    public static final String UTF_8 = "UTF-8";
    private static final String DEFAULT_COLLECTION = "DefaultCollection";

    public static boolean areSame(URI a, URI b) {
        String bPath;
        int bPort;
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        if (!StringHelper.equalIgnoringCase(a.getScheme(), b.getScheme())) {
            return false;
        }
        if (!StringHelper.equalIgnoringCase(a.getHost(), b.getHost())) {
            return false;
        }
        int aPort = UriHelper.normalizePort(a);
        if (aPort != (bPort = UriHelper.normalizePort(b))) {
            return false;
        }
        String aPath = UriHelper.normalizePath(a);
        if (!StringHelper.equal(aPath, bPath = UriHelper.normalizePath(b))) {
            return false;
        }
        if (!StringHelper.equal(a.getQuery(), b.getQuery())) {
            return false;
        }
        return StringHelper.equal(a.getFragment(), b.getFragment());
    }

    public static boolean areSameGitRepo(URIish a, URIish b) {
        URI uriA = a == null ? null : URI.create(a.toString());
        URI uriB = b == null ? null : URI.create(b.toString());
        return UriHelper.areSameGitRepo(uriA, uriB);
    }

    public static boolean areSameGitRepo(URI a, URI b) {
        String bPath;
        int bPort;
        int aPort;
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        if (StringHelper.equalIgnoringCase(a.getScheme(), b.getScheme()) && (aPort = UriHelper.normalizePort(a)) != (bPort = UriHelper.normalizePort(b))) {
            return false;
        }
        if (!StringHelper.equalIgnoringCase(a.getHost(), b.getHost())) {
            return false;
        }
        String aPath = UriHelper.normalizePath(a);
        if (StringHelper.equal(aPath, bPath = UriHelper.normalizePath(b))) {
            return true;
        }
        Iterator<String> aPathParts = UriHelper.decomposePath(aPath);
        boolean aSeenDefaultCollection = false;
        Iterator<String> bPathParts = UriHelper.decomposePath(bPath);
        boolean bSeenDefaultCollection = false;
        while (aPathParts.hasNext() && bPathParts.hasNext()) {
            String aPart = aPathParts.next();
            String bPart = bPathParts.next();
            if (StringHelper.equalIgnoringCase(DEFAULT_COLLECTION, aPart) && aPathParts.hasNext() && !aSeenDefaultCollection) {
                aPart = aPathParts.next();
                aSeenDefaultCollection = true;
            }
            if (StringHelper.equalIgnoringCase(DEFAULT_COLLECTION, bPart) && bPathParts.hasNext() && !bSeenDefaultCollection) {
                bPart = bPathParts.next();
                bSeenDefaultCollection = true;
            }
            if (StringHelper.equalIgnoringCase(aPart, bPart)) continue;
            return false;
        }
        return true;
    }

    static int normalizePort(URI uri) {
        String scheme;
        int port = uri.getPort();
        if (port == -1 && (scheme = uri.getScheme()) != null && SCHEMES_TO_DEFAULT_PORTS.containsKey(scheme)) {
            port = SCHEMES_TO_DEFAULT_PORTS.get(scheme);
        }
        return port;
    }

    static String normalizePath(URI uri) {
        String path = uri.getPath();
        if (path == null) {
            path = "/";
        } else if (!path.endsWith("/")) {
            path = path + "/";
        }
        return path;
    }

    static Iterator<String> decomposePath(String path) {
        return new Scanner(path).useDelimiter("/");
    }

    public static boolean hasPath(URI uri) {
        String path = uri.getPath();
        return path != null && path.length() > 0 && !path.equals("/");
    }

    public static boolean isWellFormedUriString(String uriString) {
        try {
            new URI(uriString);
            return true;
        }
        catch (URISyntaxException ignored) {
            return false;
        }
    }

    public static URI join(URI collectionUri, Object ... components) {
        return UriHelper.join(collectionUri.toString(), components);
    }

    public static URI join(String collectionUrl, Object ... components) {
        StringBuilder sb = new StringBuilder(collectionUrl);
        boolean baseEndedWithSlash = UriHelper.endsWithSlash(sb);
        boolean first = true;
        for (Object component : components) {
            boolean hasSlash = false;
            if (component instanceof QueryString) {
                QueryString queryString = (QueryString)component;
                if (first && !baseEndedWithSlash) {
                    sb.append('/');
                }
                sb.append("?");
                sb.append(queryString.toString());
                break;
            }
            if (first) {
                first = false;
                if (!baseEndedWithSlash) {
                    sb.append('/');
                }
            } else {
                sb.append('/');
            }
            try {
                String encodedComponent = URLEncoder.encode(component.toString(), UTF_8);
                String correctlyEncodedComponent = encodedComponent.replaceAll("\\+", "%20");
                sb.append(correctlyEncodedComponent);
            }
            catch (UnsupportedEncodingException e) {
                throw new Error(e);
            }
        }
        String uriString = sb.toString();
        return URI.create(uriString);
    }

    static boolean endsWithSlash(StringBuilder stringBuilder) {
        int length = stringBuilder.length();
        return length > 0 && stringBuilder.charAt(length - 1) == '/';
    }

    public static String serializeParameters(Map<String, String> parameters) {
        try {
            StringBuilder sb = new StringBuilder();
            Iterator<Map.Entry<String, String>> iterator = parameters.entrySet().iterator();
            if (iterator.hasNext()) {
                String encodedValue;
                Map.Entry<String, String> entry = iterator.next();
                String key = entry.getKey();
                String encodedKey = URLEncoder.encode(key, UTF_8);
                sb.append(encodedKey);
                String value = entry.getValue();
                if (value != null) {
                    encodedValue = URLEncoder.encode(value, UTF_8);
                    sb.append('=').append(encodedValue);
                }
                while (iterator.hasNext()) {
                    sb.append('&');
                    entry = iterator.next();
                    key = entry.getKey();
                    encodedKey = URLEncoder.encode(key, UTF_8);
                    sb.append(encodedKey);
                    value = entry.getValue();
                    if (value == null) continue;
                    encodedValue = URLEncoder.encode(value, UTF_8);
                    sb.append('=').append(encodedValue);
                }
            }
            return sb.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
    }

    static {
        TreeMap<String, Integer> defaultPorts = new TreeMap<String, Integer>(String.CASE_INSENSITIVE_ORDER);
        defaultPorts.put("ftp", 21);
        defaultPorts.put("ssh", 22);
        defaultPorts.put("http", 80);
        defaultPorts.put("https", 443);
        SCHEMES_TO_DEFAULT_PORTS = Collections.unmodifiableMap(defaultPorts);
    }
}

