/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs.util;

import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.tfs.CommitParameterAction;
import hudson.plugins.tfs.PullRequestParameterAction;
import hudson.plugins.tfs.UnsupportedIntegrationAction;
import hudson.plugins.tfs.model.GitCodePushedEventArgs;
import hudson.plugins.tfs.model.PullRequestMergeCommitCreatedEventArgs;
import hudson.plugins.tfs.model.TeamGitStatus;
import hudson.plugins.tfs.telemetry.TelemetryHelper;
import hudson.plugins.tfs.util.TeamRestClient;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import javax.annotation.Nonnull;

public final class TeamStatus {
    private TeamStatus() {
    }

    public static void createFromRun(@Nonnull Run<?, ?> run, @Nonnull TaskListener listener, String featureDisplayName) throws IOException {
        PullRequestMergeCommitCreatedEventArgs pullRequestMergeCommitCreatedEventArgs;
        GitCodePushedEventArgs gitCodePushedEventArgs;
        if (!UnsupportedIntegrationAction.isSupported(run, listener)) {
            PrintStream logger = listener.getLogger();
            logger.print("NOTICE: ");
            logger.print("You selected '");
            logger.print(featureDisplayName);
            logger.println("' on your Jenkins job, but this option has no effect when calling the job from the 'Jenkins Queue Job' task in TFS/Team Services.");
            return;
        }
        CommitParameterAction commitParameter = (CommitParameterAction)run.getAction(CommitParameterAction.class);
        if (commitParameter != null) {
            gitCodePushedEventArgs = commitParameter.getGitCodePushedEventArgs();
            if (commitParameter instanceof PullRequestParameterAction) {
                PullRequestParameterAction prpa = (PullRequestParameterAction)commitParameter;
                pullRequestMergeCommitCreatedEventArgs = prpa.getPullRequestMergeCommitCreatedEventArgs();
            } else {
                pullRequestMergeCommitCreatedEventArgs = null;
            }
        } else {
            return;
        }
        URI collectionUri = gitCodePushedEventArgs.collectionUri;
        TeamGitStatus status = TeamGitStatus.fromRun(run);
        TelemetryHelper.sendEvent("team-status", new TelemetryHelper.PropertyMapBuilder().serverContext(collectionUri.toString(), collectionUri.toString()).pair("feature", featureDisplayName).pair("status", status.state.toString()).build());
        TeamStatus.addStatus(pullRequestMergeCommitCreatedEventArgs, status);
    }

    public static void createFromJob(PullRequestMergeCommitCreatedEventArgs pullRequestMergeCommitCreatedEventArgs, Job job) throws IOException {
        TeamGitStatus status = TeamGitStatus.fromJob(job);
        TeamStatus.addStatus(pullRequestMergeCommitCreatedEventArgs, status);
    }

    private static void addStatus(PullRequestMergeCommitCreatedEventArgs gitCodePushedEventArgs, TeamGitStatus status) throws IOException {
        PullRequestMergeCommitCreatedEventArgs pullRequestMergeCommitCreatedEventArgs = gitCodePushedEventArgs instanceof PullRequestMergeCommitCreatedEventArgs ? gitCodePushedEventArgs : null;
        URI collectionUri = gitCodePushedEventArgs.collectionUri;
        TeamRestClient client = new TeamRestClient(collectionUri);
        if (pullRequestMergeCommitCreatedEventArgs != null) {
            if (pullRequestMergeCommitCreatedEventArgs.iterationId == -1) {
                client.addPullRequestStatus(pullRequestMergeCommitCreatedEventArgs, status);
            } else {
                client.addPullRequestIterationStatus(pullRequestMergeCommitCreatedEventArgs, status);
            }
        }
        client.addCommitStatus(gitCodePushedEventArgs, status);
    }
}

