/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs.util;

import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.microsoft.tfs.core.httpclient.HttpClient;
import com.microsoft.tfs.core.httpclient.HttpMethod;
import com.microsoft.tfs.core.httpclient.NameValuePair;
import com.microsoft.tfs.util.StringUtil;
import com.microsoft.visualstudio.services.webapi.patch.Operation;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.plugins.tfs.TeamCollectionConfiguration;
import hudson.plugins.tfs.model.GitCodePushedEventArgs;
import hudson.plugins.tfs.model.JobCompletionEventArgs;
import hudson.plugins.tfs.model.JsonPatchOperation;
import hudson.plugins.tfs.model.Link;
import hudson.plugins.tfs.model.ListOfGitRepositories;
import hudson.plugins.tfs.model.PullRequestMergeCommitCreatedEventArgs;
import hudson.plugins.tfs.model.Server;
import hudson.plugins.tfs.model.TeamGitStatus;
import hudson.plugins.tfs.model.WorkItem;
import hudson.plugins.tfs.util.EndpointHelper;
import hudson.plugins.tfs.util.MediaType;
import hudson.plugins.tfs.util.QueryString;
import hudson.plugins.tfs.util.UriHelper;
import hudson.util.Secret;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import javax.xml.bind.DatatypeConverter;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;

public class TeamRestClient {
    private static final String AUTHORIZATION = "Authorization";
    private static final String API_VERSION = "api-version";
    private static final String NEW_LINE = System.getProperty("line.separator");
    private final URI collectionUri;
    private final boolean isTeamServices;
    private final String authorization;
    private final Server server;

    public TeamRestClient(URI collectionUri) throws IOException {
        this(collectionUri, TeamCollectionConfiguration.findCredentialsForCollection(collectionUri));
    }

    public TeamRestClient(URI collectionUri, StandardUsernamePasswordCredentials credentials) throws IOException {
        this.collectionUri = collectionUri;
        String hostName = collectionUri.getHost();
        this.server = Server.create(null, null, collectionUri.toString(), credentials, null, null);
        this.isTeamServices = TeamCollectionConfiguration.isTeamServices(hostName);
        this.authorization = this.isTeamServices && credentials != null ? TeamRestClient.createAuthorization(credentials) : null;
    }

    public TeamRestClient(String collectionUri, StandardUsernamePasswordCredentials credentials) throws IOException {
        this(URI.create(collectionUri), credentials);
    }

    static String createAuthorization(StandardUsernamePasswordCredentials credentials) {
        String username = credentials.getUsername();
        Secret secretPassword = credentials.getPassword();
        String password = secretPassword.getPlainText();
        String credPair = username + ":" + password;
        byte[] credBytes = credPair.getBytes(MediaType.UTF_8);
        String base64enc = DatatypeConverter.printBase64Binary((byte[])credBytes);
        String result = "Basic " + base64enc;
        return result;
    }

    protected <TRequest, TResponse> TResponse request(Class<TResponse> responseClass, hudson.plugins.tfs.model.HttpMethod httpMethod, URI requestUri, TRequest requestBody) throws IOException {
        return this.request(responseClass, httpMethod, requestUri, requestBody, null);
    }

    protected <TRequest, TResponse> TResponse request(Class<TResponse> responseClass, hudson.plugins.tfs.model.HttpMethod httpMethod, URI requestUri, TRequest requestBody, NameValuePair[] additionalRequestHeaders) throws IOException {
        String stringRequestBody;
        HttpClient httpClient = this.server.getHttpClient();
        if (requestBody != null) {
            Object jsonObject = requestBody instanceof JSON ? (JSON)requestBody : JSONObject.fromObject(requestBody);
            stringRequestBody = jsonObject.toString(0);
        } else {
            stringRequestBody = null;
        }
        HttpMethod clientMethod = httpMethod.createClientMethod(requestUri.toString(), stringRequestBody);
        if (this.authorization != null) {
            clientMethod.addRequestHeader(AUTHORIZATION, this.authorization);
        }
        if (additionalRequestHeaders != null && additionalRequestHeaders.length > 0) {
            for (NameValuePair pair : additionalRequestHeaders) {
                clientMethod.addRequestHeader(pair.getName(), pair.getValue());
            }
        }
        String stringResponseBody = TeamRestClient.innerRequest(clientMethod, httpClient);
        if (responseClass == Void.class) {
            return null;
        }
        if (responseClass == String.class) {
            return (TResponse)stringResponseBody;
        }
        TResponse result = TeamRestClient.deserialize(responseClass, stringResponseBody);
        return result;
    }

    public static <TResponse> TResponse deserialize(Class<TResponse> responseClass, String stringResponseBody) {
        try {
            return (TResponse)EndpointHelper.MAPPER.readValue(stringResponseBody, responseClass);
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String innerRequest(HttpMethod clientMethod, HttpClient httpClient) throws IOException {
        String stringResult;
        int httpStatus = httpClient.executeMethod(clientMethod);
        InputStream responseStream = null;
        try {
            if (httpStatus >= 400) {
                responseStream = clientMethod.getResponseBodyAsStream();
                String responseText = TeamRestClient.readResponseText(responseStream);
                StringBuilder sb = new StringBuilder("HTTP ").append(httpStatus);
                String statusText = clientMethod.getStatusText();
                if (statusText != null) {
                    sb.append(" (").append(statusText).append(")");
                }
                if (!StringUtil.isNullOrEmpty((String)responseText)) {
                    sb.append(": ").append(responseText);
                }
                throw new IOException(sb.toString());
            }
            responseStream = clientMethod.getResponseBodyAsStream();
            stringResult = TeamRestClient.readResponseText(responseStream);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(responseStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)responseStream);
        return stringResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"}, justification="Better mot modify charset in case it might raise errors")
    static String readResponseText(InputStream inputStream) throws IOException {
        InputStreamReader isr = new InputStreamReader(inputStream);
        BufferedReader reader = new BufferedReader(isr);
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                sb.append(line);
                sb.append(NEW_LINE);
            }
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
            IOUtils.closeQuietly((Reader)isr);
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        return sb.toString();
    }

    public String ping() throws IOException {
        URI requestUri = this.isTeamServices ? UriHelper.join(this.collectionUri, "_apis", "connectiondata") : UriHelper.join(this.collectionUri, "_home", "About");
        return this.request(String.class, hudson.plugins.tfs.model.HttpMethod.GET, requestUri, null);
    }

    public ListOfGitRepositories getRepositories() throws IOException {
        QueryString qs = new QueryString(API_VERSION, "1.0");
        URI requestUri = UriHelper.join(this.collectionUri, "_apis", "git", "repositories", qs);
        return this.request(ListOfGitRepositories.class, hudson.plugins.tfs.model.HttpMethod.GET, requestUri, null);
    }

    public TeamGitStatus addCommitStatus(GitCodePushedEventArgs args, TeamGitStatus status) throws IOException {
        QueryString qs = new QueryString(API_VERSION, "2.1");
        URI requestUri = UriHelper.join(this.collectionUri, args.projectId, "_apis", "git", "repositories", args.repoId, "commits", args.commit, "statuses", qs);
        return this.request(TeamGitStatus.class, hudson.plugins.tfs.model.HttpMethod.POST, requestUri, status);
    }

    public WorkItem getWorkItem(int workItemId) throws IOException {
        QueryString qs = new QueryString(API_VERSION, "1.0");
        URI requestUri = UriHelper.join(this.collectionUri, "_apis", "wit", "workitems", workItemId, qs);
        return this.request(WorkItem.class, hudson.plugins.tfs.model.HttpMethod.GET, requestUri, null);
    }

    public void addHyperlinkToWorkItem(int workItemId, String hyperlink) throws IOException {
        JSONArray doc = new JSONArray();
        WorkItem workItem = this.getWorkItem(workItemId);
        JsonPatchOperation testRev = new JsonPatchOperation();
        testRev.setOp(Operation.TEST);
        testRev.setPath("/rev");
        testRev.setValue(workItem.getRev());
        doc.add((Object)testRev);
        Link link = new Link("Hyperlink", hyperlink);
        JsonPatchOperation addRelation = new JsonPatchOperation();
        addRelation.setOp(Operation.ADD);
        addRelation.setPath("/relations/-");
        addRelation.setValue(link);
        doc.add((Object)addRelation);
        QueryString qs = new QueryString(API_VERSION, "1.0");
        URI requestUri = UriHelper.join(this.collectionUri, "_apis", "wit", "workitems", workItemId, qs);
        this.request(Void.class, hudson.plugins.tfs.model.HttpMethod.PATCH, requestUri, doc);
    }

    public TeamGitStatus addPullRequestStatus(PullRequestMergeCommitCreatedEventArgs args, TeamGitStatus status) throws IOException {
        QueryString qs = new QueryString(API_VERSION, "4.1-preview");
        URI requestUri = UriHelper.join(this.collectionUri, args.projectId, "_apis", "git", "repositories", args.repoId, "pullRequests", args.pullRequestId, "statuses", qs);
        return this.request(TeamGitStatus.class, hudson.plugins.tfs.model.HttpMethod.POST, requestUri, status);
    }

    public TeamGitStatus addPullRequestIterationStatus(PullRequestMergeCommitCreatedEventArgs args, TeamGitStatus status) throws IOException {
        QueryString qs = new QueryString(API_VERSION, "4.1-preview");
        URI requestUri = UriHelper.join(this.collectionUri, args.projectId, "_apis", "git", "repositories", args.repoId, "pullRequests", args.pullRequestId, "iterations", args.iterationId, "statuses", qs);
        return this.request(TeamGitStatus.class, hudson.plugins.tfs.model.HttpMethod.POST, requestUri, status);
    }

    public void sendJobCompletionEvent(JobCompletionEventArgs args) throws IOException {
        QueryString qs = new QueryString(API_VERSION, "3.2", "publisherId", "jenkins", "channelId", args.getServerKey());
        URI requestUri = UriHelper.join(this.collectionUri, "_apis", "public", "hooks", "externalEvents", qs);
        JSONObject json = JSONObject.fromObject((Object)args.getPayload());
        NameValuePair[] headers = new NameValuePair[]{new NameValuePair("X-Event-Key", "job:completion"), new NameValuePair("X-Jenkins-Signature", args.getPayloadSignature()), new NameValuePair("X-Jenkins-ServerKey", args.getServerKey())};
        this.request(Void.class, hudson.plugins.tfs.model.HttpMethod.POST, requestUri, json, headers);
    }
}

