/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs.util;

public class StringHelper {
    public static boolean endsWithIgnoreCase(String haystack, String needle) {
        int hl;
        if (haystack == null) {
            throw new IllegalArgumentException("Parameter 'haystack' is null.");
        }
        if (needle == null) {
            throw new IllegalArgumentException("Parameter 'needle' is null.");
        }
        int nl = needle.length();
        if (nl == (hl = haystack.length())) {
            return haystack.equalsIgnoreCase(needle);
        }
        if (nl > hl) {
            return false;
        }
        int toffset = hl - nl;
        return haystack.regionMatches(true, toffset, needle, 0, nl);
    }

    public static boolean equal(String a, String b) {
        return StringHelper.innerEqual(a, b, false);
    }

    public static boolean equalIgnoringCase(String a, String b) {
        return StringHelper.innerEqual(a, b, true);
    }

    static boolean innerEqual(String a, String b, boolean ignoreCase) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        int length = a.length();
        if (length != b.length()) {
            return false;
        }
        return a.regionMatches(ignoreCase, 0, b, 0, length);
    }

    public static String determineContentTypeWithoutCharset(String contentType) {
        if (contentType == null) {
            return null;
        }
        int indexOfSemicolon = contentType.indexOf(59);
        if (indexOfSemicolon != -1) {
            String beforeCharset = contentType.substring(0, indexOfSemicolon);
            return beforeCharset.trim();
        }
        return contentType;
    }
}

