/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs.util;

import hudson.plugins.tfs.util.StringHelper;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import org.apache.commons.io.IOUtils;
import org.kohsuke.stapler.AnnotationHandler;
import org.kohsuke.stapler.InjectedParameter;
import org.kohsuke.stapler.StaplerRequest;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.PARAMETER})
@Documented
@InjectedParameter(value=StringBodyHandler.class)
public @interface StringBodyParameter {

    public static class StringBodyHandler
    extends AnnotationHandler<StringBodyParameter> {
        private static final Logger LOGGER = Logger.getLogger(StringBodyHandler.class.getName());

        public Object parse(StaplerRequest request, StringBodyParameter a, Class type, String parameterName) throws ServletException {
            String rawContentType = request.getContentType();
            String contentType = StringHelper.determineContentTypeWithoutCharset(rawContentType);
            if ("application/x-www-form-urlencoded".equals(contentType)) {
                return request.getParameter(parameterName);
            }
            String characterEncoding = request.getCharacterEncoding();
            try {
                return IOUtils.toString((InputStream)request.getInputStream(), (String)characterEncoding);
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Unable to obtain request body: {}", e.getMessage());
                return null;
            }
        }
    }
}

