/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs.util;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class EndpointHelper {
    public static final ObjectMapper MAPPER = new ObjectMapper();

    public static void error(final int code, final Throwable cause) {
        throw new HttpResponses.HttpResponseException(cause){

            public void generateResponse(StaplerRequest req, StaplerResponse rsp, Object node) throws IOException, ServletException {
                rsp.setStatus(code);
                rsp.setHeader("X-Error-Message", cause.getMessage());
                rsp.setContentType("text/plain;charset=UTF-8");
                PrintWriter w = new PrintWriter(rsp.getWriter());
                cause.printStackTrace(w);
                w.close();
            }
        };
    }

    static {
        MAPPER.enable(DeserializationFeature.READ_ENUMS_USING_TO_STRING);
        MAPPER.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }
}

