/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs.util;

import com.microsoft.tfs.core.clients.versioncontrol.specs.version.DateVersionSpec;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public class DateUtil {
    private static final String ISO_8601_DATE_TIME_MINUS_FRACTIONS = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    public static final ThreadLocal<SimpleDateFormat> TFS_DATETIME_FORMATTER = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat dateFormat = new SimpleDateFormat(DateUtil.ISO_8601_DATE_TIME_MINUS_FRACTIONS);
            dateFormat.setTimeZone(new SimpleTimeZone(0, "GMT"));
            return dateFormat;
        }
    };

    private DateUtil() {
    }

    public static String toString(DateVersionSpec dateVersionSpec) {
        Calendar calendar = dateVersionSpec.getDate();
        return DateUtil.toString(calendar);
    }

    public static String toString(Calendar calendar) {
        Date dateTime = calendar.getTime();
        return DateUtil.toString(dateTime);
    }

    public static String toString(Date dateTime) {
        FieldPosition fieldPosition = new FieldPosition(-1);
        SimpleDateFormat simpleDateFormat = TFS_DATETIME_FORMATTER.get();
        StringBuffer sb = new StringBuffer(1 + ISO_8601_DATE_TIME_MINUS_FRACTIONS.length());
        sb.append('D');
        simpleDateFormat.format(dateTime, sb, fieldPosition);
        String result = sb.toString();
        return result;
    }

    public static Date parseDate(String dateString) throws ParseException {
        return DateUtil.parseDate(dateString, Locale.getDefault(), TimeZone.getDefault());
    }

    public static Date parseDate(String dateString, Locale locale, TimeZone timezone) throws ParseException {
        Date date = null;
        dateString = dateString.replaceAll("(p|P)\\.(m|M)\\.", "PM").replaceAll("(a|A)\\.(m|M)\\.", "AM");
        try {
            date = new Date(Date.parse(dateString));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (date == null) {
            DateFormat[] formats = DateUtil.createDateFormatsForLocaleAndTimeZone(locale, timezone);
            return DateUtil.parseWithFormats(dateString, formats);
        }
        return date;
    }

    static Date parseWithFormats(String input, DateFormat[] formats) throws ParseException {
        ParseException parseException = null;
        for (int i = 0; i < formats.length; ++i) {
            try {
                return formats[i].parse(input);
            }
            catch (ParseException ex) {
                parseException = ex;
                continue;
            }
        }
        if (parseException == null) {
            throw new IllegalStateException("No dateformats found that can be used for parsing '" + input + "'");
        }
        throw parseException;
    }

    static DateFormat[] createDateFormatsForLocaleAndTimeZone(Locale locale, TimeZone timeZone) {
        ArrayList<DateFormat> formats = new ArrayList<DateFormat>();
        DateUtil.addDateTimeFormatsToList(locale, timeZone, formats);
        DateUtil.addDateFormatsToList(locale, timeZone, formats);
        return formats.toArray(new DateFormat[formats.size()]);
    }

    static void addDateFormatsToList(Locale locale, TimeZone timeZone, List<DateFormat> formats) {
        for (int dateStyle = 0; dateStyle <= 3; ++dateStyle) {
            DateFormat df = DateFormat.getDateInstance(dateStyle, locale);
            df.setTimeZone(timeZone);
            formats.add(df);
        }
    }

    static void addDateTimeFormatsToList(Locale locale, TimeZone timeZone, List<DateFormat> formats) {
        for (int dateStyle = 0; dateStyle <= 3; ++dateStyle) {
            for (int timeStyle = 0; timeStyle <= 3; ++timeStyle) {
                DateFormat df = DateFormat.getDateTimeInstance(dateStyle, timeStyle, locale);
                if (timeZone != null) {
                    df.setTimeZone(timeZone);
                }
                formats.add(df);
            }
        }
    }
}

