/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs.util;

import hudson.model.AbstractBuild;
import hudson.model.Node;
import hudson.model.Run;
import hudson.plugins.tfs.model.WorkspaceConfiguration;
import java.io.IOException;

public class BuildWorkspaceConfigurationRetriever {
    public BuildWorkspaceConfiguration getLatestForNode(Node needleNode, Run<?, ?> latestRun) {
        WorkspaceConfiguration configuration;
        Node node;
        AbstractBuild build;
        if (latestRun == null || !(latestRun instanceof AbstractBuild)) {
            return null;
        }
        for (build = (AbstractBuild)latestRun; !(build == null || (node = build.getBuiltOn()) != null && node.getNodeName().equals(needleNode.getNodeName())); build = build.getPreviousBuild()) {
        }
        if (build != null && (configuration = (WorkspaceConfiguration)build.getAction(WorkspaceConfiguration.class)) != null) {
            return new BuildWorkspaceConfiguration(configuration, build);
        }
        return null;
    }

    public static class BuildWorkspaceConfiguration
    extends WorkspaceConfiguration {
        private static final long serialVersionUID = 1L;
        private final transient AbstractBuild<?, ?> build;

        public BuildWorkspaceConfiguration(WorkspaceConfiguration configuration, AbstractBuild<?, ?> build) {
            super(configuration);
            this.build = build;
        }

        public void save() throws IOException {
            if (!this.workspaceExists()) {
                ((WorkspaceConfiguration)this.build.getAction(WorkspaceConfiguration.class)).setWorkspaceWasRemoved();
            }
            this.build.save();
        }

        @Override
        public boolean equals(Object o) {
            return super.equals(o);
        }
    }
}

