/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs.telemetry;

import com.microsoft.applicationinsights.TelemetryClient;
import com.microsoft.applicationinsights.TelemetryConfiguration;
import com.microsoft.applicationinsights.channel.TelemetryChannel;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import hudson.plugins.tfs.telemetry.TelemetryContextInitializer;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TelemetryHelper {
    public static final String UNKNOWN = "unknown";
    private static final String UNIQUE_PREFIX = "ai-log";
    private static final String BASE_FOLDER = "AppInsights";
    private static final String PROPERTY_VSTS_IS_HOSTED = "VSTS.TeamFoundationServer.IsHostedServer";
    private static final String PROPERTY_VSTS_SERVER_ID = "VSTS.TeamFoundationServer.ServerId";
    private static final String PROPERTY_VSTS_COLLECTION_ID = "VSTS.TeamFoundationServer.CollectionId";
    private static final String ACTION_NAME_FORMAT = "Action/%s";
    private static final Logger logger = LoggerFactory.getLogger(TelemetryHelper.class);
    private TelemetryClient telemetryClient;

    private static TelemetryHelper getInstance() {
        return TfsTelemetryHelperHolder.INSTANCE;
    }

    private TelemetryHelper() {
        String skip = System.getProperties().getProperty("hudson.plugins.tfs.telemetry.skipClientInitialization");
        if (StringUtils.isNotEmpty((String)skip) && StringUtils.equalsIgnoreCase((String)skip, (String)"true")) {
            return;
        }
        HashMap<String, String> loggerData = new HashMap<String, String>();
        loggerData.put("Level", InternalLogger.LoggingLevel.ERROR.toString());
        loggerData.put("UniquePrefix", UNIQUE_PREFIX);
        loggerData.put("BaseFolder", BASE_FOLDER);
        InternalLogger.INSTANCE.initialize(InternalLogger.LoggerOutputType.FILE.toString(), loggerData);
        String isDeveloperModeProperty = System.getProperty("hudson.plugins.tfs.telemetry.isDeveloperMode", "false");
        boolean isDeveloperMode = StringUtils.equalsIgnoreCase((String)isDeveloperModeProperty, (String)"true");
        TelemetryContextInitializer initializer = new TelemetryContextInitializer(isDeveloperMode);
        TelemetryConfiguration.getActive().getContextInitializers().add(initializer);
        TelemetryChannel channel = TelemetryConfiguration.getActive().getChannel();
        if (channel == null) {
            logger.error("Failed to load telemetry channel");
            return;
        }
        channel.setDeveloperMode(isDeveloperMode);
        logger.debug("AppInsights telemetry initialized");
        logger.debug("    Developer Mode: ", (Object)channel.isDeveloperMode());
        this.telemetryClient = new TelemetryClient();
    }

    public static void sendEvent(String name, Map<String, String> properties) {
        try {
            TelemetryHelper.getInstance().sendEventInternal(name, properties);
        }
        catch (Exception e) {
            logger.warn("Error sending event telemetry", (Throwable)e);
        }
    }

    public static void sendMetric(String name, double value) {
        try {
            TelemetryHelper.getInstance().sendMetricInternal(name, value);
        }
        catch (Exception e) {
            logger.warn("Error sending metric telemetry", (Throwable)e);
        }
    }

    public static void sendException(Exception exception, Map<String, String> properties) {
        try {
            TelemetryHelper.getInstance().sendExceptionInternal(exception, properties);
        }
        catch (Exception e) {
            logger.warn("Error sending exception telemetry", (Throwable)e);
        }
    }

    protected void sendMetricInternal(String name, double value) {
        logger.debug(String.format("sendMetric(%s, %f)", name, value));
        if (this.telemetryClient != null) {
            this.telemetryClient.trackMetric(name, value);
        }
    }

    protected void sendEventInternal(String name, Map<String, String> properties) {
        String eventName = String.format(ACTION_NAME_FORMAT, name);
        PropertyMapBuilder builder = new PropertyMapBuilder(properties);
        logger.debug(String.format("sendEvent(%s, %s)", name, builder.toString()));
        if (this.telemetryClient != null) {
            this.telemetryClient.trackEvent(eventName, builder.build(), null);
        }
    }

    protected void sendExceptionInternal(Exception exception, Map<String, String> properties) {
        PropertyMapBuilder builder = new PropertyMapBuilder(properties);
        logger.debug(String.format("sendException(%s, %s)", exception.getMessage(), builder.toString()));
        if (this.telemetryClient != null) {
            this.telemetryClient.trackException(exception, builder.build(), null);
        }
    }

    public static class PropertyMapBuilder {
        public static final Map<String, String> EMPTY = new PropertyMapBuilder().build();
        private Map<String, String> properties = new HashMap<String, String>();

        public PropertyMapBuilder() {
            this(null);
        }

        public PropertyMapBuilder(Map<String, String> properties) {
            this.properties = properties != null ? new HashMap<String, String>(properties) : new HashMap<String, String>();
        }

        public Map<String, String> build() {
            return new HashMap<String, String>(this.properties);
        }

        public PropertyMapBuilder serverContext(String serverUrl, String collectionUrl) {
            if (serverUrl != null) {
                boolean isHosted = StringUtils.containsIgnoreCase((String)serverUrl, (String)".visualstudio.com");
                this.add(TelemetryHelper.PROPERTY_VSTS_IS_HOSTED, Boolean.toString(isHosted));
                this.add(TelemetryHelper.PROPERTY_VSTS_SERVER_ID, this.getServerId(serverUrl));
                this.add(TelemetryHelper.PROPERTY_VSTS_COLLECTION_ID, this.getCollectionId(collectionUrl));
            }
            return this;
        }

        public PropertyMapBuilder pair(String key, String value) {
            if (!StringUtils.isEmpty((String)key) && !StringUtils.isEmpty((String)value)) {
                this.add(key, value);
            }
            return this;
        }

        private String getServerId(String serverUrl) {
            try {
                if (serverUrl != null) {
                    return URI.create(serverUrl).getHost();
                }
            }
            catch (Exception ex) {
                logger.error("failed to get server URI", (Throwable)ex);
            }
            return TelemetryHelper.UNKNOWN;
        }

        private String getCollectionId(String collectionUrl) {
            try {
                if (collectionUrl != null) {
                    return URI.create(collectionUrl).getPath();
                }
            }
            catch (Exception ex) {
                logger.error("failed to get server URI", (Throwable)ex);
            }
            return TelemetryHelper.UNKNOWN;
        }

        private void add(String key, String value) {
            if (value != null) {
                this.properties.put(key, value.replace("\r", "").replace("\n", " "));
            } else {
                this.properties.put(key, "");
            }
        }

        public String toString() {
            return this.properties.toString();
        }
    }

    private static class TfsTelemetryHelperHolder {
        private static final TelemetryHelper INSTANCE = new TelemetryHelper();

        private TfsTelemetryHelperHolder() {
        }
    }
}

