/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs.telemetry;

import com.microsoft.applicationinsights.extensibility.ContextInitializer;
import com.microsoft.applicationinsights.extensibility.context.ComponentContext;
import com.microsoft.applicationinsights.extensibility.context.ContextTagKeys;
import com.microsoft.applicationinsights.extensibility.context.DeviceContext;
import com.microsoft.applicationinsights.extensibility.context.SessionContext;
import com.microsoft.applicationinsights.extensibility.context.UserContext;
import com.microsoft.applicationinsights.telemetry.TelemetryContext;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import jenkins.model.Jenkins;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TelemetryContextInitializer
implements ContextInitializer {
    private static final Logger logger = LoggerFactory.getLogger(TelemetryContextInitializer.class);
    private static final String PRODUCT_NAME = "TFS-Jenkins";
    private static final String SYS_PROP_OS_NAME = "os.name";
    private static final String SYS_PROP_OS_VERSION = "os.version";
    private static final String SYS_PROP_USER_NAME = "user.name";
    private static final String SYS_PROP_JAVA_RUNTIME = "java.runtime.name";
    private static final String SYS_PROP_JAVA_VERSION = "java.version";
    private static final String USER_AGENT_FORMAT = "{0}/{1} {2}/{3} {4}/{5} {6}/{7} ({8})";
    private static final String PROPERTY_USER_ID = "User.Id";
    private static final String PROPERTY_JENKINS_VERSION = "Jenkins.Version";
    private static final String PROPERTY_PLUGIN_VERSION = "Plugin.Version";
    private static final String PROPERTY_JAVA_NAME = "Java.Name";
    private static final String PROPERTY_JAVA_VERSION = "Java.Version";
    private static final String PROPERTY_OS_PLATFORM = "VSTS.Core.Machine.OS.Platform";
    private static final String PROPERTY_OS_VERSION = "VSTS.Core.Machine.OS.Version";
    private static final String PROPERTY_LOCALE = "Locale";
    private String hostname = "";
    private boolean isInitialized = false;
    private final boolean isDeveloperMode;

    public TelemetryContextInitializer(boolean isDeveloperMode) {
        this.isDeveloperMode = isDeveloperMode;
    }

    public void initialize(TelemetryContext context) {
        if (!this.isInitialized) {
            logger.info("Starting TelemetryContext initialization");
            this.initializeInstrumentationKey(context, this.isDeveloperMode);
            this.initializeProperties(context.getProperties());
            this.initializeUser(context.getUser());
            this.initializeComponent(context.getComponent());
            this.initializeDevice(context.getDevice());
            this.initializeTags(context.getTags());
            this.initializeSession(context.getSession());
            this.isInitialized = true;
            logger.info("Ending TelemetryContext initialization");
        }
    }

    public String getUserAgent(String defaultUserAgent) {
        try {
            return MessageFormat.format(USER_AGENT_FORMAT, PRODUCT_NAME, this.getPluginVersion(), "Jenkins", Jenkins.getVersion(), this.getPlatformName(), this.getPlatformVersion(), this.getJavaName(), this.getJavaVersion(), defaultUserAgent);
        }
        catch (Throwable t) {
            logger.warn("Error getting UserAgent", t);
            return defaultUserAgent;
        }
    }

    private void initializeDevice(DeviceContext device) {
        device.setOperatingSystem(this.getPlatformName());
        device.setOperatingSystemVersion(this.getPlatformVersion());
    }

    private void initializeInstrumentationKey(TelemetryContext context, boolean isDeveloperMode) {
        if (isDeveloperMode) {
            context.setInstrumentationKey("149da81b-a0ab-4bdf-a7e9-11e5af9e39bd");
        } else {
            context.setInstrumentationKey("0f243a28-b3c3-41f2-b7cc-d10feec45a81");
        }
    }

    private void initializeUser(UserContext user) {
        user.setId(this.getUserId());
        user.setUserAgent(this.getUserAgent(""));
    }

    private String getUserId() {
        String computerName = this.getComputerName();
        String userName = this.getSystemProperty(SYS_PROP_USER_NAME);
        String fakeUserId = MessageFormat.format("{0}@{1}", userName, computerName);
        return DigestUtils.shaHex((String)fakeUserId);
    }

    private String getComputerName() {
        if (StringUtils.isEmpty((String)this.hostname)) {
            this.hostname = "unknown";
            try {
                InetAddress address = InetAddress.getLocalHost();
                this.hostname = address.getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return this.hostname;
    }

    private void initializeComponent(ComponentContext component) {
        component.setVersion(this.getPluginVersion());
    }

    private void initializeTags(Map<String, String> tags) {
        tags.put(ContextTagKeys.getKeys().getApplicationId(), PRODUCT_NAME);
        tags.put(ContextTagKeys.getKeys().getDeviceOS(), this.getPlatformName());
        tags.put(ContextTagKeys.getKeys().getDeviceOSVersion(), this.getPlatformVersion());
    }

    private void initializeSession(SessionContext sessionContext) {
        sessionContext.setId(UUID.randomUUID().toString());
    }

    private void initializeProperties(Map<String, String> properties) {
        properties.put(PROPERTY_USER_ID, this.getUserId());
        properties.put(PROPERTY_JENKINS_VERSION, Jenkins.getVersion().toString());
        properties.put(PROPERTY_PLUGIN_VERSION, this.getPluginVersion());
        properties.put(PROPERTY_LOCALE, this.getLocaleName());
        properties.put(PROPERTY_OS_PLATFORM, this.getPlatformName());
        properties.put(PROPERTY_OS_VERSION, this.getPlatformVersion());
        properties.put(PROPERTY_JAVA_NAME, this.getJavaName());
        properties.put(PROPERTY_JAVA_VERSION, this.getJavaVersion());
    }

    private String getSystemProperty(String propertyName) {
        return System.getProperty(propertyName, "");
    }

    private String getPlatformName() {
        return this.getSystemProperty(SYS_PROP_OS_NAME);
    }

    private String getPlatformVersion() {
        return this.getSystemProperty(SYS_PROP_OS_VERSION);
    }

    private String getLocaleName() {
        return Locale.getDefault().getDisplayName();
    }

    private String getJavaName() {
        return this.getSystemProperty(SYS_PROP_JAVA_RUNTIME);
    }

    private String getJavaVersion() {
        return this.getSystemProperty(SYS_PROP_JAVA_VERSION);
    }

    private String getPluginVersion() {
        Jenkins instance = Jenkins.getInstance();
        if (instance != null && instance.getPluginManager() != null) {
            return instance.getPluginManager().getPlugin("tfs").getVersion();
        }
        return "";
    }
}

