/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs.rm;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Cause;
import hudson.plugins.tfs.JenkinsEventNotifier;
import hudson.plugins.tfs.rm.ReleaseWebHook;
import hudson.plugins.tfs.rm.ReleaseWebHookHelper;
import hudson.plugins.tfs.rm.ReleaseWebHookReference;
import hudson.plugins.tfs.rm.ReleaseWebHookStatus;
import hudson.plugins.tfs.rm.ReleaseWebHookSummaryAction;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.io.Serializable;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class ReleaseWebHookAction
extends Notifier
implements Serializable {
    private static final Logger logger = Logger.getLogger(ReleaseWebHookAction.class.getName());
    private List<ReleaseWebHookReference> webHookReferences;
    private final String apiVersion = "5.0-preview";

    @DataBoundConstructor
    public ReleaseWebHookAction(List<ReleaseWebHookReference> webHookReferences) {
        this.webHookReferences = webHookReferences;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public List<ReleaseWebHookReference> getWebHookReferences() {
        return this.webHookReferences;
    }

    public void setWebHookReferences(List<ReleaseWebHookReference> webHookReferences) {
        this.webHookReferences = webHookReferences;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        ReleaseWebHook webHook2;
        logger.entering("ReleaseWebhookAction", "Perform");
        JSONObject json = new JSONObject();
        String payload = JenkinsEventNotifier.getApiJson(build.getUrl());
        if (payload != null) {
            json = JSONObject.fromObject((Object)payload);
        }
        json.put("name", (Object)build.getProject().getFullName());
        json.put("id", (Object)build.getNumber());
        json.put("startedBy", (Object)this.getStartedBy(build));
        HashMap<String, ReleaseWebHook> nameToWebHookMap = new HashMap<String, ReleaseWebHook>();
        for (ReleaseWebHook webHook2 : ReleaseWebHookHelper.getReleaseWebHookConfigurations()) {
            nameToWebHookMap.put(webHook2.getWebHookName(), webHook2);
        }
        ArrayList<ReleaseWebHookStatus> webHookStatus = new ArrayList<ReleaseWebHookStatus>();
        webHook2 = null;
        for (ReleaseWebHookReference webHookName : this.webHookReferences) {
            if (!nameToWebHookMap.containsKey(webHookName.getWebHookName())) continue;
            try {
                webHook2 = (ReleaseWebHook)((Object)nameToWebHookMap.get(webHookName.getWebHookName()));
                logger.fine(String.format("Sending payload event to %s", webHook2.getPayloadUrl()));
                ReleaseWebHookStatus status = this.sendJobCompletedEvent(json, webHook2);
                webHookStatus.add(status);
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "", ex);
                webHookStatus.add(new ReleaseWebHookStatus(webHook2.getPayloadUrl(), 500, ex.toString()));
            }
        }
        build.addAction((Action)new ReleaseWebHookSummaryAction(webHookStatus));
        return true;
    }

    private ReleaseWebHookStatus sendJobCompletedEvent(JSONObject json, ReleaseWebHook webHook) throws IOException, NoSuchAlgorithmException, InvalidKeyException {
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpPost request = new HttpPost(webHook.getPayloadUrl());
        String payload = json.toString();
        request.addHeader("Content-Type", "application/json");
        request.addHeader("Accept", "application/json; api-version=5.0-preview");
        if (!StringUtils.isBlank((String)webHook.getSecret())) {
            String signature = ReleaseWebHookHelper.getPayloadSignature(webHook.getSecret(), payload);
            request.addHeader("X-Jenkins-Signature", signature);
        }
        request.setEntity((HttpEntity)new StringEntity(new String(payload.getBytes("UTF-8"))));
        HttpResponse response = client.execute((HttpUriRequest)request);
        int statusCode = response.getStatusLine().getStatusCode();
        ReleaseWebHookStatus status = null;
        if (statusCode == 200) {
            logger.log(Level.INFO, "sent event payload successfully");
            status = new ReleaseWebHookStatus(webHook.getPayloadUrl(), statusCode);
        } else {
            HttpEntity entity = response.getEntity();
            String content = EntityUtils.toString((HttpEntity)entity);
            logger.log(Level.WARNING, "Cannot send the event to webhook. Content:" + content);
            status = new ReleaseWebHookStatus(webHook.getPayloadUrl(), statusCode, content);
        }
        return status;
    }

    private String getStartedBy(AbstractBuild build) {
        Cause.UserIdCause cause = (Cause.UserIdCause)build.getCause(Cause.UserIdCause.class);
        String startedBy = "";
        if (cause != null && cause.getUserId() != null) {
            startedBy = cause.getUserId();
        }
        return startedBy;
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "Azure Devops Server/Services Release Webhook";
        }
    }
}

