/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs.rm;

import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class ReleaseWebHook
extends AbstractDescribableImpl<ReleaseWebHook> {
    private static final Logger logger = Logger.getLogger(ReleaseWebHook.class.getName());
    private final String webHookName;
    private final String payloadUrl;
    private final String secret;

    @DataBoundConstructor
    public ReleaseWebHook(String webHookName, String payloadUrl, String secret) {
        this.webHookName = webHookName;
        this.payloadUrl = payloadUrl;
        this.secret = secret;
    }

    public ReleaseWebHook(String webHookName, String payloadUrl) {
        this.webHookName = webHookName;
        this.payloadUrl = payloadUrl;
        this.secret = "";
    }

    public String getWebHookName() {
        return this.webHookName;
    }

    public String getPayloadUrl() {
        return this.payloadUrl;
    }

    public String getSecret() {
        return this.secret;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<ReleaseWebHook> {
        public String getDisplayName() {
            return "Release Webhook";
        }

        public FormValidation doCheckPayloadUrl(@QueryParameter String value) {
            URI uri;
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.warning((String)"Please provide a value");
            }
            try {
                uri = new URI(value);
            }
            catch (URISyntaxException e) {
                return FormValidation.error((String)"Malformed Payload URL (%s)", (Object[])new Object[]{e.getMessage()});
            }
            String hostName = uri.getHost();
            if (StringUtils.isBlank((String)hostName)) {
                return FormValidation.error((String)"Please provide a host name");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckWebHookName(@QueryParameter String value) {
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.error((String)"Please provide a value");
            }
            String pattern = "^[A-Za-z0-9_-]+$";
            if (!value.matches(pattern)) {
                return FormValidation.error((String)"Only allowed characters are alphaphetic, numeric, hypen and underscore");
            }
            return FormValidation.ok();
        }
    }
}

