/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs.rm;

import com.fasterxml.jackson.databind.ObjectMapper;
import hudson.model.AbstractProject;
import hudson.model.Item;
import hudson.plugins.tfs.TeamPluginGlobalConfig;
import hudson.plugins.tfs.model.AbstractHookEvent;
import hudson.plugins.tfs.model.servicehooks.Event;
import hudson.plugins.tfs.rm.ReleaseWebHook;
import hudson.plugins.tfs.rm.ReleaseWebHookAction;
import hudson.plugins.tfs.rm.ReleaseWebHookHelper;
import hudson.plugins.tfs.rm.ReleaseWebHookReference;
import hudson.plugins.tfs.rm.ReleaseWebHookResource;
import hudson.tasks.Publisher;
import hudson.util.DescribableList;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;

public class ConnectReleaseWebHookEvent
extends AbstractHookEvent {
    private static final Logger logger = Logger.getLogger(ReleaseWebHookAction.class.getName());
    private static final String CREATE_WEBHOOK_EVENTNAME = "rmwebhook-create";
    private static final String REMOVE_WEBHOOK_ENENTNAME = "rmwebhook-remove";
    private static final String LIST_WEBHOOK_EVENTNAME = "rmwebhook-list";
    private static final String LINK_WEBHOOK_EVENTNAME = "rmwebhook-link";
    private static final String UNLINK_WEBHOOK_EVENTNAME = "rmwebhook-unlink";

    @Override
    public JSONObject perform(ObjectMapper mapper, Event event, String message, String detailedMessage) {
        Object resource = event.getResource();
        ReleaseWebHookResource parameters = (ReleaseWebHookResource)mapper.convertValue(resource, ReleaseWebHookResource.class);
        if (event.getEventType().equalsIgnoreCase(CREATE_WEBHOOK_EVENTNAME)) {
            this.createReleaseWebHook(parameters);
        } else if (event.getEventType().equalsIgnoreCase(REMOVE_WEBHOOK_ENENTNAME)) {
            this.deleteReleaseWebHook(parameters);
        } else {
            if (event.getEventType().equalsIgnoreCase(LIST_WEBHOOK_EVENTNAME)) {
                return this.listReleaseWebHook();
            }
            if (event.getEventType().equalsIgnoreCase(LINK_WEBHOOK_EVENTNAME)) {
                this.linkWebHook(parameters);
            } else if (event.getEventType().equalsIgnoreCase(UNLINK_WEBHOOK_EVENTNAME)) {
                this.unlinkWebHook(parameters);
            } else {
                throw new UnsupportedOperationException("Webhook operation " + parameters.getOperationType() + " is not supported");
            }
        }
        return JSONObject.fromObject((Object)event);
    }

    private String validateAndGetPayloadUrl(ReleaseWebHookResource parameters) {
        URI uri;
        String payloadUrl = parameters.getPayloadUrl();
        if (StringUtils.isBlank((String)payloadUrl)) {
            throw new InvalidParameterException("PayloadUrl is empty");
        }
        try {
            uri = new URI(payloadUrl);
        }
        catch (URISyntaxException e) {
            throw new InvalidParameterException("Malformed Payload URL " + e.getMessage());
        }
        String hostName = uri.getHost();
        if (StringUtils.isBlank((String)hostName)) {
            throw new InvalidParameterException("Payload URL is empty");
        }
        return StringUtils.stripEnd((String)StringUtils.trim((String)payloadUrl), (String)"/");
    }

    private AbstractProject validateAndGetJenkinsProject(ReleaseWebHookResource resource) {
        String projectName = resource.getProjectName();
        if (StringUtils.isBlank((String)projectName)) {
            throw new InvalidParameterException("Project name is empty");
        }
        for (Item project : Jenkins.getActiveInstance().getAllItems()) {
            if (!(project instanceof AbstractProject) || !project.getFullName().equalsIgnoreCase(projectName)) continue;
            return (AbstractProject)project;
        }
        throw new InvalidParameterException("Cannot find Jenkins Project with the name " + resource.getProjectName());
    }

    private ReleaseWebHook validateAndGetReleaseWebHookByName(String webHookName) {
        ReleaseWebHook webHook = null;
        for (ReleaseWebHook webHookItem : ReleaseWebHookHelper.getReleaseWebHookConfigurations()) {
            if (!webHookItem.getWebHookName().equalsIgnoreCase(webHookName)) continue;
            webHook = webHookItem;
            logger.fine(String.format("WebHook found for webhook name %s", webHookName));
            break;
        }
        if (webHook == null) {
            throw new InvalidParameterException(String.format("Cannot find webhook with the name %s", webHookName));
        }
        return webHook;
    }

    private void createReleaseWebHook(ReleaseWebHookResource resource) {
        if (resource == null) {
            throw new InvalidParameterException("resource is null");
        }
        String payloadUrl = this.validateAndGetPayloadUrl(resource);
        String secret = resource.getSecret();
        String webHookName = resource.getWebHookName();
        if (StringUtils.isBlank((String)webHookName)) {
            throw new InvalidParameterException("webhook name is empty");
        }
        List<ReleaseWebHook> releaseWebHooks = ReleaseWebHookHelper.getReleaseWebHookConfigurations();
        for (ReleaseWebHook webHook : releaseWebHooks) {
            if (!webHook.getWebHookName().equalsIgnoreCase(webHookName)) continue;
            if (webHook.getPayloadUrl().equalsIgnoreCase(payloadUrl)) {
                logger.fine(String.format("WebHook with the name %s and payloadUrl %s already exists", webHookName, payloadUrl));
                return;
            }
            throw new InvalidParameterException(String.format("WebHook with the name %s already exists. Provide a unique name for the ReleaseWebHook", webHookName));
        }
        ReleaseWebHook webHook = new ReleaseWebHook(webHookName, payloadUrl, secret);
        releaseWebHooks.add(webHook);
        ReleaseWebHookHelper.saveReleaseWebHookConfigurations(releaseWebHooks);
    }

    private void deleteReleaseWebHook(ReleaseWebHookResource resource) {
        if (resource == null) {
            throw new InvalidParameterException("resource is null");
        }
        TeamPluginGlobalConfig config = TeamPluginGlobalConfig.get();
        if (config == null) {
            throw new InternalError("Cannot load TFS global configuration");
        }
        String webHookNameToDelete = resource.getWebHookName();
        ReleaseWebHook webHook = this.validateAndGetReleaseWebHookByName(webHookNameToDelete);
        for (Item projectItem : Jenkins.getActiveInstance().getAllItems()) {
            AbstractProject project;
            ReleaseWebHookAction action;
            if (!(projectItem instanceof AbstractProject) || (action = this.getReleaseWebHookActionFromProject(project = (AbstractProject)projectItem)) == null) continue;
            for (ReleaseWebHookReference webHookReference : action.getWebHookReferences()) {
                if (!webHookReference.getWebHookName().equalsIgnoreCase(webHookNameToDelete)) continue;
                throw new UnsupportedOperationException(String.format("WebHook %s is referenced in project %s. Cannot delete until all the references are removed.", webHookNameToDelete, project.getName()));
            }
        }
        List<ReleaseWebHook> releaseWebHooks = ReleaseWebHookHelper.getReleaseWebHookConfigurations();
        releaseWebHooks.remove((Object)webHook);
        ReleaseWebHookHelper.saveReleaseWebHookConfigurations(releaseWebHooks);
    }

    private JSONObject listReleaseWebHook() {
        JSONArray webHooks = new JSONArray();
        for (ReleaseWebHook webHookConfig : ReleaseWebHookHelper.getReleaseWebHookConfigurations()) {
            JSONObject webHook = new JSONObject();
            webHook.put("WebHookName", (Object)webHookConfig.getWebHookName());
            webHook.put("PayloadUrl", (Object)webHookConfig.getPayloadUrl());
            webHooks.add((Object)webHook);
        }
        JSONObject result = new JSONObject();
        result.put("ReleaseWebHooks", (Object)webHooks);
        return result;
    }

    private void linkWebHook(ReleaseWebHookResource resource) {
        List<ReleaseWebHookReference> webHookReferences;
        if (resource == null) {
            throw new InvalidParameterException("resource is null");
        }
        AbstractProject project = this.validateAndGetJenkinsProject(resource);
        String webHookNameToLink = resource.getWebHookName();
        ReleaseWebHook webHook = this.validateAndGetReleaseWebHookByName(webHookNameToLink);
        ReleaseWebHookAction action = this.getReleaseWebHookActionFromProject(project);
        if (action != null && action.getWebHookReferences() != null) {
            for (ReleaseWebHookReference webHookReference : action.getWebHookReferences()) {
                if (!webHookReference.getWebHookName().equalsIgnoreCase(webHookNameToLink)) continue;
                logger.fine(String.format("WebHook %s already added in the project %s", webHookNameToLink, project.getName()));
                return;
            }
        }
        ReleaseWebHookReference webHookReference = new ReleaseWebHookReference(webHookNameToLink);
        if (action == null) {
            webHookReferences = new ArrayList<ReleaseWebHookReference>();
            webHookReferences.add(webHookReference);
            action = new ReleaseWebHookAction(webHookReferences);
            DescribableList publishersList = project.getPublishersList();
            publishersList.add((Object)action);
        } else {
            webHookReferences = action.getWebHookReferences();
            if (webHookReferences == null) {
                webHookReferences = new ArrayList<ReleaseWebHookReference>();
            }
            webHookReferences.add(webHookReference);
            action.setWebHookReferences(webHookReferences);
            logger.fine(String.format("WebHook %s is linked to project %s", new Object[]{webHookReference, project}));
        }
        this.saveProject(project);
    }

    private void unlinkWebHook(ReleaseWebHookResource resource) {
        if (resource == null) {
            throw new InvalidParameterException("resource is null");
        }
        AbstractProject project = this.validateAndGetJenkinsProject(resource);
        String webHookNameToUnlink = resource.getWebHookName();
        if (StringUtils.isBlank((String)webHookNameToUnlink)) {
            throw new InvalidParameterException("webhook name is empty");
        }
        ReleaseWebHookAction action = this.getReleaseWebHookActionFromProject(project);
        if (action == null) {
            logger.fine(String.format("Cannot find ReleaseWebHook post build action", new Object[0]));
            return;
        }
        List<ReleaseWebHookReference> webHookReferences = action.getWebHookReferences();
        for (ReleaseWebHookReference webHookReference : webHookReferences) {
            if (!webHookReference.getWebHookName().equalsIgnoreCase(webHookNameToUnlink)) continue;
            logger.fine(String.format("Found webhook %s in project %s. Removing it", webHookNameToUnlink, project.getName()));
            webHookReferences.remove((Object)webHookReference);
            if (webHookReferences.isEmpty()) {
                logger.fine(String.format("ReleaseWebHook post build action is empty, removing the post build action from project", new Object[0]));
                DescribableList publishersList = project.getPublishersList();
                publishersList.remove((Object)action);
            }
            this.saveProject(project);
            return;
        }
        logger.fine(String.format("Cannnot find webhook with the name %s in project %s", webHookNameToUnlink, project.getName()));
    }

    private ReleaseWebHookAction getReleaseWebHookActionFromProject(AbstractProject project) {
        if (project == null) {
            return null;
        }
        ReleaseWebHookAction action = null;
        DescribableList publishersList = project.getPublishersList();
        for (Publisher publisher : publishersList) {
            if (!(publisher instanceof ReleaseWebHookAction)) continue;
            action = (ReleaseWebHookAction)publisher;
        }
        return action;
    }

    private void saveProject(AbstractProject project) {
        if (project != null) {
            try {
                project.save();
            }
            catch (IOException ex) {
                throw new InternalError(String.format("Updating project %s failed with an error %s", project.getName(), ex.getMessage()));
            }
        }
    }

    public static class Factory
    implements AbstractHookEvent.Factory {
        @Override
        public ConnectReleaseWebHookEvent create() {
            return new ConnectReleaseWebHookEvent();
        }

        @Override
        public String getSampleRequestPayload() {
            return "{\n    \"eventType\": rmwebhook-create\n    \"resource\": {       \"webhookName\": \"webhook name\"\n       \"payloadUrl\": \"https://xplatalm.visualstudio.com/_apis/Release/receiveExternalEvent/wenhookId\"\n       \"secret\": \"secret\"\n     }}";
        }
    }
}

