/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs.model.servicehooks;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

public enum EventScope {
    All,
    Project,
    Team,
    Collection,
    Account,
    Deployment;

    private static final Map<String, EventScope> CASE_INSENSITIVE_LOOKUP;

    @JsonCreator
    public static EventScope caseInsensitiveValueOf(String name) {
        if (name == null) {
            throw new NullPointerException("Name is null");
        }
        if (!CASE_INSENSITIVE_LOOKUP.containsKey(name)) {
            throw new IllegalArgumentException("No enum constant " + name);
        }
        return CASE_INSENSITIVE_LOOKUP.get(name);
    }

    static {
        TreeMap<String, EventScope> map = new TreeMap<String, EventScope>(String.CASE_INSENSITIVE_ORDER);
        for (EventScope value : EventScope.values()) {
            map.put(value.name(), value);
        }
        CASE_INSENSITIVE_LOOKUP = Collections.unmodifiableMap(map);
    }
}

