/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs.model;

import hudson.plugins.tfs.commands.DeleteWorkspaceCommand;
import hudson.plugins.tfs.commands.GetWorkspaceMappingCommand;
import hudson.plugins.tfs.commands.ListWorkspacesCommand;
import hudson.plugins.tfs.commands.NewWorkspaceCommand;
import hudson.plugins.tfs.model.Server;
import hudson.plugins.tfs.model.Workspace;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Workspaces
implements ListWorkspacesCommand.WorkspaceFactory {
    private Map<String, Workspace> workspaces = new HashMap<String, Workspace>();
    private Server server;
    private boolean mapIsPopulatedFromServer;

    public Workspaces(Server server) {
        this.server = server;
    }

    private List<Workspace> getListFromServer() {
        ListWorkspacesCommand command = new ListWorkspacesCommand(this.server);
        List<Workspace> result = this.server.execute(command.getCallable());
        return result;
    }

    private void populateMapFromServer() {
        if (!this.mapIsPopulatedFromServer) {
            for (Workspace workspace : this.getListFromServer()) {
                this.workspaces.put(workspace.getName(), workspace);
            }
            this.mapIsPopulatedFromServer = true;
        }
    }

    public Workspace getWorkspace(String workspaceName) {
        if (!this.workspaces.containsKey(workspaceName)) {
            this.populateMapFromServer();
        }
        return this.workspaces.get(workspaceName);
    }

    public boolean exists(String workspaceName) {
        if (!this.workspaces.containsKey(workspaceName)) {
            this.populateMapFromServer();
        }
        return this.workspaces.containsKey(workspaceName);
    }

    public boolean exists(Workspace workspace) {
        return this.exists(workspace.getName());
    }

    public String getWorkspaceMapping(String localPath) {
        GetWorkspaceMappingCommand command = new GetWorkspaceMappingCommand(this.server, localPath);
        String result = this.server.execute(command.getCallable());
        return result;
    }

    public Workspace newWorkspace(String workspaceName, String serverPath, Collection<String> cloakedPaths, String localPath) {
        NewWorkspaceCommand command = new NewWorkspaceCommand(this.server, workspaceName, serverPath, cloakedPaths, localPath);
        this.server.execute(command.getCallable());
        Workspace workspace = new Workspace(workspaceName);
        this.workspaces.put(workspaceName, workspace);
        return workspace;
    }

    public void deleteWorkspace(Workspace workspace) {
        DeleteWorkspaceCommand command = new DeleteWorkspaceCommand(this.server, workspace.getName());
        this.workspaces.remove(workspace.getName());
        this.server.execute(command.getCallable());
    }

    @Override
    public Workspace createWorkspace(String name, String computer, String owner, String comment) {
        return new Workspace(name, computer, owner, comment);
    }
}

