/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs.model;

import hudson.ProxyConfiguration;
import hudson.plugins.tfs.model.ProxyHostEx;
import hudson.util.Secret;
import java.io.Serializable;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class WebProxySettings
implements Serializable {
    private static final long serialVersionUID = 401L;
    private final String hostName;
    private final int port;
    private final String proxyUser;
    private final Secret proxySecret;
    private final List<Pattern> noProxyHostPatterns;

    private WebProxySettings() {
        this(null, -1, null, null, null);
    }

    public WebProxySettings(String hostName, int port, List<Pattern> noProxyHostPatterns, String proxyUser, Secret proxySecret) {
        this.hostName = hostName;
        this.port = port;
        this.noProxyHostPatterns = WebProxySettings.copyNoProxyHostPatterns(noProxyHostPatterns);
        this.proxyUser = proxyUser;
        this.proxySecret = proxySecret;
    }

    public WebProxySettings(ProxyConfiguration proxyConfiguration) {
        if (proxyConfiguration != null) {
            this.hostName = proxyConfiguration.name;
            this.port = proxyConfiguration.port;
            this.proxyUser = proxyConfiguration.getUserName();
            this.noProxyHostPatterns = WebProxySettings.copyNoProxyHostPatterns(proxyConfiguration.getNoProxyHostPatterns());
            this.proxySecret = Secret.fromString((String)proxyConfiguration.getEncryptedPassword());
        } else {
            this.hostName = null;
            this.port = -1;
            this.proxyUser = null;
            this.proxySecret = null;
            this.noProxyHostPatterns = WebProxySettings.copyNoProxyHostPatterns(null);
        }
    }

    private static ArrayList<Pattern> copyNoProxyHostPatterns(List<Pattern> noProxyHostPatterns) {
        return new ArrayList<Pattern>(noProxyHostPatterns == null ? Collections.emptyList() : noProxyHostPatterns);
    }

    public ProxyHostEx toProxyHost(String hostToProxy) {
        boolean shouldProxy;
        ProxyHostEx proxyHost = this.hostName != null ? ((shouldProxy = WebProxySettings.shouldProxy(hostToProxy, this.noProxyHostPatterns)) ? new ProxyHostEx(this.hostName, this.port, this.proxyUser, this.proxySecret) : null) : null;
        return proxyHost;
    }

    public Proxy toProxy(String hostToProxy) {
        Proxy proxy;
        if (this.hostName != null) {
            boolean shouldProxy = WebProxySettings.shouldProxy(hostToProxy, this.noProxyHostPatterns);
            if (shouldProxy) {
                InetSocketAddress proxyAddress = new InetSocketAddress(this.hostName, this.port);
                proxy = new Proxy(Proxy.Type.HTTP, proxyAddress);
                if (this.proxyUser != null && this.proxySecret != null) {
                    Authenticator authenticator = new Authenticator(){

                        @Override
                        protected PasswordAuthentication getPasswordAuthentication() {
                            if (StringUtils.equalsIgnoreCase((String)WebProxySettings.this.hostName, (String)this.getRequestingHost())) {
                                return new PasswordAuthentication(WebProxySettings.this.proxyUser, WebProxySettings.this.proxySecret.getPlainText().toCharArray());
                            }
                            return null;
                        }
                    };
                    Authenticator.setDefault(authenticator);
                }
            } else {
                proxy = Proxy.NO_PROXY;
            }
        } else {
            proxy = Proxy.NO_PROXY;
        }
        return proxy;
    }

    static boolean shouldProxy(String host, List<Pattern> noProxyHostPatterns) {
        boolean shouldProxy = true;
        for (Pattern p : noProxyHostPatterns) {
            if (!p.matcher(host).matches()) continue;
            shouldProxy = false;
            break;
        }
        return shouldProxy;
    }

    public String getHostName() {
        return this.hostName;
    }

    public int getPort() {
        return this.port;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public Secret getProxySecret() {
        return this.proxySecret;
    }
}

