/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs.model;

import com.microsoft.tfs.core.clients.webservices.IIdentityManagementService;
import com.microsoft.tfs.core.clients.webservices.IdentitySearchFactor;
import com.microsoft.tfs.core.clients.webservices.MembershipQuery;
import com.microsoft.tfs.core.clients.webservices.ReadIdentityOptions;
import com.microsoft.tfs.core.clients.webservices.TeamFoundationIdentity;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.plugins.tfs.model.UserAccountMapper;
import hudson.plugins.tfs.model.UserLookup;
import hudson.tasks.Mailer;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TfsUserLookup
implements UserLookup {
    private static final Logger logger = Logger.getLogger(TfsUserLookup.class.getName());
    private final IIdentityManagementService ims;
    private final UserAccountMapper userAccountMapper;

    public TfsUserLookup(IIdentityManagementService ims, UserAccountMapper userAccountMapper) {
        this.ims = ims;
        this.userAccountMapper = userAccountMapper;
    }

    @Override
    public User find(String accountName) {
        String mappedAccountName = this.userAccountMapper.mapUserAccount(accountName);
        logger.log(Level.FINE, String.format("Looking up Jenkins user for account '%s'.", mappedAccountName));
        User jenkinsUser = User.get((String)mappedAccountName);
        Mailer.UserProperty mailerProperty = (Mailer.UserProperty)jenkinsUser.getProperty(Mailer.UserProperty.class);
        if (mailerProperty == null || mailerProperty.getAddress() == null || mailerProperty.getAddress().length() == 0) {
            logger.log(Level.FINE, String.format("No Mailer.UserProperty defined for '%s', looking in TFS", mappedAccountName));
            TeamFoundationIdentity tfsUser = this.ims.readIdentity(IdentitySearchFactor.ACCOUNT_NAME, accountName, MembershipQuery.NONE, ReadIdentityOptions.NONE);
            if (tfsUser != null) {
                String displayName = tfsUser.getDisplayName();
                jenkinsUser.setFullName(displayName);
                String emailAddress = (String)tfsUser.getProperty("Mail");
                if (emailAddress != null) {
                    mailerProperty = new Mailer.UserProperty(emailAddress);
                    try {
                        jenkinsUser.addProperty((UserProperty)mailerProperty);
                    }
                    catch (IOException e) {
                        logger.warning(String.format("Unable to save Jenkins account for  user '%s'.", accountName));
                    }
                } else {
                    logger.info(String.format("User '%s' did not have an e-mail address configured.", accountName));
                }
            } else {
                logger.warning(String.format("Unable to find user '%s'.", accountName));
            }
        }
        return jenkinsUser;
    }
}

