/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tfs.model;

import hudson.Extension;
import hudson.FilePath;
import hudson.model.AbstractDescribableImpl;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.plugins.tfs.model.TeamResultType;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class TeamRequestedResult
extends AbstractDescribableImpl<TeamRequestedResult> {
    private final TeamResultType teamResultType;
    private String includes;

    @DataBoundConstructor
    public TeamRequestedResult(TeamResultType teamResultType) {
        this.teamResultType = teamResultType;
    }

    public TeamResultType getTeamResultType() {
        return this.teamResultType;
    }

    public String getIncludes() {
        return this.includes;
    }

    @DataBoundSetter
    public void setIncludes(String includes) {
        this.includes = includes;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<TeamRequestedResult> {
        public String getDisplayName() {
            return "Requested build result";
        }

        public ListBoxModel doFillTeamResultTypeItems() {
            TeamResultType[] values = TeamResultType.values();
            ListBoxModel result = new ListBoxModel(values.length);
            for (TeamResultType value : values) {
                result.add(value.getDisplayName(), value.name());
            }
            return result;
        }

        public FormValidation doCheckIncludes(@AncestorInPath AbstractProject project, @QueryParameter String value) throws IOException {
            if (project == null) {
                return FormValidation.ok();
            }
            return FilePath.validateFileMask((FilePath)project.getSomeWorkspace(), (String)value);
        }
    }
}

